/* sslclnt.h */
/* Copyright (c) 2000-2003 Secure Bridge Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *  1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Secure Bridge
 *    Inc." 
 * 
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Secure Bridge
 *    Inc."
 * 
 * THIS SOFTWARE IS PROVIDED BY THE SECURE BRIDGE INC. ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SECURE BRIDGE INC. 
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
*/ 
#ifndef _SSLCLNT_H_INCLUDED
#define _SSLCLNT_H_INCLUDED

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <sys/stat.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include <memory.h>
#include <netdb.h>

#include <pthread.h>
#include <signal.h>

#define USESSL

#include <openssl/lhash.h>
#include <openssl/bn.h>
#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/x509.h>
#include <openssl/ssl.h>
#include <openssl/e_os.h>
#include <openssl/crypto.h>

#define MAJORVERSION "0"
#define MINORVERSION "1.0"

#define MIN_CLIENTS 1
#define MAX_CLIENTS 1022

#define OPENSSLDIR ".."
#define DEFAULT_CIPHER_LIST NULL
#define DEFAULT_CERTIFICATE_FILE OPENSSLDIR"/client.pem"
#define DEFAULT_PRIVATE_KEY_FILE DEFAULT_CERTIFICATE_FILE
#define DEFAULT_CA_CERTIFICATE_FILE OPENSSLDIR"/cert.pem"
#define DEFAULT_CA_PATH NULL
#define DEFAULT_SERVER_ADDRESS "192.168.2.29"
#define DEFAULT_SERVER_PORT 2000

#define DEFAULT_LOG_LEVEL 0
#define DEFAULT_LOG_FILE "/tmp/sslclnt.log"

#define DEFAULT_SCRIPT_FILE "in.fil"
#define MILLTIME(b, a) ( (difftime(b.time, a.time) * 1000) + (b.millitm - a.millitm))
#define INFILE "in.fil"

#define CHK_NULL(x) if ((x)==NULL) exit (1)
#define CHK_ERR(err,s) if ((err)==-1) { perror(s); exit(1); }
#define CHK_SSL(err) if ((err)==-1) { ERR_print_errors_fp(stderr); exit(2); }
#define MAX_BUFFER_SIZE 32

// Debug macros
#ifdef DEBUG
	#define DEBUG_MSG1(a) cout<<a<<"\n";
	#define DEBUG_MSG2(a,b) cout<<a<<b<<"\n";
	#define DEBUG_MSG3(a,b,c) cout<<a<<b<<c<<"\n";
	#define DEBUG_MSG4(a,b,c,d) cout<<a<<b<<c<<d<<"\n";
	#define DEBUG_MSG5(a,b,c,d,e) cout<<a<<b<<c<<d<<e<<"\n";
	#define DEBUG_MSG6(a,b,c,d,e,f) cout<<a<<b<<c<<d<<e<<f<<"\n";
#else // !DEBUG
	#define DEBUG_MSG1(a)
	#define DEBUG_MSG2(a,b)
	#define DEBUG_MSG3(a,b,c)
	#define DEBUG_MSG4(a,b,c,d)
	#define DEBUG_MSG5(a,b,c,d,e)
	#define DEBUG_MSG6(a,b,c,d,e,f)	
#endif // DEBUG


/* To handle the scripts */
struct scripts{
	char **scriptBuf;
	int numScripts;
	};

char* getRequest(scripts *http, int RequestNum);
int ReadScriptFile(FILE *fp, scripts *http);

void PrintSocketError(BIO *log, int errval);
void PrintSSLError(int Err);
void usage(void);
void showHelp(void);
void printVersion(void);
int select_sleep(long millsec);
int RandomDelay(long min, long max);
long putDelay(timeb , timeb , int);
static void sig_pipe(int); /* SIGPIPE handler */

int SSLVerifyCallback(int ok, X509_STORE_CTX * ctx);
int do_clconnect(void *lpvParam);
int do_clrdwr(void *lpvParam) ;
int client_connect(int  &sockfd, int port, char* ipaddr, BIO *) ;
int do_clrand(void *lpvParam) ;
void SSLInfoCallback(SSL *s, int where, int ret);
long BIODumpCallback(BIO *bio, int cmd, const char *argp, 
					int argi, long argl, long ret);

static void LockingCallback(int mode, int type, char *file, int line);
static pthread_mutex_t cryptoLocks[CRYPTO_NUM_LOCKS];
void MultiThreadSetup(void);
void MultiThreadCleanup(void);
#endif
