/*
        
        File:			AtheroJackCard.h
        Program:		AtheroJack
	Author:			Michael Rossberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AtheroJackCARD_H
#define AtheroJackCARD_H

#include <IOKit/IOService.h>
#include <IOKit/IODataQueue.h>
#include <IOKit/IOTimerEventSource.h>
#include "AtheroJackFrame.h"
#include "OpenHAL.h"
#include "ah_desc.h"

#define RX_QUEUE_SIZE 40

struct ar5213_buf {
    struct ar5213_desc      *rxDesc;            /* virtual addr of desc */
    IOPhysicalAddress       rxDescPhy;          /* physical addr of desc */
    void                    *rxBuf;             /* skbuff for buf */
    IOMemoryDescriptor      *rxBufMemDesc;	
    IOPhysicalAddress       rxBufPhy;           /* physical addr of skb data */
};


class AtheroJackCard {
public:
    AtheroJackCard(void* ioBase, void* keyLargoBase, IOService* parent, int alignSize);
    ~AtheroJackCard();

    IOReturn getChannel(UInt16* channel);
    IOReturn setChannel(UInt16 channel);
    
    IOReturn startCapture(IODataQueue*, UInt16);
    IOReturn stopCapture();
    IOReturn sendFrame(UInt8* data, UInt32 repeat);
    IOReturn stopSendingFrames();
    IOReturn cardGone();
    
    void enableInterrupts();
    void disableInterrupts();
    IOReturn handleInterrupt();
    
private:
    /*
     * Private methods
     */
    static void 	_myTimeoutHandler(OSObject *owner, IOTimerEventSource *sender);
    IOReturn	 	_sendFrame(UInt8* data, IOByteCount size);
    IOReturn 		_enable();
    IOReturn 		_disable();
    
    IOReturn            _init();
    IOReturn            _setPowerState(UInt32 state);
    IOReturn            _suspend();
    IOReturn            _resume();
    
    IOReturn            _reset(UInt32 val);
    
    IOReturn            _setupRxRing();
    IOReturn            _freeRxRing();
    
    IOReturn            __rxBufInit(struct ar5213_buf *buf);

    
    /*
     * Event handlers
     */
    IOReturn _handleRx();
    IOReturn _handleTx();
    IOReturn _handleTxExc();
    IOReturn _handleAlloc();
    IOReturn _handleCmd();
    IOReturn _handleInfo();

    
    /*
     * Private data members
     */
    void*  _ioBase;
    UInt8  _wcReg[5];
    UInt16 _interrupts;
    UInt32 _alignSize;
    
    int    _cardPresent;
    bool   _isEnabled;
    
    IODataQueue* _packetQueue;
    
    IOTimerEventSource	*_timedSendSource;
    UInt8		_data[2364];
    IOByteCount		_dataSize;
    UInt32		_timeout;
    UInt32		_failures;
    UInt16		_channel;
    IOWorkLoop		*_workLoop;
    
    IOService		*_parent;
    
    ar5213_buf          _rxQueue[RX_QUEUE_SIZE];
    
    ar5213_desc         *_rxFirstDesc;
    IOPhysicalAddress   _rxQueuePhy;
    IOMemoryDescriptor  *_rxQueueMemDesc;
};

#endif /* AtheroJackCARD_H */
