/*
        
        File:			AtheroJackIDs.h
        Program:		AtheroJack
	Author:			Michael Rossberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

      Every constant starting with AR5K is ripped of Reyk Flöters vt_ar5k driver.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define	IEEE80211_WEP_KEYLEN			5	/* 40bit */
#define	IEEE80211_WEP_IVLEN			3	/* 24bit */
#define	IEEE80211_WEP_KIDLEN			1	/* 1 octet */
#define	IEEE80211_WEP_CRCLEN			4	/* CRC-32 */
#define	IEEE80211_WEP_NKID			4	/* number of key ids */

#define	IEEE80211_CRC_LEN			4

#define	IEEE80211_MAX_LEN   (2300 + IEEE80211_CRC_LEN + \
                             (IEEE80211_WEP_IVLEN + IEEE80211_WEP_KIDLEN + IEEE80211_WEP_CRCLEN))

#define DEFAULT_INTERRUPT_MASK (AR5213_RX | AR5213_RXDESC | AR5213_RXERR | \
                                AR5213_TX | AR5213_TXDESC | AR5213_TXERR | \
                                AR5213_RXEOL | AR5213_RXORN | AR5213_F2ERR)

#define INIT_INTERRUPT_MASK \
			(AR5K_IMR_DPERR | AR5K_IMR_SSERR | AR5K_IMR_MCABT | \
			 AR5K_IMR_TXERR | AR5K_IMR_TXOK | AR5K_IMR_RXORN | \
			 AR5K_IMR_RXEOL | AR5K_IMR_RXERR | AR5K_IMR_RXOK | AR5K_IMR_SWI)
#define FATAL_INTERRUPT_MASK (AR5K_IMR_DPERR|AR5K_IMR_SSERR|AR5K_IMR_MCABT|AR5K_IMR_RXORN)
#define RECEIVE_INTERRUPT_MASK (AR5K_IMR_RXERR | AR5K_IMR_RXOK)
#define TRANSMIT_INTERRUPT_MASK (AR5K_IMR_TXDESC)

/* DMA Control and Interrupt Registers */
#define AR5K_TXDP0 0x0000 
#define AR5K_TXDP1 0x0004 

#define AR5K_CR 0x0008 
#define AR5K_CR_TXE0 0x00000001 
#define AR5K_CR_TXE1 0x00000002 
#define AR5K_CR_RXE 0x00000004 
#define AR5K_CR_TXD0 0x00000008 
#define AR5K_CR_TXD1 0x00000010 
#define AR5K_CR_RXD 0x00000020 
#define AR5K_CR_SWI 0x00000040 

#define AR5K_RXDP 0x000C 

#define AR5K_CFG 0x0014 
#define AR5K_CFG_SWTD 0x00000001 
#define AR5K_CFG_SWTB 0x00000002 
#define AR5K_CFG_SWRD 0x00000004 
#define AR5K_CFG_SWRB 0x00000008 
#define AR5K_CFG_SWRG 0x00000010 
#define AR5K_CFG_PHOK 0x00000100 
#define AR5K_CFG_EEBS 0x00000200 
#define AR5K_CFG_TXCNT_M 0x00007800 
#define AR5K_CFG_TXCNT_S 11 
#define AR5K_CFG_TXFSTAT 0x00008000 
#define AR5K_CFG_TXFSTRT 0x00010000 

#define AR5K_ISR 0x001c 
#define AR5K_ISR_RXOK 0x00000001 
#define AR5K_ISR_RXDESC 0x00000002 
#define AR5K_ISR_RXERR 0x00000004 
#define AR5K_ISR_RXNOPKT 0x00000008 
#define AR5K_ISR_RXEOL 0x00000010 
#define AR5K_ISR_RXORN 0x00000020 
#define AR5K_ISR_TXOK 0x00000040 
#define AR5K_ISR_TXDESC 0x00000080 
#define AR5K_ISR_TXERR 0x00000100 
#define AR5K_ISR_TXNOPKT 0x00000200 
#define AR5K_ISR_TXEOL 0x00000400 
#define AR5K_ISR_TXURN 0x00000800 
#define AR5K_ISR_MIB 0x00001000 
#define AR5K_ISR_SWI 0x00002000 
#define AR5K_ISR_RXPHY 0x00004000 
#define AR5K_ISR_RXKCM 0x00008000 
#define AR5K_ISR_SWBA 0x00010000 
#define AR5K_ISR_BRSSI 0x00020000 
#define AR5K_ISR_BMISS 0x00040000 
#define AR5K_ISR_F2ERR 0x00080000 
#define AR5K_ISR_MCABT 0x00100000 
#define AR5K_ISR_SSERR 0x00200000 
#define AR5K_ISR_DPERR 0x00400000 
#define AR5K_ISR_GPIO 0x01000000 
#define AR5K_ISR_RESV0 0xFE000000 

#define AR5K_IMR_5210 0x0020 
#define AR5K_IMR_RXOK 0x00000001 
#define AR5K_IMR_RXDESC 0x00000002 
#define AR5K_IMR_RXERR 0x00000004 
#define AR5K_IMR_RXNOPKT 0x00000008 
#define AR5K_IMR_RXEOL 0x00000010 
#define AR5K_IMR_RXORN 0x00000020 
#define AR5K_IMR_TXOK 0x00000040 
#define AR5K_IMR_TXDESC 0x00000080 
#define AR5K_IMR_TXERR 0x00000100 
#define AR5K_IMR_TXNOPKT 0x00000200 
#define AR5K_IMR_TXEOL 0x00000400 
#define AR5K_IMR_TXURN 0x00000800 
#define AR5K_IMR_MIB 0x00001000 
#define AR5K_IMR_SWI 0x00002000 
#define AR5K_IMR_RXPHY 0x00004000 
#define AR5K_IMR_RXKCM 0x00008000 
#define AR5K_IMR_SWBA 0x00010000 
#define AR5K_IMR_BRSSI 0x00020000 
#define AR5K_IMR_BMISS 0x00040000 
#define AR5K_IMR_F2ERR 0x00080000 
#define AR5K_IMR_MCABT 0x00100000 
#define AR5K_IMR_SSERR 0x00200000 
#define AR5K_IMR_DPERR 0x00400000 
#define AR5K_IMR_GPIO 0x01000000 
#define AR5K_IMR_RESV0 0xFE000000 
#define AR5K_IMR_X 0x0000FFFF 

#define AR5K_IMR_5213    0x00A0 
#define AR5213_RX	 0x00000001
#define AR5213_RXDESC	 0x00000002
#define AR5213_RXERR     0x00000004 
#define AR5213_RXNOFRM	 0x00000008
#define AR5213_RXEOL	 0x00000010
#define AR5213_RXORN	 0x00000020
#define AR5213_TX	 0x00000040
#define AR5213_TXDESC	 0x00000080
#define AR5213_TXERR     0x00000100 
#define AR5213_TXURN	 0x00000800
#define AR5213_MIB	 0x00001000
#define AR5213_RXPHY	 0x00004000
#define AR5213_RXKCM	 0x00008000
#define AR5213_SWBA	 0x00010000
#define AR5213_BMISS	 0x00040000
#define AR5213_F2ERR     0x00080000 
#define AR5213_MCABT     0x00100000 
#define AR5213_GPIO	 0x01000000
#define AR5213_FATAL	 0x40000000

#define AR5K_IER 0x0024 
#define AR5K_IER_ENABLE 0x00000001 
#define AR5K_IER_DISABLE 0x00000000 

#define AR5K_BCR 0x0028 
#define AR5K_BCR_APMODE 0x00000000 
#define AR5K_BCR_STAMODE 0x00000001 
#define AR5K_BCR_BDMAE 0x00000002 
#define AR5K_BCR_TQ1PV 0x00000004 
#define AR5K_BCR_TQ1V 0x00000008 
#define AR5K_BCR_BCGET 0x00000010 

#define AR5K_BSR 0x002c 
#define AR5K_BSR_BDLYSW 0x00000001 
#define AR5K_BSR_BDLYDMA 0x00000002 
#define AR5K_BSR_TXQ1F 0x00000004 
#define AR5K_BSR_ATIMDLY 0x00000008 
#define AR5K_BSR_SNPBCMD 0x00000010 
#define AR5K_BSR_SNPBDMAE 0x00000020 
#define AR5K_BSR_SNPTQ1FV 0x00000040 
#define AR5K_BSR_SNPTQ1V 0x00000080 
#define AR5K_BSR_SNP_VALID 0x00000100 
#define AR5K_BSR_SWBACNT_M 0x00FF0000 
#define AR5K_BSR_SWBACNT_S 16 

#define AR5K_TXCFG 0x0030 
#define AR5K_TXCFG_TXFSTP 0x00000008 
#define AR5K_TXCFG_TXFULL 0x00000070 
#define AR5K_TXCFG_CONT_EN 0x00000080 

#define AR5K_RXCFG 0x0034 
#define AR5K_RXCFG_ZLFDMA 0x00000010 

#define AR5K_DMASIZE_4B 0x00000000 
#define AR5K_DMASIZE_8B 0x00000001 
#define AR5K_DMASIZE_16B 0x00000002 
#define AR5K_DMASIZE_32B 0x00000003 
#define AR5K_DMASIZE_64B 0x00000004 
#define AR5K_DMASIZE_128B 0x00000005 
#define AR5K_DMASIZE_256B 0x00000006 
#define AR5K_DMASIZE_512B 0x00000007 

#define AR5K_MIBC 0x0040 
#define AR5K_MIBC_COW 0x00000001 
#define AR5K_MIBC_FMC 0x00000002 
#define AR5K_MIBC_CMC 0x00000004 
#define AR5K_MIBC_MCS 0x00000008 

#define AR5K_TOPS 0x0044 
#define AR5K_TOPS_MASK 0x0000FFFF 

#define AR5K_RXNPTO 0x0048 
#define AR5K_RXNPTO_MASK 0x000003FF 

#define AR5K_TXNPTO 0x004C 
#define AR5K_TXNPTO_MASK 0x000003FF 

#define AR5K_RPGTO 0x0050 
#define AR5K_RPGTO_MASK 0x000003FF 

#define AR5K_RPCNT 0x0054 
#define AR5K_RPCNT_MASK 0x0000001F 
 
#define AR5K_MACMISC 0x0058 
#define AR5K_MISC_LED_DELAY_M 0x001C0000 
#define AR5K_MISC_LED_DELAY_S 18 
#define AR5K_MISC_LED_BLINK_M 0x00E00000 
#define AR5K_MISC_LED_BLINK_S 21 

#define AR5213_ISR 0x00C0

/* DMA & PCI Registers in PCI space (usable during sleep) */
#define AR5K_RC 0x4000 
#define AR5K_RC_PCU 0x00000001 
#define AR5K_RC_DMA 0x00000002 
#define AR5K_RC_MAC 0x00000004 
#define AR5K_RC_PHY 0x00000008 
#define AR5K_RC_PCI 0x00000010 

#define AR5K_SCR 0x4004 
#define AR5213_SCR_COMPL_SLEEP 0x00000001
#define AR5213_SCR_NET_SLEEP    0x00000002

#define AR5K_SCR_SLDUR_MASK 0x0000ffff 
#define AR5K_SCR_SLE_MASK 0x00030000 
#define AR5K_SCR_SLE_FWAKE 0x00000000 
#define AR5K_SCR_SLE_FSLEEP 0x00010000 
#define AR5K_SCR_SLE_NORMAL 0x00020000 
#define AR5K_SCR_SLE_UNITS 0x00000008 

#define AR5K_INTPEND 0x4008 
#define AR5K_INTPEND_TRUE 0x00000001 

#define AR5K_SFR 0x400C 
#define AR5K_SFR_SLEEP 0x00000001 

#define AR5K_PCICFG 0x4010 
#define AR5K_PCICFG_EEAE 0x00000001 
#define AR5K_PCICFG_CLKRUNEN 0x00000004 
#define AR5K_PCICFG_LED_PEND 0x00000020 
#define AR5K_PCICFG_LED_ACT 0x00000040 
#define AR5K_PCICFG_SL_INTEN 0x00000800 
#define AR5K_PCICFG_BCTL    0x00001000 
#define AR5K_PCICFG_SPWR_DN 0x00010000 
#define AR5213_PCICFG_UNKNOWN 0x00FE0000 

#define AR5K_NUM_GPIO 6		

#define AR5K_GPIOCR 0x4014 
#define AR5K_GPIOCR_CR_SHIFT 2 
#define AR5K_GPIOCR_0_CR_N 0x00000000 
#define AR5K_GPIOCR_0_CR_0 0x00000001 
#define AR5K_GPIOCR_0_CR_1 0x00000002 
#define AR5K_GPIOCR_0_CR_A 0x00000003 
#define AR5K_GPIOCR_1_CR_N 0x00000000 
#define AR5K_GPIOCR_1_CR_0 0x00000004 
#define AR5K_GPIOCR_1_CR_1 0x00000008 
#define AR5K_GPIOCR_1_CR_A 0x0000000C 
#define AR5K_GPIOCR_2_CR_N 0x00000000 
#define AR5K_GPIOCR_2_CR_0 0x00000010 
#define AR5K_GPIOCR_2_CR_1 0x00000020 
#define AR5K_GPIOCR_2_CR_A 0x00000030 
#define AR5K_GPIOCR_3_CR_N 0x00000000 
#define AR5K_GPIOCR_3_CR_0 0x00000040 
#define AR5K_GPIOCR_3_CR_1 0x00000080 
#define AR5K_GPIOCR_3_CR_A 0x000000C0 
#define AR5K_GPIOCR_4_CR_N 0x00000000 
#define AR5K_GPIOCR_4_CR_0 0x00000100 
#define AR5K_GPIOCR_4_CR_1 0x00000200 
#define AR5K_GPIOCR_4_CR_A 0x00000300 
#define AR5K_GPIOCR_5_CR_N 0x00000000 
#define AR5K_GPIOCR_5_CR_0 0x00000400 
#define AR5K_GPIOCR_5_CR_1 0x00000800 
#define AR5K_GPIOCR_5_CR_A 0x00000C00 
#define AR5K_GPIOCR_INT_SEL0 0x00000000 
#define AR5K_GPIOCR_INT_SEL1 0x00001000 
#define AR5K_GPIOCR_INT_SEL2 0x00002000 
#define AR5K_GPIOCR_INT_SEL3 0x00003000 
#define AR5K_GPIOCR_INT_SEL4 0x00004000 
#define AR5K_GPIOCR_INT_SEL5 0x00005000 
#define AR5K_GPIOCR_INT_EN 0x00008000 
#define AR5K_GPIOCR_INT_SELL 0x00000000 
#define AR5K_GPIOCR_INT_SELH 0x00010000 

#define AR5K_GPIODO 0x4018 
#define AR5K_GPIODI 0x401C 
#define AR5K_GPIOD_MASK 0x0000002F 

#define AR5K_SREV 0x4020 
#define AR5K_SREV_ID_M 0x000000FF 
#define AR5K_SREV_FPGA 1
#define AR5K_SREV_PHYPLUS 2
#define AR5K_SREV_PHYPLUS_MS 3 
#define AR5K_SREV_CRETE 4
#define AR5K_SREV_CRETE_MS 5 
#define AR5K_SREV_CRETE_MS23 7 
#define AR5K_SREV_CRETE_23 8 

/* EEPROM Registers in the MAC */
#define AR5210_EEPROM_BASE 0x6000 
#define AR5210_EEPROM_RDATA 0x6800 
#define AR5210_EEPROM_STATUS 0x6c00 
#define AR5210_EEPROM_STAT_RDERR 0x0001 
#define AR5210_EEPROM_STAT_RDDONE 0x0002 
#define AR5210_EEPROM_STAT_WRERR 0x0004 
#define AR5210_EEPROM_STAT_WRDONE 0x0008 

#define AR5211_EEPROM_ADDR 0x6000 
#define AR5211_EEPROM_DATA 0x6004
#define AR5211_EEPROM_COMD 0x6008
#define AR5211_EEPROM_COMD_READ 0x0001
#define AR5211_EEPROM_COMD_WRITE 0x0002
#define AR5211_EEPROM_COMD_RESET 0x0003
#define AR5211_EEPROM_STATUS 0x600C
#define AR5211_EEPROM_STAT_RDERR 0x0001
#define AR5211_EEPROM_STAT_RDDONE 0x0002
#define AR5211_EEPROM_STAT_WRERR 0x0003
#define AR5211_EEPROM_STAT_WRDONE 0x0004
#define AR5211_EEPROM_CONF 0x6010

/* MAC PCU Registers */
#define AR5K_STA_ID0 0x8000 
#define AR5K_STA_ID1 0x8004 
#define AR5K_STA_ID1_SADH_MASK 0x0000FFFF 
#define AR5K_STA_ID1_STA_AP 0x00010000 
#define AR5K_STA_ID1_AD_HOC 0x00020000 
#define AR5K_STA_ID1_PWR_SAV 0x00040000 
#define AR5K_STA_ID1_KSRCHDIS 0x00080000 
#define AR5K_STA_ID1_PSPOLLDIS 0x00100000 
#define AR5K_STA_ID1_PCF 0x00200000 
#define AR5K_STA_ID1_DESC_ANT 0x00400000 
#define AR5K_STA_ID1_DEFAULT_ANT 0x00800000 
#define AR5K_STA_ID1_ACKCTS_6MB 0x01000000 

#define AR5K_BSS_ID0 0x8008 
#define AR5K_BSS_ID1 0x800C 
#define AR5K_BSS_ID1_U16_M 0x0000FFFF 
#define AR5K_BSS_ID1_AID_M 0xFFFF0000 
#define AR5K_BSS_ID1_AID_S 0x10 

#define AR5K_SLOT_TIME 0x8010 
#define AR5K_SLOT_TIME_MASK 0x000007FF 

#define AR5K_TIME_OUT 0x8014 
#define AR5K_TIME_OUT_ACK_M 0x00001FFF 
#define AR5K_TIME_OUT_CTS_M 0x1FFF0000 
#define AR5K_TIME_OUT_CTS_S 16 

#define AR5K_RSSI_THR 0x8018 
#define AR5K_RSSI_THR_MASK 0x000000FF 
#define AR5K_RSSI_THR_BM_THR_M 0x00000700 
#define AR5K_RSSI_THR_BM_THR_S 8 

#define AR5K_RETRY_LMT 0x801c 
#define AR5K_RETRY_LMT_SH_M 0x0000000F 
#define AR5K_RETRY_LMT_LG_M 0x000000F0 
#define AR5K_RETRY_LMT_LG_S 4 
#define AR5K_RETRY_LMT_SSH_M 0x00003F00 
#define AR5K_RETRY_LMT_SSH_S 8 
#define AR5K_RETRY_LMT_SLG_M 0x000FC000 
#define AR5K_RETRY_LMT_SLG_S 14 
#define AR5K_RETRY_LMT_CW_M 0x3FF00000 
#define AR5K_RETRY_LMT_CW_S 20 

#define AR5K_USEC 0x8020 
#define AR5K_USEC_M 0x0000007F 
#define AR5K_USEC_32_M 0x00003F80 
#define AR5K_USEC_32_S 7 
#define AR5K_USEC_TX_LAT_M 0x000FC000 
#define AR5K_USEC_TX_LAT_S 14 
#define AR5K_USEC_RX_LAT_M 0x03F00000 
#define AR5K_USEC_RX_LAT_S 20 

#define AR5213_BEACON 0x8020 

#define AR5K_BEACON 0x8024 
#define AR5K_BEACON_PERIOD_MASK 0x0000FFFF 
#define AR5K_BEACON_TIM_MASK 0x007F0000 
#define AR5K_BEACON_TIM_S 16 
#define AR5K_BEACON_EN 0x00800000 
#define AR5K_BEACON_RESET_TSF 0x01000000 

#define AR5K_CFP_PERIOD 0x8028 
#define AR5K_TIMER0 0x802c 
#define AR5K_TIMER1 0x8030 
#define AR5K_TIMER2 0x8034 
#define AR5K_TIMER3 0x8038 

#define AR5K_IFS0 0x8040 
#define AR5K_IFS0_SIFS_M 0x000007FF 
#define AR5K_IFS0_DIFS_M 0x007FF800 
#define AR5K_IFS0_DIFS_S 11 

#define AR5K_IFS1 0x8044 
#define AR5K_IFS1_PIFS_M 0x00000FFF 
#define AR5K_IFS1_EIFS_M 0x03FFF000 
#define AR5K_IFS1_EIFS_S 12 
#define AR5K_IFS1_CS_EN 0x04000000 

#define AR5K_CFP_DUR 0x8048 
#define AR5K_CFP_DUR_DISABLE_RX 0x00000020

#define AR5213_RX_FILTER 0x803C 
#define AR5213_PHY_FILTER 0x810C 

#define AR5K_RX_FILTER 0x804C 
#define AR5K_RX_FILTER_ALL 0x00000000 
#define AR5K_RX_UCAST 0x00000001 
#define AR5K_RX_MCAST 0x00000002 
#define AR5K_RX_BCAST 0x00000004 
#define AR5K_RX_CONTROL 0x00000008 
#define AR5K_RX_BEACON 0x00000010 
#define AR5K_RX_PROM 0x00000020 
#define	AR5K_RX_PROBEREQ 0x00000080

#define AR5K_MCAST_FIL0 0x8050 
#define AR5K_MCAST_FIL1 0x8054 
#define AR5K_TX_MASK0 0x8058 
#define AR5K_TX_MASK1 0x805c 
#define AR5K_CLR_TMASK 0x8060 
#define AR5K_TRIG_LEV 0x8064 

#define AR5K_DIAG_SW 0x8068 
#define AR5K_DIAG_CACHE_ACK 0x00000001 
#define AR5K_DIAG_ACK_DIS 0x00000002 
#define AR5K_DIAG_CTS_DIS 0x00000004 
#define AR5K_DIAG_ENCRYPT_DIS 0x00000008 
#define AR5K_DIAG_DECRYPT_DIS 0x00000010 
#define AR5K_DIAG_TX_DIS 0x00000020 
#define AR5K_DIAG_RX_DIS 0x00000040 
#define AR5K_DIAG_LOOP_EN 0x00000080 
#define AR5K_DIAG_CORR_FCS 0x00000100 
#define AR5K_DIAG_CHAN_INFO 0x00000200 
#define AR5K_DIAG_EN_SCRAMSD 0x00000400 
#define AR5K_DIAG_SCRAM_SEED_M 0x0003F800 
#define AR5K_DIAG_SCRAM_SEED_S 11 
#define AR5K_DIAG_DIS_SEQ_INC 0x00040000 
#define AR5K_DIAG_FRAME_NV0 0x00080000 

#define AR5K_TSF_L32 0x806c 
#define AR5K_TSF_U32 0x8070 
#define AR5K_LAST_TSTP 0x8080 
#define AR5K_RETRY_CNT 0x8084 
#define AR5K_RETRY_CNT_SSH_M 0x0000003F 
#define AR5K_RETRY_CNT_SLG_M 0x00000FC0 
#define AR5K_RETRY_CNT_SLG_S 6 

#define AR5K_BACKOFF 0x8088 
#define AR5K_BACKOFF_CW_M 0x000003FF 
#define AR5K_BACKOFF_CNT_M 0x03FF0000 
#define AR5K_BACKOFF_CNT_S 16 

#define AR5K_NAV 0x808c 
#define AR5K_RTS_OK 0x8090 
#define AR5K_RTS_FAIL 0x8094 
#define AR5K_ACK_FAIL 0x8098 
#define AR5K_FCS_FAIL 0x809C 
#define AR5K_BEACON_CNT 0x80A0 

/*unknown*/
//musthave something to do with filtering?!
#define AR5K_UNKNOWN0 0x803C
#define AR5K_UNKNOWN1 0x810C

/* EEPROM defines for Version 1 */
#define AR5K_EEPROM_REG_DOMAIN_OFFSET 0xBF 
#define AR5K_EEPROM_PROTECT_OFFSET 0x3F 
#define AR5K_EEPROM_ATHEROS_OFFSET 0xC0 
#define AR5K_EEPROM_ATHEROS_ENTRIES 64 
#define AR5K_EEPROM_REG_DOMAINS 4 
#define AR5K_EEPROM_CHANNELS_SUPPORTED 5 
#define AR5K_EEPROM_TP_SETTINGS_OFFSET 0x09 
#define AR5K_EEPROM_TP_SETTINGS_SIZE 11 
#define AR5K_EEPROM_TP_SCALING_ENTRIES 11 

/* EEPROM defines for Version 0 */
#define AR5K_EEPROM_ENTRIES_FOR_TXPOWER 32 
#define AR5K_EEPROM_TXPOWER_OFFSET 0xE0 

/* Protect Bits RP is read protect, WP is write protect */
#define EEPROM_PROTECT_RP_0_31 0x0001
#define EEPROM_PROTECT_WP_0_31 0x0002 
#define EEPROM_PROTECT_RP_32_63 0x0004
#define EEPROM_PROTECT_WP_32_63 0x0008
#define EEPROM_PROTECT_RP_64_127 0x0010
#define EEPROM_PROTECT_WP_64_127 0x0020
#define EEPROM_PROTECT_RP_128_191 0x0040
#define EEPROM_PROTECT_WP_128_191 0x0080
#define EEPROM_PROTECT_RP_192_207 0x0100
#define EEPROM_PROTECT_WP_192_207 0x0200
#define EEPROM_PROTECT_RP_208_223 0x0400
#define EEPROM_PROTECT_WP_208_223 0x0800
#define EEPROM_PROTECT_RP_224_239 0x1000
#define EEPROM_PROTECT_WP_224_239 0x2000
#define EEPROM_PROTECT_RP_240_255 0x4000
#define EEPROM_PROTECT_WP_240_255 0x8000

/* PHY registers */
#define PHY_BASE 0x9800
//?? for 5213
#define PHY_BASE_RESET 0x0000007 

#define PHY_MAGIC 0x98D0
#define PHY_MAGIC2 0x9880
#define PHY_CHIP_VERSION 0x9C00

#define PHY_FRAME_CONTROL 0x9804 
#define PHY_FC_TURBO_MODE 0x00000001 
#define PHY_FC_TURBO_SHORT 0x00000002 
#define PHY_FC_TIMING_ERR 0x01000000 
#define PHY_FC_PARITY_ERR 0x02000000 
#define PHY_FC_ILLRATE_ERR 0x04000000 
#define PHY_FC_ILLLEN_ERR 0x08000000 
#define PHY_FC_SERVICE_ERR 0x20000000 
#define PHY_FC_TX_UNDER_ERR 0x40000000 

#define PHY_CHIP_ID 0x9818 

#define PHY_ACTIVE 0x981C 
#define PHY_ACTIVE_EN 0x00000001 
#define PHY_ACTIVE_DIS 0x00000000 

#define PHY_AGC_CONTROL 0x9860 
#define PHY_AGC_CONTROL_CAL 0x00000001 
#define PHY_AGC_CONTROL_NF 0x00000002 

//?? for 5213
#define PHY_RF_MODE 0x987C
#define PHY_RF_MODE_5GHz 0xAA
#define PHY_RF_MODE_2GHz 0xAB

/* XXX currently unknown registers used for AR5210 business reading */
#define PHY_BUSY_REG0 0x9880
#define PHY_BUSY_REG1 0x98c0 
//?!

/* XXX currently unknown registers used for AR5210 channel setting */
#define PHY_RF_CHANREG0 0x989C
#define PHY_RF_CHANREG1 0x98D0

//?? for 5213
#define AR5213_CHAN_WIFI_MODE 0xA200
#define AR5213_CHAN_WIFI_MODE_A 0x0
#define AR5213_CHAN_WIFI_MODE_B 0x3
#define AR5213_CHAN_WIFI_MODE_G 0x6


#define AR5213_CHAN14_MODE 0xA204
#define AR5213_CHAN14_MODE_ENABLED 0x10

struct channelsetting {
    UInt8 arg1;
    UInt8 arg2;
    UInt8 arg3;
};

const struct channelsetting channel_table_2400[] = {
    {1, 0x46, 0x74 },
    {1, 0x46, 0x74 },   //channel 1
    {1, 0x46, 0x75 },
    {1, 0x46, 0x76 },
    {1, 0x46, 0x77 },
    {1, 0x46, 0x78 },   //channel 5
    {1, 0x46, 0x79 },
    {1, 0x46, 0x7A },
    {1, 0x46, 0x7B },
    {1, 0x46, 0x7C },
    {1, 0x46, 0x7D },   //channel 10
    {1, 0x46, 0x7E },
    {1, 0x46, 0x7F },
    {1, 0x46, 0x80 },   //channel 13
    {1, 0x44, 0x7C },   //channel 14
    {1, 0x46, 0x88 },
    {1, 0x46, 0x8C },
    {1, 0x46, 0x90 },
    {1, 0x46, 0x94 },
    {1, 0x46, 0x98 },
    {1, 0x46, 0x9C },
    {1, 0x46, 0xA0 },
    {1, 0x46, 0xA4 },
    {1, 0x46, 0xA8 },
    {1, 0x46, 0xB0 },
    {1, 0x46, 0xB4 }
};

enum ar5213_modi {
    ANorm = 0,
    ATurbo = 1,
    BNorm = 2,
    GNorm = 3,
    GTurbo = 4
};

struct initModeMatrix {
    UInt32 reg;
    UInt32 val[5];
};

const struct initModeMatrix modeInitMatrix[] = { 
    { 0x30,     {0x15,          0x15,       0x15,       0x15,       0x15 }},
    { 0x1040,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x1044,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x1048,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x104C,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x1050,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x1054,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x1058,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x105C,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x1060,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x1064,   {0x2FFC0F,      0x2FFC0F,   0x2FFC1F,   0x2FFC0F,   0x2FFC0F }},
    { 0x1030,   {0x230,         0x1E0,      0x0B0,      0x160,      0x1E0 }},
    { 0x1070,   {0x168,         0x1E0,      0x1B8,      0x18C,      0x1E0 }},
    { 0x10B0,   {0x0E60,        0x1180,     0x1F1C,     0x3E38,     0x1180 }},
    { 0x10F0,   {0x0A0E0,       0x14068,    0x5880,     0x0B0E0,    0x14068 }},
    { 0x8014,   {0x3E803E8,     0x6E006E0,  0x4200420,  0x8400840,  0x6E006E0 }},
    { 0x9804,   {0x0,           0x3,        0x0,        0x0,        0x3 }},
    { 0x9820,   {0x2020200,     0x2020200,  0x2010200,  0x2020200,  0x2020200 }},
    { 0x9834,   {0x0E0E,        0x0E0E,     0x0E0E,     0x0E0E,     0x0E0E }},
    { 0x9838,   {0x7,           0x7,        0x0B,       0x0B,       0x0B }},
    { 0x9844,   {0x1372161C,    0x13721C25, 0x13721728, 0x137216A2, 0x13721C25 }},
    { 0x9850,   {0x0DE8B4E0,    0x0DE8B4E0, 0x0DE8B4E0, 0x0DE8B4E0, 0x0DE8B4E0 }},
    { 0x9858,   {0x7E800D2E,    0x7E800D2E, 0x7EE84D2E, 0x7EE84D2E, 0x7E800D2E }},
    { 0x9860,   {0x9D10,        0x9D10,     0x9D18,     0x9D10,     0x9D10 }},
    { 0x9864,   {0x1CE00,       0x1CE00,    0x1CE00,    0x1CE00,    0x1CE00 }},
    { 0x9868,   {0x409A4190,    0x409A4190, 0x409A4190, 0x409A4190, 0x409A4190 }},
    { 0x9918,   {0x1B8,         0x1B8,      0x84,       0x108,      0x1B8 }},
    { 0x9924,   {0x10058A05,    0x10058A05, 0x10058A05, 0x10058A05, 0x10058A05 }},
    { 0x9944,   {0x0FFB81020,   0x0FFB81020, 0x0FFB80D20, 0x0FFB81020, 0x0FFB81020 }},
    { 0xA180,   {0x10FF14FF,    0x10FF14FF, 0x10FF10FF, 0x10FF19FF, 0x10FF19FF }},    
    { 0xA230,   {0x0,           0x0,        0x0,        0x108,      0x0}}
};

const struct initModeMatrix modeInitPhyMatrix[] = { 
    { 0x801C,   { 0x128D8FA7,   0x9880FCF,  0x4E00F95,  0x128D8FAB, 0x9880FCF}},
    { 0x9824,   { 0x0E0E,       0x0E0E,     0x707,      0x0E0E,     0x0E0E}},
    { 0x9828,   { 0x0A020001,   0x0A020001, 0x5010100,  0x0A020001, 0x0A020001}},
    { 0x9848,   { 0x18DA5A,     0x18DA5A,   0x18CA69,   0x18CA69,   0x18CA69}},
    { 0x985C,   { 0x3137665E,   0x3137665E, 0x3137665E, 0x3137665E, 0x3137615E}},
    { 0x986C,   { 0x50CB081,    0x50CB081,  0x50CB081,  0x50CB080,  0x50CB080}},
    { 0x9914,   { 0x2710,       0x2710,     0x157C,     0x2AF8,     0x2710}}
};

enum ar5213_freq {
    _5GHz = 1,
    _2GHz = 2
};

struct initFreqMatrix {
    UInt32 reg;
    UInt32 val[2];
};

const struct initFreqMatrix modeInitFreqMatrix[] = { 
	{ 0x9A00,	{ 0x1A9,    0x0 } },
	{ 0x9A04,	{ 0x1E9,    0x40 } },
	{ 0x9A08,	{ 0x29,     0x80 } },
	{ 0x9A0C,	{ 0x69,     0x150 } },
	{ 0x9A10,	{ 0x199,    0x190 } },
	{ 0x9A14,	{ 0x1D9,    0x1D0 } },
	{ 0x9A18,	{ 0x19,     0x10 } },
	{ 0x9A1C,	{ 0x59,     0x44 } },
	{ 0x9A20,	{ 0x99,     0x84 } },
	{ 0x9A24,	{ 0x1A5,    0x148 } },
	{ 0x9A28,	{ 0x1E5,    0x188 } },
	{ 0x9A2C,	{ 0x25,     0x1C8 } },
	{ 0x9A30,	{ 0x1C8,    0x14 } },
	{ 0x9A34,	{ 0x8,      0x42 } },
	{ 0x9A38,	{ 0x48,     0x82 } },
	{ 0x9A3C,	{ 0x88,     0x178 } },
	{ 0x9A40,	{ 0x198,    0x1B8 } },
	{ 0x9A44,	{ 0x1D8,    0x1F8 } },
	{ 0x9A48,	{ 0x18,     0x12 } },
	{ 0x9A4C,	{ 0x58,     0x52 } },
	{ 0x9A50,	{ 0x98,     0x92 } },
	{ 0x9A54,	{ 0x1A4,    0x17C } },
	{ 0x9A58,	{ 0x1E4,    0x1BC } },
	{ 0x9A5C,	{ 0x24,     0x1FC } },
	{ 0x9A60,	{ 0x64,     0x0A } },
	{ 0x9A64,	{ 0x0A4,    0x4A } },
	{ 0x9A68,	{ 0x0E4,    0x8A } },
	{ 0x9A6C,	{ 0x10A,    0x15A } },
	{ 0x9A70,	{ 0x14A,    0x19A } },
	{ 0x9A74,	{ 0x18A,    0x1DA } },
	{ 0x9A78,	{ 0x1CA,    0x0E } },
	{ 0x9A7C,	{ 0x0A,     0x4E } },
	{ 0x9A80,	{ 0x4A,     0x8E } },
	{ 0x9A84,	{ 0x8A,     0x15E } },
	{ 0x9A88,	{ 0x1BA,    0x19E } },
	{ 0x9A8C,	{ 0x1FA,    0x1DE } },
	{ 0x9A90,	{ 0x3A,     0x9 } },
	{ 0x9A94,	{ 0x7A,     0x49 } },
	{ 0x9A98,	{ 0x186,    0x89 } },
	{ 0x9A9C,	{ 0x1C6,    0x179 } },
	{ 0x9AA0,	{ 0x6,      0x1B9 } },
	{ 0x9AA4,	{ 0x46,     0x1F9 } },
	{ 0x9AA8,	{ 0x86,     0x39 } },
	{ 0x9AAC,	{ 0x0C6,    0x79 } },
	{ 0x9AB0,	{ 0x0C6,    0x0B9 } },
	{ 0x9AB4,	{ 0x0C6,    0x1BD } },
	{ 0x9AB8,	{ 0x0C6,    0x1FD } },
	{ 0x9ABC,	{ 0x0C6,    0x3D } },
	{ 0x9AC0,	{ 0x0C6,    0x7D } },
	{ 0x9AC4,	{ 0x0C6,    0x0BD } },
	{ 0x9AC8,	{ 0x0C6,    0x0FD } },
	{ 0x9ACC,	{ 0x0C6,    0x0FD } },
	{ 0x9AD0,	{ 0x0C6,    0x0FD } },
	{ 0x9AD4,	{ 0x0C6,    0x0FD } },
	{ 0x9AD8,	{ 0x0C6,    0x0FD } },
	{ 0x9ADC,	{ 0x0C6,    0x0FD } },
	{ 0x9AE0,	{ 0x0C6,    0x0FD } },
	{ 0x9AE4,	{ 0x0C6,    0x0FD } },
	{ 0x9AE8,	{ 0x0C6,    0x0FD } },
	{ 0x9AEC,	{ 0x0C6,    0x0FD } },
	{ 0x9AF0,	{ 0x0C6,    0x0FD } },
	{ 0x9AF4,	{ 0x0C6,    0x0FD } },
	{ 0x9AF8,	{ 0x0C6,    0x0FD } },
	{ 0x9AFC,	{ 0x0C6,    0x0FD } }
};

struct initGeneralMatrix {
    UInt32 reg;
    UInt32 val;
};

const struct initGeneralMatrix genInitPhyMatrix[] = { 
    { 0x9930,   0x4883 },
    { 0xA208,   0x0D03E6788 },
    { 0xA20C,   0x6448416A },
    { 0x9B04,   0x20 },
    { 0x9B08,   0x10 },
    { 0x9B0C,   0x30 },
    { 0x9B10,   0x08 },
    { 0x9B14,   0x28 },
    { 0x9B18,   0x04 },
    { 0x9B1C,   0x24 },
    { 0x9B20,   0x14 },
    { 0x9B24,   0x34 },
    { 0x9B2C,   0x2C },
    { 0x9B30,   0x02 },
    { 0x9B34,   0x22 },
    { 0x9B3C,   0x32 },
    { 0x9B40,   0x0A },
    { 0x9B44,   0x2A },
    { 0x9B48,   0x06 },
    { 0x9B4C,   0x26 },
    { 0x9B50,   0x16 },
    { 0x9B54,   0x36 },
    { 0x9B58,   0x0E },
    { 0x9B5C,   0x2E },
    { 0x9B60,   0x01 },
    { 0x9B68,   0x11 },
    { 0x9B6C,   0x31 },
    { 0x9B70,   0x09 },
    { 0x9B74,   0x29 },
    { 0x9B78,   0x05 },
    { 0x9B7C,   0x25 },
    { 0x9B80,   0x15 },
    { 0x9B84,   0x35 },
    { 0x9B88,   0x0D },
    { 0x9B90,   0x03 },
    { 0x9B94,   0x23 },
    { 0x9B98,   0x13 },
    { 0x9BA0,   0x0B },
    { 0x9BA4,   0x2B },
    { 0x9BA8,   0x2B },
    { 0x9BAC,   0x2B },
    { 0x9BB0,   0x2B },
    { 0x9BB4,   0x2B },
    { 0x9BB8,   0x2B },
    { 0x9BBC,   0x2B },
    { 0x9BC0,   0x2B },
    { 0x9BC4,   0x2B },
    { 0x9BC8,   0x2B },
    { 0x9BCC,   0x2B },
    { 0x9BD0,   0x2B },
    { 0x9BD4,   0x2B },
    { 0x9BD8,   0x2B },
    { 0x9BDC,   0x2B },
    { 0x9BE0,   0x2B },
    { 0x9BE4,   0x2B },
    { 0x9BE8,   0x2B },
    { 0x9BEC,   0x2B },
    { 0x9BF0,   0x2B },
    { 0x9BF4,   0x2B },
    { 0x9BF8,   0x02 },
    { 0x9BFC,   0x16 }
};

const struct initGeneralMatrix genInitMatrix[] = { 
    { 0x0C,     0x0},
    { 0x34,     0x5},
    { 0x40,     0x0},
    { 0x44,     0x8},
    { 0x48,     0x8},
    { 0x4C,     0x10},
    { 0x50,     0x0},
    { 0x54,     0x1F},
    { 0x800,    0x0},
    { 0x804,    0x0},
    { 0x808,    0x0},
    { 0x80C,    0x0},
    { 0x810,    0x0},
    { 0x814,    0x0},
    { 0x818,    0x0},
    { 0x81C,    0x0},
    { 0x820,    0x0},
    { 0x824,    0x0},
    { 0x1230,   0x0},
    { 0x1270,   0x0},
    { 0x1038,   0x0},
    { 0x1078,   0x0},
    { 0x10B8,   0x0},
    { 0x10F8,   0x0},
    { 0x1138,   0x0},
    { 0x1178,   0x0},
    { 0x11B8,   0x0},
    { 0x11F8,   0x0},
    { 0x1238,   0x0},
    { 0x1278,   0x0},
    { 0x12B8,   0x0},
    { 0x12F8,   0x0},
    { 0x1338,   0x0},
    { 0x1378,   0x0},
    { 0x13B8,   0x0},
    { 0x13F8,   0x0},
    { 0x1438,   0x0},
    { 0x1478,   0x0},
    { 0x14B8,   0x0},
    { 0x14F8,   0x0},
    { 0x1538,   0x0},
    { 0x1578,   0x0},
    { 0x15B8,   0x0},
    { 0x15F8,   0x0},
    { 0x1638,   0x0},
    { 0x1678,   0x0},
    { 0x16B8,   0x0},
    { 0x16F8,   0x0},
    { 0x1738,   0x0},
    { 0x1778,   0x0},
    { 0x17B8,   0x0},
    { 0x17F8,   0x0},
    { 0x103C,   0x0},
    { 0x107C,   0x0},
    { 0x10BC,   0x0},
    { 0x10FC,   0x0},
    { 0x113C,   0x0},
    { 0x117C,   0x0},
    { 0x11BC,   0x0},
    { 0x11FC,   0x0},
    { 0x123C,   0x0},
    { 0x127C,   0x0},
    { 0x12BC,   0x0},
    { 0x12FC,   0x0},
    { 0x133C,   0x0},
    { 0x137C,   0x0},
    { 0x13BC,   0x0},
    { 0x13FC,   0x0},
    { 0x143C,   0x0},
    { 0x147C,   0x0},
    { 0x8004,   0x0},
    { 0x8008,   0x0},
    { 0x800C,   0x0},
    { 0x8018,   0x0},
    { 0x8020,   0x0},
    { 0x8024,   0x0},
    { 0x8028,   0x30},
    { 0x802C,   0x7FFFF},
    { 0x8030,   0x1FFFFFF},
    { 0x8034,   0x31},
    { 0x8038,   0x0},
    { 0x803C,   0x0},
    { 0x8048,   0x0},
    { 0x8054,   0x0},
    { 0x8058,   0x0},
    { 0x805C,   0x0FFFFC7FF},
    { 0x8080,   0x0},
    { 0x8084,   0x0},
    { 0x8088,   0x0},
    { 0x808C,   0x0},
    { 0x8090,   0x0},
    { 0x8094,   0x0},
    { 0x8098,   0x0},
    { 0x80C0,   0x2A82301A},
    { 0x80C4,   0x5DC01E0},
    { 0x80C8,   0x1F402710},
    { 0x80CC,   0x1F40000},
    { 0x80D0,   0x1E1C},
    { 0x80D4,   0x2AAAA},
    { 0x80D8,   0x2005555},
    { 0x80DC,   0x0},
    { 0x80E0,   0x0FFFFFFFF},
    { 0x80E4,   0x0FFFF},
    { 0x80E8,   0x0},
    { 0x80EC,   0x0},
    { 0x80F0,   0x0},
    { 0x80F4,   0x0},
    { 0x80F8,   0x0},
    { 0x80FC,   0x88},
    { 0x8700,   0x0},
    { 0x8704,   0x8C},
    { 0x8708,   0x0E4},
    { 0x870C,   0x2D5},
    { 0x8710,   0x0},
    { 0x8714,   0x0},
    { 0x8718,   0x0A0},
    { 0x871C,   0x1C9},
    { 0x8720,   0x2C},
    { 0x8724,   0x2C},
    { 0x8728,   0x30},
    { 0x872C,   0x3C},
    { 0x8730,   0x2C},
    { 0x8734,   0x2C},
    { 0x8738,   0x30},
    { 0x873C,   0x3C},
    { 0x8740,   0x0},
    { 0x8744,   0x0},
    { 0x8748,   0x0},
    { 0x874C,   0x0},
    { 0x8750,   0x0},
    { 0x8754,   0x0},
    { 0x8758,   0x0},
    { 0x875C,   0x0},
    { 0x8760,   0x0D5},
    { 0x8764,   0x0DF},
    { 0x8768,   0x102},
    { 0x876C,   0x13A},
    { 0x8770,   0x75},
    { 0x8774,   0x7F},
    { 0x8778,   0x0A2},
    { 0x877C,   0x0},
    { 0x8100,   0x10002},
    { 0x8104,   0x1},
    { 0x8108,   0x0C0},
    { 0x810C,   0x0},
    { 0x8110,   0x168},
    { 0x8114,   0x0},
    { 0x87C0,   0x3020100},
    { 0x87C4,   0x7060504},
    { 0x87C8,   0x0B0A0908},
    { 0x87CC,   0x0F0E0D0C},
    { 0x87D0,   0x13121110},
    { 0x87D4,   0x17161514},
    { 0x87D8,   0x1B1A1918},
    { 0x87DC,   0x1F1E1D1C},
    { 0x87E0,   0x3020100},
    { 0x87E4,   0x7060504},
    { 0x87E8,   0x0B0A0908},
    { 0x87EC,   0x0F0E0D0C},
    { 0x87F0,   0x13121110},
    { 0x87F4,   0x17161514},
    { 0x87F8,   0x1B1A1918},
    { 0x87FC,   0x1F1E1D1C},
    { 0x9808,   0x0},
    { 0x980C,   0x0AD848E19},
    { 0x9810,   0x7D28E000},
    { 0x9814,   0x9C0A9F6B},
    { 0x981C,   0x0},
    { 0x982C,   0x22FFE},
    { 0x983C,   0x20100},
    { 0x9840,   0x206A017A},
    { 0x984C,   0x1284613C},
    { 0x9854,   0x859},
    { 0x9900,   0x0},
    { 0x9904,   0x0},
    { 0x9908,   0x0},
    { 0x990C,   0x800000},
    { 0x9910,   0x1},
    { 0x991C,   0x92A},
    { 0x9920,   0x5100000},
    { 0x9928,   0x1},
    { 0x992C,   0x4},
    { 0x9934,   0x1E1F2022},
    { 0x9938,   0x0A0B0C0D},
    { 0x993C,   0x3F},
    { 0x9940,   0x4},
    { 0x9948,   0x9280B212},
    { 0x9954,   0x5D50F14C},
    { 0x9958,   0x0FF},
    { 0x995C,   0x4B6A8E},
    { 0x9968,   0x3CE},
    { 0x9970,   0x192FB515},
    { 0x9974,   0x0},
    { 0x9978,   0x1},
    { 0x997C,   0x0},
    { 0xA184,   0x10FF10FF},
    { 0xA188,   0x10FF10FF},
    { 0xA18C,   0x10FF10FF},
    { 0xA190,   0x10FF10FF},
    { 0xA194,   0x10FF10FF},
    { 0xA198,   0x10FF10FF},
    { 0xA19C,   0x10FF10FF},
    { 0xA1A0,   0x10FF10FF},
    { 0xA1A4,   0x10FF10FF},
    { 0xA1A8,   0x10FF10FF},
    { 0xA1AC,   0x10FF10FF},
    { 0xA1B0,   0x10FF10FF},
    { 0xA1B4,   0x10FF10FF},
    { 0xA1B8,   0x10FF10FF},
    { 0xA1BC,   0x10FF10FF},
    { 0xA1C0,   0x10FF10FF},
    { 0xA1C4,   0x10FF10FF},
    { 0xA1C8,   0x10FF10FF},
    { 0xA1CC,   0x10FF10FF},
    { 0xA1D0,   0x10FF10FF},
    { 0xA1D4,   0x10FF10FF},
    { 0xA1D8,   0x10FF10FF},
    { 0xA1DC,   0x10FF10FF},
    { 0xA1E0,   0x10FF10FF},
    { 0xA1E4,   0x10FF10FF},
    { 0xA1E8,   0x10FF10FF},
    { 0xA1EC,   0x10FF10FF},
    { 0xA1F0,   0x10FF10FF},
    { 0xA1F4,   0x10FF10FF},
    { 0xA1F8,   0x10FF10FF},
    { 0xA1FC,   0x10FF10FF},
    { 0xA204,   0x0},
    { 0xA210,   0x80A333},
    { 0xA214,   0x206C10},
    { 0xA218,   0x9C4060},
    { 0xA21C,   0x1483800A},
    { 0xA220,   0x1831061},
    { 0xA224,   0x400},
    { 0xA228,   0x1B5},
    { 0xA22C,   0x0},
    { 0xA234,   0x20202020},
    { 0xA238,   0x20202020},
    { 0xA23C,   0x13C889AF},
    { 0xA240,   0x38490A20},
    { 0xA244,   0x7BB6},
    { 0xA248,   0x0FFF3FFC},
    { 0x9B00,   0x0},
    { 0x9B28,   0x0C},
    { 0x9B38,   0x12},
    { 0x9B64,   0x21},
    { 0x9B8C,   0x2D},
    { 0x9B9C,   0x33}
};

/* initial register values */

#define INIT_CONFIG_STATUS 0x00000000
#define INIT_TOPS 0x00000008
#define INIT_ACKTOPS 0x00000008
#define INIT_RXNOPKT 0x00000008
#define INIT_RPGTO 0x00000000
#define INIT_TXNOPKT 0x00000000
#define INIT_BCON_CNTRL_REG 0x00000000
#define INIT_SLOT_TIME 0x00000168
#define INIT_SLOT_TIME_TURBO 0x000001e0 
#define INIT_ACK_CTS_TIMEOUT 0x04000400
#define INIT_ACK_CTS_TIMEOUT_TURBO 0x08000800
#define INIT_CWMIN 0xf
#define INIT_SH_RETRY 10
#define INIT_LG_RETRY 10
#define INIT_SSH_RETRY 32
#define INIT_SLG_RETRY 32
#define INIT_RETRY_LIMITS ((INIT_CWMIN << 20) | (INIT_SLG_RETRY<<14) | (INIT_SSH_RETRY<<8) |\
			  (INIT_LG_RETRY<<4) | INIT_SH_RETRY)
#define INIT_RETRY_FIELD 0x000000ff
#define INIT_SRETRY_FIELD 0x0000ff00
#define INIT_USEC 0x27
#define INIT_USEC_TURBO 0x4f
#define INIT_USEC_32 0x1f
#define INIT_TX_LATENCY	0x1f6
#define INIT_TRANSMIT_LATENCY ((INIT_TX_LATENCY<<14) | (INIT_USEC_32<<7) | INIT_USEC)
#define INIT_TRANSMIT_LATENCY_TURBO ((INIT_TX_LATENCY<<14) | (INIT_USEC_32<<7) | INIT_USEC_TURBO)
#define INIT_SIFS 0x230 
#define INIT_SIFS_TURBO	0x1E0 
#define INIT_DIFS 0x500 
#define INIT_DIFS_TURBO	0x5A0 
#define INIT_PROTOCOL_TIMERS ((INIT_DIFS<<11) | INIT_SIFS)
#define INIT_PROTOCOL_TIMERS_TURBO ((INIT_DIFS_TURBO<<11) | INIT_SIFS_TURBO)
#define MIN_TX_FIFO_THRESHOLD 0x1
#define MAX_TX_FIFO_THRESHOLD ((MAX_WLAN_BODY_SIZE / 64) + 1)
#define INIT_TX_FIFO_THRESHOLD MIN_TX_FIFO_THRESHOLD
#define	INIT_CFP_INTERVAL 0
#define INIT_NEXT_BEACON_TIME 0
#define INIT_TSF_CLOCK_LOW 0
#define INIT_DMA_BEACON_ALERT 0xffffffff
#define INIT_SW_BCON_ALERT 0xffffffff
#define INIT_NEXT_CFP_START 0xffffffff
#define INIT_BEACON_PERIOD 0xffff
#define INIT_TIM_OFFSET	0
#define INIT_BEACON_EN 0 
#define INIT_RESET_TSF 0
#define INIT_BEACON_CONTROL ((INIT_RESET_TSF<<24) | (INIT_BEACON_EN<<23) | \
			    (INIT_TIM_OFFSET<<16) | INIT_BEACON_PERIOD)
#define INIT_RSSI_THR 0x00000700 
#define INIT_ProgIFS 0x398 
#define INIT_ProgIFS_TURBO 0x3C0
#define INIT_EIFS 0xd70
#define INIT_EIFS_TURBO 0x1ae0
#define INIT_CARR_SENSE_EN 1
#define	INIT_PROTO_TIME_CNTRL ((INIT_CARR_SENSE_EN << 26) | (INIT_EIFS << 12) | (INIT_ProgIFS))
#define	INIT_PROTO_TIME_CNTRL_TURBO ((INIT_CARR_SENSE_EN << 26) | (INIT_EIFS_TURBO << 12) | \
				    (INIT_ProgIFS_TURBO))
