 
struct ar5213_channel_table_data {
	UInt8   data[11];
}
 
struct ar5213_channel_table {
	UInt16	size;
        ar5213_channel_table_data data;
};


//stolen from atheros hal

/* flags passed to rx descriptor setup methods */
#define	AR5K_RXDESC_INTREQ	0x2000	/* enable per-descriptor interrupt */

/*
 * Definitions for the software frame/packet descriptors used by
 * the Atheros HAL.  This definition obscures hardware-specific
 * details from the driver.  Drivers are expected to fillin the
 * portions of a descriptor that are not opaque then use HAL calls
 * to complete the work.  Status for completed frames is returned
 * in a device-independent format.
 */
 
 struct ar5213_tx_status {
	UInt16	ts_seqnum;	/* h/w assigned sequence number */
	UInt16	ts_tstamp;	/* h/w assigned timestamp */
	UInt8	ts_status;	/* frame status, 0 => xmit ok */
	UInt8	ts_rate;	/* h/w transmit rate index */
	char    ts_rssi;	/* tx ack RSSI */
	UInt8	ts_shortretry;	/* # short retries */
	UInt8	ts_longretry;	/* # long retries */
	UInt8	ts_virtcol;	/* virtual collision count */
	UInt8	ts_antenna;	/* antenna information */
};

/*
 * Receive descriptor status.  This structure is filled
 * in only after the rx descriptor process method finds a
 * ``done'' descriptor; at which point it returns something
 * other than HAL_EINPROGRESS.
 *
 * If rx_status is zero, then the frame was received ok;
 * otherwise the error information is indicated and rs_phyerr
 * contains a phy error code if HAL_RXERR_PHY is set.
 *
 * Note that the receive timestamp is expanded using the TSF to
 * a full 16 bits (regardless of what the h/w provides directly).
 */
struct ar5213_rx_status {
	UInt16	rs_datalen;	/* rx frame length */
	UInt16	rs_tstamp;	/* h/w assigned timestamp */
	UInt8	rs_status;	/* rx status, 0 => recv ok */
	UInt8	rs_phyerr;	/* phy error code */
	char    rs_rssi;	/* rx frame RSSI */
	UInt8	rs_keyix;	/* key cache index */
	UInt8	rs_rate;	/* h/w receive rate index */
	UInt8	rs_antenna;	/* antenna information */
	UInt8	rs_more;	/* more descriptors follow */
};

struct ar5213_desc {
	/*
	 * The following definitions are passed directly
	 * the hardware and managed by the HAL.  Drivers
	 * should not touch those elements marked opaque.
	 */
	UInt32	ds_link;	/*00 phys address of next descriptor */
	UInt32	ds_data;	/*04 phys address of data buffer */
	UInt32	ds_ctl0;	/*08 opaque DMA control 0 */
	UInt32	ds_ctl1;	/*0C opaque DMA control 1 */
	UInt32	ds_hw0;         /*10 opaque h/w region */
	UInt32	ds_hw1;         /*14 opaque h/w region */
	UInt32	ds_hw2;         /*18 opaque h/w region */
	UInt32	ds_hw3;         /*20 opaque h/w region */
	/*
	 * The remaining definitions are managed by software;
	 * these are valid only after the rx/tx process descriptor
	 * methods return a non-EINPROGRESS  code.
	 */
	union {
		struct ar5213_tx_status tx;/* xmit status */
		struct ar5213_rx_status rx;/* recv status */
	} ds_us;
} __attribute__((__packed__));

