//stolen and to be removed!


#ifndef _DEV_ATH_DESC_H
#define _DEV_ATH_DESC_H

typedef struct {
	UInt16	channel;	/* setting in Mhz */
	UInt16	channelFlags;	/* see below */
} HAL_CHANNEL;

typedef enum {
	HAL_PM_UNDEFINED	= 0,
	HAL_PM_AUTO		= 1,
	HAL_PM_AWAKE		= 2,
	HAL_PM_FULL_SLEEP	= 3,
	HAL_PM_NETWORK_SLEEP	= 4
} HAL_POWER_MODE;

enum {
	HAL_MODE_11A	= 0x001,
	HAL_MODE_TURBO	= 0x002,
	HAL_MODE_11B	= 0x004,
	HAL_MODE_PUREG	= 0x008,
#ifdef notdef
	HAL_MODE_11G	= 0x010,
#else
	HAL_MODE_11G	= 0x008,
#endif
	HAL_MODE_ALL	= 0x020
};

typedef struct {
	UInt16	rateCount;
	UInt8	rateCodeToIndex[32];	/* back mapping */
	struct {
		UInt8	valid;		/* valid for rate control use */
		UInt8	phy;		/* CCK/OFDM/XR */
		UInt16	rateKbps;	/* transfer rate in kbs */
		UInt8	rateCode;	/* rate for h/w descriptors */
		UInt8	shortPreamble;	/* mask for enabling short
						 * preamble in CCK rate code */
		UInt8	dot11Rate;	/* value for supported rates
						 * info element of MLME */
		UInt8	controlRate;	/* index of next lower basic
						 * rate; used for dur. calcs */
	} info[32];
} HAL_RATE_TABLE;

#define	CHANNEL_RAD_INT	0x0001	/* Radar interference detected on channel */
#define	CHANNEL_CW_INT	0x0002	/* CW interference detected on channel */
#define	CHANNEL_BUSY	0x0004	/* Busy, occupied or overlap with adjoin chan */
#define	CHANNEL_TURBO	0x0010	/* Turbo Channel */
#define	CHANNEL_CCK	0x0020	/* CCK channel */
#define	CHANNEL_OFDM	0x0040	/* OFDM channel */
#define	CHANNEL_2GHZ	0x0080	/* 2 GHz spectrum channel. */
#define	CHANNEL_5GHZ	0x0100	/* 5 GHz spectrum channel */
#define	CHANNEL_PASSIVE	0x0200	/* Only passive scan allowed in the channel */
#define	CHANNEL_DYN	0x0400	/* dynamic CCK-OFDM channel */

#define	CHANNEL_A	(CHANNEL_5GHZ|CHANNEL_OFDM)
#define	CHANNEL_B	(CHANNEL_2GHZ|CHANNEL_CCK)
#define	CHANNEL_PUREG	(CHANNEL_2GHZ|CHANNEL_OFDM)
#ifdef notdef
#define	CHANNEL_G	(CHANNEL_2GHZ|CHANNEL_DYN)
#else
#define	CHANNEL_G	(CHANNEL_2GHZ|CHANNEL_OFDM)
#endif
#define	CHANNEL_T	(CHANNEL_5GHZ|CHANNEL_OFDM|CHANNEL_TURBO)
#define	CHANNEL_ALL \
	(CHANNEL_OFDM|CHANNEL_CCK|CHANNEL_5GHZ|CHANNEL_2GHZ|CHANNEL_TURBO)
#define	CHANNEL_ALL_NOTURBO 	(CHANNEL_ALL &~ CHANNEL_TURBO)

typedef enum {
	HAL_M_STA	= 1,			/* infrastructure station */
	HAL_M_IBSS	= 0,			/* IBSS (adhoc) station */
	HAL_M_HOSTAP	= 6,			/* Software Access Point */
	HAL_M_MONITOR	= 8			/* Monitor mode */
} HAL_OPMODE;

/*
 * Transmit descriptor status.  This structure is filled
 * in only after the tx descriptor process method finds a
 * ``done'' descriptor; at which point it returns something
 * other than HAL_EINPROGRESS.
 *
 * Note that ts_antenna may not be valid for all h/w.  It
 * should be used only if non-zero.
 */
struct ath_tx_status {
	u_int16_t	ts_seqnum;	/* h/w assigned sequence number */
	u_int16_t	ts_tstamp;	/* h/w assigned timestamp */
	u_int8_t	ts_status;	/* frame status, 0 => xmit ok */
	u_int8_t	ts_rate;	/* h/w transmit rate index */
	int8_t		ts_rssi;	/* tx ack RSSI */
	u_int8_t	ts_shortretry;	/* # short retries */
	u_int8_t	ts_longretry;	/* # long retries */
	u_int8_t	ts_virtcol;	/* virtual collision count */
	u_int8_t	ts_antenna;	/* antenna information */
};

#define	HAL_TXERR_XRETRY	0x01	/* excessive retries */
#define	HAL_TXERR_FILT		0x02	/* blocked by tx filtering */
#define	HAL_TXERR_FIFO		0x04	/* fifo underrun */

/*
 * Receive descriptor status.  This structure is filled
 * in only after the rx descriptor process method finds a
 * ``done'' descriptor; at which point it returns something
 * other than HAL_EINPROGRESS.
 *
 * If rx_status is zero, then the frame was received ok;
 * otherwise the error information is indicated and rs_phyerr
 * contains a phy error code if HAL_RXERR_PHY is set.
 *
 * Note that the receive timestamp is expanded using the TSF to
 * a full 16 bits (regardless of what the h/w provides directly).
 */
struct ath_rx_status {
	u_int16_t	rs_datalen;	/* rx frame length */
	u_int16_t	rs_tstamp;	/* h/w assigned timestamp */
	u_int8_t	rs_status;	/* rx status, 0 => recv ok */
	u_int8_t	rs_phyerr;	/* phy error code */
	int8_t		rs_rssi;	/* rx frame RSSI */
	u_int8_t	rs_keyix;	/* key cache index */
	u_int8_t	rs_rate;	/* h/w receive rate index */
	u_int8_t	rs_antenna;	/* antenna information */
	u_int8_t	rs_more;	/* more descriptors follow */
};

#define	HAL_RXERR_CRC		0x01	/* CRC error on frame */
#define	HAL_RXERR_PHY		0x02	/* PHY error, rs_phyerr is valid */
#define	HAL_RXERR_FIFO		0x04	/* fifo overrun */
#define	HAL_RXERR_DECRYPT	0x08	/* non-Michael decrypt error */
#define	HAL_RXERR_MIC		0x10	/* Michael MIC decrypt error */

enum {
	HAL_PHYERR_UNDERRUN		= 0,	/* Transmit underrun */
	HAL_PHYERR_TIMING		= 1,	/* Timing error */
	HAL_PHYERR_PARITY		= 2,	/* Illegal parity */
	HAL_PHYERR_RATE			= 3,	/* Illegal rate */
	HAL_PHYERR_LENGTH		= 4,	/* Illegal length */
	HAL_PHYERR_RADAR		= 5,	/* Radar detect */
	HAL_PHYERR_SERVICE		= 6,	/* Illegal service */
	HAL_PHYERR_TOR			= 7,	/* Transmit override receive */
	/* NB: these are specific to the 5212 */
	HAL_PHYERR_OFDM_TIMING		= 17,	/* */
	HAL_PHYERR_OFDM_SIGNAL_PARITY	= 18,	/* */
	HAL_PHYERR_OFDM_RATE_ILLEGAL	= 19,	/* */
	HAL_PHYERR_OFDM_LENGTH_ILLEGAL	= 20,	/* */
	HAL_PHYERR_OFDM_POWER_DROP	= 21,	/* */
	HAL_PHYERR_OFDM_SERVICE		= 22,	/* */
	HAL_PHYERR_OFDM_RESTART		= 23,	/* */
	HAL_PHYERR_CCK_TIMING		= 25,	/* */
	HAL_PHYERR_CCK_HEADER_CRC	= 26,	/* */
	HAL_PHYERR_CCK_RATE_ILLEGAL	= 27,	/* */
	HAL_PHYERR_CCK_SERVICE		= 30,	/* */
	HAL_PHYERR_CCK_RESTART		= 31,	/* */
};

/* value found in rs_keyix to mark invalid entries */
#define	HAL_RXKEYIX_INVALID	((u_int8_t) -1)
/* value used to specify no encryption key for xmit */
#define	HAL_TXKEYIX_INVALID	((u_int) -1)


#define	ds_txstat	ds_us.tx
#define	ds_rxstat	ds_us.rx

/* flags passed to tx descriptor setup methods */
#define	HAL_TXDESC_CLRDMASK	0x0001	/* clear destination filter mask */
#define	HAL_TXDESC_NOACK	0x0002	/* don't wait for ACK */
#define	HAL_TXDESC_RTSENA	0x0004	/* enable RTS */
#define	HAL_TXDESC_CTSENA	0x0008	/* enable CTS */
#define	HAL_TXDESC_INTREQ	0x0010	/* enable per-descriptor interrupt */
#define	HAL_TXDESC_VEOL		0x0020	/* mark virtual EOL */

#endif /* _DEV_ATH_AR521XDMA_H */
