/*
        
        File:			GPSController.h
        Program:		KisMAC
	Author:			Michael Rossberg
                                mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import <Foundation/Foundation.h>

typedef struct _waypoint {
    float _lat;
    float _long;
    float _elevation;
} waypoint;

struct _position {
    char dir;
    float coordinates;
};

@interface GPSController : NSObject {
    bool _gpsThreadUp;
    bool _gpsShallRun;
    bool _reliable;
    bool _tripmateMode;
    int  _traceInterval;
    int  _onNoFix;
    BOOL _debugEnabled;
    
    struct _position _ns, _ew, _elev;
    NSMutableArray* _trace;
    NSDate* _lastAdd;
    NSString* _position;
    NSString* _gpsDevice;
    NSDate* _lastUpdate;
    NSLock* _gpsLock;
}

- (bool)startForDevice:(NSString*) device;
- (bool)reliable;
- (void)resetTrace;
- (bool)gpsRunning;
- (NSArray*)traceArray;
- (void)setTraceArray:(NSArray*)trace;
- (void)setTraceInterval:(int)interval;
- (void)setTripmateMode:(bool)mode;
- (void)setOnNoFix:(int)onNoFix;
- (NSDate*)lastUpdate;
- (NSString*)NSCoord;
- (NSString*)EWCoord;
- (NSString*)ElevCoord;
- (void) setCurrentPointNS:(double)ns EW:(double)ew ELV:(double)elv;

- (waypoint) currentPoint;
- (void)stop;

- (void)writeDebugOutput:(BOOL)enable;
@end
