/*
        
        File:			InfoController.mm
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#import "InfoController.h"
#import "WaveClient.h"
#import "WaveHelper.h"

@implementation InfoController

- (void)awakeFromNib {
    _clientCount = 0;
    [aShortTable setHeaderView:nil];
}

- (void)setDetails:(bool)visible {
    aDetailsPane=visible;
}

- (void)reloadData {
    unsigned int i;
    
    if (aDetailsPane) [aShortTable displayRect:[aShortTable rectOfColumn:1]];
    else [aTable displayRect:[aTable rectOfColumn:1]]; //[aTable reloadData];
    
    if (_lastSorted) [_n sortByColumn:_lastSorted order:_ascending];

    if (_clientCount == [aClients count]) {
        for (i = 0; i < [aClients count]; i++) {
            if ([[aClients objectForKey:[aClientKeys objectAtIndex:i]] changed]) 
                [aClientTable displayRect:[aTable rectOfRow:i]];
        }
    } else {
        [aClientTable noteNumberOfRowsChanged];
        _clientCount = [aClients count];
    }
}

- (IBAction)showNet:(id)sender
{
    [_commentField validateEditing];
    [_n setComment:[_commentField stringValue]];
    
    //release old data
    [WaveHelper secureRelease:&aClients];
    [WaveHelper secureRelease:&aClientKeys];
    [WaveHelper secureRelease:&_n];
    
    //fetch all new interesting stuff
    _n=[sender retain];
    aClients=[[_n getClients] retain];
    aClientKeys=[[_n getClientKeys] retain];
    
    //refresh
    [aTable reloadData];
    [aClientTable reloadData];
    [aShortTable reloadData];
    if ([_n comment]) [_commentField setStringValue:[_n comment]];
    else  [_commentField setStringValue:@""];
}

- (IBAction)commentChanged:(id)sender {
    [_n setComment:[sender stringValue]];

}

#pragma mark -

- (id) tableView:(NSTableView *) aTableView
objectValueForTableColumn:(NSTableColumn *) aTableColumn
             row:(int) rowIndex
{ 
    int col;
    NSString *key;
    WaveClient *lWCl;
    
    if([aTableView isEqualTo:aTable]) {
        if ([[aTableColumn identifier] isEqualToString:@"key"]) col=1;
        else col=0;
    
        //TODO show only interesting things
        switch(rowIndex) {
            case 0:
                 return (col) ? NSLocalizedString(@"SSID", "table description") : [_n SSID];
            case 1:
                 return (col) ? NSLocalizedString(@"BSSID", "table description") : [_n BSSID];
            case 2:
                 return (col) ? NSLocalizedString(@"Vendor", "table description") : [_n getVendor];
            case 3:
                 return (col) ? NSLocalizedString(@"First Seen", "table description") : [_n firstDate];
            case 4:
                 return (col) ? NSLocalizedString(@"Last Seen", "table description") : [_n date];
            case 5:
                 return @"";
            case 6:
                 return (col) ? NSLocalizedString(@"Channel", "table description") : [NSString stringWithFormat:@"%i", [_n channel]];
            case 7:
                 return (col) ? NSLocalizedString(@"Signal", "table description") : [NSString stringWithFormat:@"%i", [_n curSignal]];
            case 8:
                 return (col) ? NSLocalizedString(@"MaxSignal", "table description") : [NSString stringWithFormat:@"%i", [_n maxSignal]];
            case 9:
                 return (col) ? NSLocalizedString(@"AvgSignal", "table description") : [NSString stringWithFormat:@"%i", [_n avgSignal]];
            case 10:
                if (col!=0) return NSLocalizedString(@"Type", "table description");
                else {
                    switch([_n type]) {
                        case 0: return NSLocalizedString(@"unknown", "table description");
                        case 1: return NSLocalizedString(@"ad-hoc", "table description");
                        case 2: return NSLocalizedString(@"managed", "table description");
                        case 3: return NSLocalizedString(@"tunnel", "table description"); 
                        case 4: return NSLocalizedString(@"probe", "table description");                  
                    }
                }
            case 11:
                if (col!=0) return NSLocalizedString(@"Encryption", "table description");
                else {
                    switch([_n isWep]) {
                        case 0: return NSLocalizedString(@"unknown", "table description");
                        case 1: return NSLocalizedString(@"disabled", "table description");
                        case 2: return NSLocalizedString(@"WEP", "table description");
                        case 3: return NSLocalizedString(@"WEP-40", "table description");
                        case 4: return NSLocalizedString(@"WPA", "table description");
                    }
                }
                 return @"";
            case 12:
                 return (col) ? NSLocalizedString(@"Packets", "table description") : [NSString stringWithFormat:@"%i", [_n packets]];
            case 13:
                 return (col) ? NSLocalizedString(@"Weak Packets", "table description") : [NSString stringWithFormat:@"%i", [_n weakPackets]];
            case 14:
                 return (col) ? NSLocalizedString(@"Data Packets", "table description") : [NSString stringWithFormat:@"%i", [_n dataPackets]];
            case 15:
                 return (col) ? NSLocalizedString(@"Bytes", "table description") : [_n data];
            case 16:
                 return (col) ? NSLocalizedString(@"Key", "table description") : [_n key];
            case 17:
                 return (col) ? NSLocalizedString(@"LastIV", "table description") : [_n lastIV];
            case 18:
                 return @"";
            case 19:
                 return (col) ? NSLocalizedString(@"Latitude", "table description") : [_n latitude];
            case 20:
                 return (col) ? NSLocalizedString(@"Longitude", "table description") : [_n longitude];
            case 21:
		return (col) ? NSLocalizedString(@"Elevation", "GPS status string.") : [_n elevation];
        }
        return @"unknown row";
    } else if([aTableView isEqualTo:aClientTable]) {
        key = [aClientKeys objectAtIndex:rowIndex];
        lWCl = [aClients objectForKey:key];
        if ([[aTableColumn identifier] isEqualToString:@"client"]) return key;
        else if ([[aTableColumn identifier] isEqualToString:@"vendor"]) return [lWCl vendor];
        else if ([[aTableColumn identifier] isEqualToString:@"lastseen"]) return [lWCl date];
        else if ([[aTableColumn identifier] isEqualToString:@"signal"]) return [NSString stringWithFormat:@"%i", [lWCl curSignal]];
        else if ([[aTableColumn identifier] isEqualToString:@"sent"]) return [lWCl sent];
        else if ([[aTableColumn identifier] isEqualToString:@"recieved"]) return [lWCl recieved];
        else return @"unknown column";
    } else if([aTableView isEqualTo:aShortTable]) {
        if ([[aTableColumn identifier] isEqualToString:@"key"]) col=1;
        else col=0;
    
        switch(rowIndex) {
            case 0:
                 return (col) ? NSLocalizedString(@"Vendor", "table description") : [_n getVendor];
            case 1:
                 return (col) ? NSLocalizedString(@"First Seen", "table description") : [_n firstDate];
            case 2:
                 return @"";
            case 3:
                 return (col) ? NSLocalizedString(@"Weak Packets", "table description") : [NSString stringWithFormat:@"%i", [_n weakPackets]];
            case 4:
                 return (col) ? NSLocalizedString(@"Data Packets", "table description") : [NSString stringWithFormat:@"%i", [_n dataPackets]];
            case 5:
                 return (col) ? NSLocalizedString(@"Bytes", "table description") : [_n data];
            case 6:
                 return (col) ? NSLocalizedString(@"Key", "table description") : [_n key];
            case 7:
                 return (col) ? NSLocalizedString(@"LastIV", "table description") : [_n lastIV];
            case 8:
                 return @"";
            case 9:
                 return (col) ? NSLocalizedString(@"Latitude", "table description") : [_n latitude];
            case 10:
                 return (col) ? NSLocalizedString(@"Longitude", "table description") : [_n longitude];
            case 11:
                 return @"";
            case 12:
                 return (col) ? NSLocalizedString(@"Comment", "table description") : [_n comment];
	    
        }
        return @"unknown row";
    }
    
    return @"unknown table"; 
}


- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
    if([aTableView isEqualTo:aTable])
        return 22;
    else if([aTableView isEqualTo:aClientTable])
        return [aClientKeys count];
    else if([aTableView isEqualTo:aShortTable])
        return 13;
   return 0;
}

- (void)tableView:(NSTableView*)tableView mouseDownInHeaderOfTableColumn:(NSTableColumn *)tableColumn {
    NSString *ident = [tableColumn identifier];
    
    if(![tableView isEqualTo:aClientTable]) return;

    if ((_lastSorted) && ([_lastSorted isEqualToString:ident])) {
        if (_ascending) _ascending=NO;
        else {
            [WaveHelper secureRelease:&_lastSorted];
            
            [tableView setIndicatorImage:Nil inTableColumn:tableColumn];
            [tableView setHighlightedTableColumn:Nil];
            [tableView reloadData];
            return;
        }
    } else {
        _ascending=YES;
        if (_lastSorted) [tableView setIndicatorImage:nil inTableColumn:[tableView tableColumnWithIdentifier:_lastSorted]];
        [WaveHelper secureReplace:&_lastSorted withObject:ident];
    }
    
    [_n sortByColumn:ident order:_ascending];

    [tableView setIndicatorImage:[NSImage imageNamed:(_ascending) ? @"NSAscendingSortIndicator" : @"NSDescendingSortIndicator"] inTableColumn:tableColumn];
    
    [tableView setHighlightedTableColumn:tableColumn];
    [tableView reloadData];
}

- (BOOL)tableView:(NSTableView *)aTableView shouldEditTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex {
    if ([aTableView isEqualTo:aShortTable]) {
        if (rowIndex==12)  return YES;	//only the comment field is to be edited
    }
    return NO;
}


-(void)tableView:(NSTableView *)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex {
    if([aTableView isEqualTo:aTable] || [aTableView isEqualTo:aShortTable]) {
        [_n setComment:anObject];	//save the comment
    }
}


#pragma mark -

-(void) dealloc {
    if (aClients!=Nil) [aClients release];
    if (aClientKeys!=Nil) [aClientKeys release];
    if (_n!=nil) [_n release];
    [super dealloc];
}
@end
