/*
        
        File:			NetView.m
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import "NetView.h"
#import "WaveHelper.h"

@implementation NetView

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        _name = [[NSString stringWithString:@"<no ssid>"] retain];
        _wep = 0;
        _wp._lat = 0;
        _wp._long = 0;
	_wp._elevation = 0;
        _visible = YES;
        [[WaveHelper zoomPictureView] addSubview:self];
        [[WaveHelper zoomPictureView] alignPoint];
    }
    return self;
}

-(void) setNetVisible:(bool)visible {
    _visible = visible;
}

- (void) setName:(NSString*)name {
    [_name autorelease];
    _name = [name retain];
    [self setNeedsDisplay:YES];
}

- (void) setWep:(int)wep {
    _wep = wep;
    [self setNeedsDisplay:YES];
}

-(void) setCoord:(waypoint)wp {
    _wp = wp;
    [[WaveHelper zoomPictureView] alignPoint];
}

-(waypoint) coord {
    return _wp;
}

- (void)setFrame:(NSRect)frameRect {
    [super setFrame:frameRect];
    [self setNeedsDisplay:YES];
}

- (void)mouseDown:(NSEvent *)theEvent {
    [[WaveHelper zoomPictureView] mouseDown:theEvent];
}

- (void)drawRect:(NSRect)rect {
    NSColor *c;
    NSRect q;
    float z, r = 14;
    NSBezierPath *x, *legendPath = [[NSBezierPath alloc] init];
    NSFont* textFont = [NSFont fontWithName:@"Monaco" size:12];
    NSMutableDictionary* attrs = [[[NSMutableDictionary alloc] init] autorelease];
    
    if (!_visible) return;
    
    if ([self lockFocusIfCanDraw]) {
        switch (_wep) {
        case 0:
            c = [NSColor yellowColor];
            break;
        case 1:
            c = [NSColor greenColor];
            break;
        case 2:
        case 3:
            c = [NSColor redColor];
        case 4:
            c = [NSColor blueColor];
        default:
            c = [NSColor redColor];
        }
        
        if ([[_name stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]] length] > 0) {
            NSSize size;
            [attrs setObject:textFont forKey:NSFontAttributeName];
            
            size = [_name sizeWithAttributes:attrs];
            size.height+=5;
            size.width+=10;
            
            [legendPath appendBezierPathWithRect:NSMakeRect(r+10, (_frame.size.height - 10 - size.height)/2, size.width, size.height)];
            [[[NSColor blackColor] colorWithAlphaComponent:0.75] set];
            [legendPath fill];
            [[[NSColor whiteColor] colorWithAlphaComponent:0.3] set];
            [NSBezierPath setDefaultLineWidth:2];
            [legendPath stroke];
            [legendPath release];
        
            [attrs setObject:c forKey:NSForegroundColorAttributeName];
            [_name drawAtPoint:NSMakePoint(r+15, (_frame.size.height - 5 - size.height)/2) withAttributes:attrs];
        }
        
        q.size.height=q.size.width=r;
        
        q.origin.x=(5);
        q.origin.y=(_frame.size.height - 10 - r)/2;
        
        for (z=(r/2-1);z>=0;z--) {
            [[c blendedColorWithFraction:(z/(r/2-1)) ofColor:[NSColor blackColor]] set];
            x=[NSBezierPath bezierPathWithOvalInRect:q];
            [x setLineWidth:1.5];
            [x stroke];
            q.origin.x++;
            q.origin.y++;
            q.size.height-=2;
            q.size.width-=2;
        }
        
        [self unlockFocus];
    }
    
}

-(void) dealloc {
    [[WaveHelper zoomPictureView] setNeedsDisplay:YES];
    [_name release];
}
@end
