/*
        
        File:			PacketDriver.h
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import <Foundation/Foundation.h>
#import <IOKit/IODataQueueClient.h>
#import "80211b.h"

@interface PacketDriver : NSObject {
    io_connect_t       	_userClientPort;
    IODataQueueMemory* 	_packetQueue;
    vm_size_t          	_packetQueueSize;
    mach_port_t        	_packetQueuePort;
    int			_driverID;
    UInt16		_channel;
}

-(id)initWithDriver:(int)driverID;
-(unsigned short) getChannel;
-(void) setChannel:(unsigned short)newChannel;
-(void) startCapture:(unsigned short)newChannel;
-(void) stopCapture;

-(WLFrame*) nextFrame;

-(bool) sendFrame:(UInt8*)f withLength:(int) size atInterval:(int)interval;
-(void) stopSendingFrames;
-(void) setSpecial:(special_set*)s;
@end
