/*
        
        File:			PrefsController.m
        Program:		KisMAC
	Author:			Michael Thole
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#import "PrefsController.h"
#import "toolbarHelper.h"
#import "ScanController.h"

@implementation PrefsController

- (id)init {
    prefsToolbar=[[NSToolbar alloc] initWithIdentifier:@"prefsToolbar"];
    [prefsToolbar setDelegate:self];
    [prefsToolbar setAllowsUserCustomization:NO];
    
    toolbarItems = [[NSMutableDictionary alloc] init];
    nibNamesDict = [[NSMutableDictionary alloc] init];
    classNamesDict = [[NSMutableDictionary alloc] init];
    
    [nibNamesDict setObject:@"PrefsScanning" forKey:@"Scanning"];
    [classNamesDict setObject:@"PrefsScanning" forKey:@"Scanning"];
    addToolbarItem(toolbarItems,
                   @"Scanning",
                   @"Scanning",
                   @"Scanning",
                   @"Scanning Options",
                   self,
                   @selector(setImage:),
                   [NSImage imageNamed:@"NSApplicationIcon"],
                   @selector(changeView:),
                   nil);
    defaultToolbarItem = [toolbarItems objectForKey:@"Scanning"];

    [nibNamesDict setObject:@"PrefsTraffic" forKey:@"Traffic"];
    [classNamesDict setObject:@"PrefsTraffic" forKey:@"Traffic"];
    addToolbarItem(toolbarItems,
                   @"Traffic",
                   @"Traffic",
                   @"Traffic",
                   @"Traffic View Options",
                   self,
                   @selector(setImage:),
                   [NSImage imageNamed:@"traffic"],
                   @selector(changeView:),
                   nil);

    [nibNamesDict setObject:@"PrefsFilter" forKey:@"Filter"];
    [classNamesDict setObject:@"PrefsFilter" forKey:@"Filter"];
    addToolbarItem(toolbarItems,
                   @"Filter",
                   @"Filter",
                   @"Filter",
                   @"Filter Options for Data Capture",
                   self,
                   @selector(setImage:),
                   [NSImage imageNamed:@"filter"],
                   @selector(changeView:),
                   nil);


    [nibNamesDict setObject:@"PrefsSounds" forKey:@"Sounds"];
    [classNamesDict setObject:@"PrefsSounds" forKey:@"Sounds"];
    addToolbarItem(toolbarItems,
                   @"Sounds",
                   @"Sounds",
                   @"Sounds",
                   @"Sounds and Speech Options",
                   self,
                   @selector(setImage:),
                   [NSImage imageNamed:@"Sound"],
                   @selector(changeView:),
                   nil);

    [nibNamesDict setObject:@"PrefsDriver" forKey:@"Driver"];
    [classNamesDict setObject:@"PrefsDriver" forKey:@"Driver"];
    addToolbarItem(toolbarItems,
                   @"Driver",
                   @"Driver",
                   @"Driver",
                   @"Wireless Card Driver",
                   self,
                   @selector(setImage:),
                   [NSImage imageNamed:@"KisMAC"],
                   @selector(changeView:),
                   nil);

    [nibNamesDict setObject:@"PrefsSleep" forKey:@"Sleep"];
    [classNamesDict setObject:@"PrefsSleep" forKey:@"Sleep"];
    addToolbarItem(toolbarItems,
                   @"Sleep",
                   @"Sleep",
                   @"Sleep",
                   @"PowerBook Sleep Options",
                   self,
                   @selector(setImage:),
                   [NSImage imageNamed:@"EnergySaver"],
                   @selector(changeView:),
                   nil);
    [nibNamesDict setObject:@"PrefsGPS" forKey:@"GPS"];
    [classNamesDict setObject:@"PrefsGPS" forKey:@"GPS"];
    addToolbarItem(toolbarItems,
                   @"GPS",
                   @"GPS",
                   @"GPS",
                   @"GPS Options",
                   self,
                   @selector(setImage:),
                   [NSImage imageNamed:@"gps"],
                   @selector(changeView:),
                   nil);
    [nibNamesDict setObject:@"PrefsMap" forKey:@"Map"];
    [classNamesDict setObject:@"PrefsMap" forKey:@"Map"];
    addToolbarItem(toolbarItems,
                   @"Map",
                   @"Map",
                   @"Map",
                   @"Mapping Options",
                   self,
                   @selector(setImage:),
                   [NSImage imageNamed:@"map"],
                   @selector(changeView:),
                   nil);

    changesDict = [[NSMutableDictionary alloc] init];
    
    return self;
}

- (void)awakeFromNib {
    [prefsWindow setTitle:@"KisMAC Preferences"];
    [prefsWindow setToolbar:prefsToolbar];
    [prefsWindow center];
    [self changeView:defaultToolbarItem];
}

#pragma mark -

- (void)changeView:(NSToolbarItem*)sender {
    int i, count;
    NSString* nibName = nil;
    NSString* className = nil;
    NSArray* itemsArray = [prefsToolbar items];
    NSView* contentView, *oldView, *controlBox;
    NSRect controlBoxFrame;
    NSRect windowFrame;
    int newWindowHeight;
    NSRect newWindowFrame;

    // TODO make this more error proof

    if(currentToolbarItem == sender) {
        [currentClient updateUI];
        return;
    }
    
    count = [itemsArray count];

    if (currentClient&&(![currentClient updateDictionary])) return;
    
    for(i = 0 ; i < count ; i++) {
        if([[[itemsArray objectAtIndex:i] itemIdentifier] isEqualToString:[sender itemIdentifier]]) {
            nibName = [nibNamesDict objectForKey:[[itemsArray objectAtIndex:i] itemIdentifier]];
            className = [classNamesDict objectForKey:[[itemsArray objectAtIndex:i] itemIdentifier]];
            currentToolbarItem = sender;
            break;
        }
    }

    contentView = [prefsBox contentView];
    oldView = [[contentView subviews] lastObject];
    [oldView removeFromSuperview];

    [currentClient release];
    currentClient = [[[[NSBundle mainBundle] classNamed:className] alloc] init];
    [currentClient setController:defaults];
    
    [NSBundle loadNibNamed:nibName owner:currentClient];

    controlBox = [currentClient controlBox];
    controlBoxFrame = controlBox != nil ? [controlBox frame] : NSZeroRect;

    windowFrame = [NSWindow contentRectForFrameRect:[prefsWindow frame] styleMask:[prefsWindow styleMask]];
    newWindowHeight = NSHeight(controlBoxFrame) + 10;
    newWindowHeight += NSHeight([[prefsToolbar _toolbarView] frame]);
    //newWindowHeight += 43;
    newWindowFrame = [NSWindow frameRectForContentRect:NSMakeRect(NSMinX(windowFrame), NSMaxY(windowFrame) - newWindowHeight, NSWidth(windowFrame), newWindowHeight) styleMask:[prefsWindow styleMask]];
    [prefsWindow setFrame:newWindowFrame display:YES animate:[prefsWindow isVisible]];    
    [controlBox setFrameOrigin:NSMakePoint(floor((NSWidth([contentView frame]) - NSWidth(controlBoxFrame)) / 2.0),
                                           floor(NSHeight([contentView frame]) - NSHeight(controlBoxFrame)))];
    
    [currentClient updateUI];
    [contentView addSubview:controlBox];
}

#pragma mark -


- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar*)toolbar {
    return [NSArray arrayWithObjects:@"Scanning", @"Filter", @"Sounds", @"Driver", @"Sleep", @"GPS", @"Map", @"Traffic", nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar*)toolbar {
    return [self toolbarDefaultItemIdentifiers:toolbar];
}

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
    // We create and autorelease a new NSToolbarItem, and then go through the process of setting up its
    // attributes from the master toolbar item matching that identifier in our dictionary of items.
    NSToolbarItem *newItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
    NSToolbarItem *item = nil;

    item=[toolbarItems objectForKey:itemIdentifier];

    [newItem setLabel:[item label]];
    [newItem setPaletteLabel:[item paletteLabel]];
    if ([item view]!=nil)
    {
        [newItem setView:[item view]];
    }
    else
    {
        [newItem setImage:[item image]];
    }
    [newItem setToolTip:[item toolTip]];
    [newItem setTarget:[item target]];
    [newItem setAction:[item action]];
    [newItem setMenuFormRepresentation:[item menuFormRepresentation]];
    // If we have a custom view, we *have* to set the min/max size - otherwise, it'll default to 0,0 and the custom
    // view won't show up at all!  This doesn't affect toolbar items with images, however.
    if ([newItem view]!=nil)
    {
        [newItem setMinSize:[[item view] bounds].size];
        [newItem setMaxSize:[[item view] bounds].size];
    }
    return newItem;
}

#pragma mark -

- (id)objectForKey:(NSString*)key {
    id object = [changesDict objectForKey:key];
    if(object) return object;
    
    object = [defaults objectForKey:key];
    if(!object) NSLog(@"Error: -[PrefsController objectForKey:%@] returning NULL!", key);
    return object;
}

- (void)setObject:(id)object forKey:(NSString*)key {
    [changesDict setObject:object forKey:key];
}

- (NSWindow*)window {
    return prefsWindow;
}

#pragma mark -

- (IBAction)refreshUI:(id)sender {
    [currentClient updateUI];
}

- (IBAction)clickOk:(id)sender {
    NSEnumerator* keyEnum = [changesDict keyEnumerator];
    NSString* key;

    if (![currentClient updateDictionary]) return;
    
    while(key = [keyEnum nextObject]) {
        //[defaults setObject:[changesDict objectForKey:key] forKey:key];
    }
    
    [(ScanController*)[NSApp delegate] updatePrefs:self];
    [prefsWindow close];
    [changesDict removeAllObjects];
    [currentClient updateUI];
}

- (IBAction)clickCancel:(id)sender {
    [prefsWindow close];
    [changesDict removeAllObjects];
    [currentClient updateUI];
}

- (BOOL)windowShouldClose:(id)sender {
    return [currentClient updateDictionary];
}

- (void)windowWillClose:(NSNotification *)aNotification {
    [currentClient updateDictionary];
    [defaults synchronize];
    [(ScanController*)[NSApp delegate] updatePrefs:self];
}

#pragma mark -

- (void)dealloc {
    [toolbarItems release];
    [nibNamesDict release];
    [classNamesDict release];
    [changesDict release];
    
    [super dealloc];
}

@end