/*
        
        File:			ScanController.h
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import <Cocoa/Cocoa.h>
#import "WaveScanner.h"
#import "InfoController.h"
#import "ImportController.h"
#import "ScanHierach.h"
#import "PacketDriver.h"
#import "ColoredRowTableView.h"
#import "ZoomPictureView.h"
#import "SpinChannel.h"
#import "PrefsController.h"
#import "CrashReportController.h"
#import "WaveContainer.h"

extern NSString *const KisMACViewItemChanged;
extern NSString *const KisMACCrackDone;
extern NSString *const KisMACAdvNetViewInvalid;
extern NSString *const KisMACModalDone;
extern NSString *const KisMACFiltersChanged;
extern NSString *const KisMACStopScanForced;
extern NSString *const KisMACNetworkAdded;

enum {
    tabNetworks = 0,
    tabTraffic = 1,
    tabMap = 2,
    tabDetails = 3
};

//This is the main class. it basically provides an interface between the base and the gui
@interface ScanController : NSObject
{
    NSTimer* aGPSTimer;				//timer for refreshing the gps data
    NSTabViewItem* aDetails;			//the details tab
    NSString* _fileName;			//filename for the currently open capture
    WaveNet* aCurNet;				//the currently selected network
    int _selectedRow;
    int  _visibleTab;				//which tab visible?
    bool aNetHierarchVisible;
    bool aOurDriver;				//did we load the driver?
    bool aOurSleepMode;				//is the sleep mode our fault?
    bool aScanning;				//are we scanning?
    bool aDetailsPane;				//is the details drawer visible
    bool _isSaved;
    bool _doModal;
    bool _refreshGUI;
    
    NSStatusItem *aStatusItem;
    NSStatusBar *aStatusBar;
    NSModalSession aMS;
    NSOpenPanel *aOP;
    NSString *_whichDriver;
    int _activeDriversCount;
    
    NSString* aLastSorted;			//name of the last sorted column
    bool aAscending;				//are we sorting in ascending mode?
    
    ImportController* aImportController;
    NSDrawer *aDetailsDrawer;			//the details drawer

    int _crackType;				//weak or bruteforce, just to show the right error message
    SEL _busyFunction;
    bool _asyncFailure;
    NSString *_activeAttackNetID;
    
    IBOutlet WaveContainer* _container;
    IBOutlet WaveScanner* scanner;
    
    IBOutlet ZoomPictureView* MapView;
    IBOutlet NSTextField* aGPSStatus;
    IBOutlet NSWindow* prefsWindow;
    IBOutlet PrefsController* prefsController;
    IBOutlet NSView* detailsView;
    IBOutlet SpinChannel* ChannelIndicator;
    IBOutlet NSButton* ScanButton;
    IBOutlet NSTextField* StatusField;
    IBOutlet NSView* TrafficView;
    IBOutlet InfoController* aInfoController;
    IBOutlet ColoredRowTableView* aDetailsTable;
    IBOutlet ColoredRowTableView* LogTable;
    IBOutlet ColoredRowTableView* aPacketTable;
    IBOutlet NSWindow* aWindow;
    IBOutlet NSTabView* aTabView;
    IBOutlet NSOutlineView* aOutView;
    IBOutlet NSMenu* aNetworkMenu;
    IBOutlet NSMenu* aCrackMenu;
    IBOutlet NSMenu* aBruteForceMenu;
    //IBOutlet NSMenu* aSystemMenu;
    IBOutlet NSMenu* aChannelMenu;
    IBOutlet NSMenuItem* _debugMenu;
    IBOutlet NSMenuItem* aDeauthMenu;
    IBOutlet NSMenuItem* _authFloodMenu;
    IBOutlet NSMenuItem* aInjPacketsMenu;
    IBOutlet NSMenuItem* _showNetInMap;
    IBOutlet NSMenuItem* _showAllNetsInMap;
    IBOutlet NSPopUpButton* trafficTimePopUp;
    IBOutlet NSPopUpButton* trafficModePopUp;
    IBOutlet NSDrawer *aNetHierarchDrawer;
    IBOutlet SpinChannel *_channelProg;
}

- (IBAction)restartGPS:(id)sender;
- (IBAction)scan:(id)sender;

- (IBAction)updateLogTable:(id)sender complete:(bool)complete;
- (IBAction)updatePrefs:(id)sender;

- (IBAction)showInfo:(id)sender;
- (IBAction)showClient:(id)sender;
- (IBAction)showNetHierarch:(id)sender;

- (IBAction)deautheticateNetwork:(id)sender;
- (IBAction)authFloodNetwork:(id)sender;
- (IBAction)injectPackets:(id)sender;

- (IBAction)bruteASCILettersCrack40bit:(id)sender;
- (IBAction)bruteLowLettersCrack40bit:(id)sender;
- (IBAction)bruteCrack40bit:(id)sender;
- (IBAction)bruteSelectedCrack40bit:(id)sender;
- (IBAction)weakCrackGeneric:(id)sender;
- (IBAction)weakCrack40bit:(id)sender;
- (IBAction)weakCrack104bit:(id)sender;
- (IBAction)wordCrackApple40bit:(id)sender;
- (IBAction)wordCrackApple104bit:(id)sender;
- (IBAction)wordCrackMD5104bit:(id)sender;

- (IBAction)selChannel:(id)sender;
- (IBAction)selChannelRange:(id)sender;
- (IBAction)setAutoAdjustTimer:(id)sender;
- (IBAction)showCurNetArea:(id)sender;
- (IBAction)showAllNetArea:(id)sender;

@end


@interface ScanController(MenuExtension) 
- (IBAction)showPrefs:(id)sender;


- (IBAction)openFile:(id)sender;
- (IBAction)openMapFile:(id)sender;

- (IBAction)importFile:(id)sender;
- (IBAction)importPCAP:(id)sender;
- (IBAction)importNetstumbler:(id)sender;
- (IBAction)importImage:(id)sender;
- (IBAction)importMapFromServer:(id)sender;

- (IBAction)saveFile:(id)sender;
- (IBAction)saveFileAs:(id)sender;
- (IBAction)saveMapAs:(id)sender;

- (IBAction)exportNS:(id)sender;
- (IBAction)exportWarD:(id)sender;
- (IBAction)exportMacstumbler:(id)sender;
- (IBAction)exportPDF:(id)sender;

- (IBAction)clearAllNetworks:(id)sender;

- (IBAction)decryptPCAPFile:(id)sender;


- (IBAction)clearNetwork:(id)sender;

- (IBAction)closeActiveWindow:(id)sender;

- (IBAction)openWebsiteURL:(id)sender;
- (IBAction)openDonateURL:(id)sender;


- (IBAction)debugSaveStressTest:(id)sender;
- (IBAction)gpsDebugToConsole:(id)sender;
- (IBAction)debugBeaconFlood:(id)sender;

@end
