/*
        
        File:			ScanControllerMenus.m
        Program:		KisMAC
	Author:			Michael Roßberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import "ScanController.h"
#import "ScanControllerPrivate.h"
#import "DownloadMapController.h"
#import "DecryptController.h"

@implementation ScanController(MenuExtension)

#pragma mark -
#pragma mark KISMAC MENU
#pragma mark -

- (IBAction)showPrefs:(id)sender {
    if(!prefsWindow) {
        if(![NSBundle loadNibNamed:@"Preferences" owner:self]) {
            NSLog(@"Preferences.nib failed to load!");
            return;
        }
    } else
        [prefsController refreshUI:self];
    
    if(![[NSUserDefaults standardUserDefaults] objectForKey:@"NSWindow Frame prefsWindow"])
        [prefsWindow center];

    [prefsWindow makeKeyAndOrderFront:nil];
}

#pragma mark -
#pragma mark FILE MENU
#pragma mark -

- (IBAction)openFile:(id)sender {
    if ((![self isSaved])&&(sender!=self)) {
        [self showWantToSaveDialog:@selector(reallyWantToOpen:returnCode:contextInfo:)];
        return;
    }

    aOP=[NSOpenPanel openPanel];
    [aOP setAllowsMultipleSelection:NO];
    [aOP setCanChooseFiles:YES];
    [aOP setCanChooseDirectories:NO];
    if ([aOP runModalForTypes:[NSArray arrayWithObject:@"kismac"]]==NSOKButton) {
        [_fileName release];
        _fileName=[[aOP filename] retain];
        [self clearAllNetworks:self];
        
        [self showBusy:@selector(performOpenFile:) withArg:[aOP filename]];
        
        [self updateLogTable:self complete:YES];
        [self refreshScanHierarch];
        _isSaved = YES;
    }
}
- (void)performOpenFile:(NSString*)filename {
    [scanner loadFromFile:filename];
}
- (void)reallyWantToOpen:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo {
    switch (returnCode) {
    case NSAlertDefaultReturn:
        [self saveFile:nil];
    case NSAlertOtherReturn:
        break;
    case NSAlertAlternateReturn:
    default:
        [self clearAllNetworks:self];
        [self openFile:self];
    }
}

- (IBAction)openMapFile:(id)sender {
    aOP=[NSOpenPanel openPanel];
    [aOP setAllowsMultipleSelection:NO];
    [aOP setCanChooseFiles:YES];
    [aOP setCanChooseDirectories:NO];
    
    if ([aOP runModalForTypes:[NSArray arrayWithObject:@"kismap"]]==NSOKButton) {
        [self clearAreaMap];
        [self showBusy:@selector(performOpenMapFile:) withArg:[[aOP filenames] objectAtIndex:0]];
        [self showMap];
    }
}
- (void)performOpenMapFile:(id)filename {
    [[WaveHelper zoomPictureView] loadFromFile:filename];
}

#pragma mark -

- (IBAction)importImage:(id)sender {
    aOP=[NSOpenPanel openPanel];
    [aOP setAllowsMultipleSelection:NO];
    [aOP setCanChooseFiles:YES];
    [aOP setCanChooseDirectories:NO];
    if ([aOP runModalForTypes:[NSImage imageFileTypes]]==NSOKButton) {
        [self clearAreaMap];
        [self showBusy:@selector(performImportMap:) withArg:[[aOP filenames] objectAtIndex:0]];
    }
}
- (void)performImportMap:(id)filename {
    NSImage *x;
  
    x=[[NSImage alloc] initWithContentsOfFile:filename];
    [MapView setImage:x];
    [x release];
    [self showMap];
}

- (IBAction)importMapFromServer:(id)sender {
    DownloadMapController* dmc = [[DownloadMapController alloc] initWithWindowNibName:@"DownloadMap"];
    
    [[dmc window] setFrameUsingName:@"aKisMAC_DownloadMap"];
    [[dmc window] setFrameAutosaveName:@"aKisMAC_DownloadMap"];
    
    [dmc setCoordinates:[[WaveHelper gpsController] currentPoint]];
    [dmc showWindow:self];
    [[dmc window] makeKeyAndOrderFront:self];
    
    if (aMS) return;
    aMS=[NSApp beginModalSessionForWindow:[dmc window]];
    for (;;) {
        if ([NSApp runModalSession:aMS] != NSRunContinuesResponse)
        break;
    }
    [NSApp endModalSession:aMS];
    aMS=Nil;    
    
    if ([dmc mapLocation]) {
        [self clearAreaMap];
        [self showBusy:@selector(performImportMapFromServer:) withArg:[dmc mapLocation]];
        if (_asyncFailure) NSBeginCriticalAlertSheet(
            NSLocalizedString(@"Import failed", "Import failure dialog title"),
            OK, NULL, NULL, aWindow, self, NULL, NULL, NULL, 
            NSLocalizedString(@"Import failure description", "LONG description. Maybe no internet?")
            //"KisMAC was unable to complete the import. Are you sure that you have a valid internet connection?"
            );
        else {
            [[WaveHelper zoomPictureView] setWaypoint:1 toPoint:[dmc centerPoint] atCoordinate:[dmc coordinates]];
            [self showMap];
        }
    }
    
    [dmc release];
}
- (void)performImportMapFromServer:(id)url {
    NSImage *x;
    
    NS_DURING
        x=[[NSImage alloc] initWithContentsOfURL:url];
        if (x) {
            [MapView setImage:x];
            [x release];
            _asyncFailure = NO;
        } else _asyncFailure = YES;
    NS_HANDLER
        _asyncFailure = YES;
    NS_ENDHANDLER
}

- (IBAction)importFile:(id)sender {
    aOP=[NSOpenPanel openPanel];
    [aOP setAllowsMultipleSelection:NO];
    [aOP setCanChooseFiles:YES];
    [aOP setCanChooseDirectories:NO];
    if ([aOP runModalForTypes:[NSArray arrayWithObject:@"kismac"]]==NSOKButton) {
        [_fileName release];
        _fileName=[[aOP filename] retain];
        
        [self stopActiveAttacks];
        [self stopScan];

        _refreshGUI = NO;
        [self showBusy:@selector(performImportFile:) withArg:[aOP filename]];
        _refreshGUI = YES;
        
        [[NSNotificationCenter defaultCenter] postNotificationName:KisMACViewItemChanged object:self];
        [self updateLogTable:self complete:YES];
        [self refreshScanHierarch];
        _isSaved = NO;
    }
}
- (void)performImportFile:(NSString*)filename {
    [scanner importFromFile:filename];
}

- (IBAction)importPCAP:(id)sender {
    aOP=[NSOpenPanel openPanel];
    [aOP setAllowsMultipleSelection:YES];
    [aOP setCanChooseFiles:YES];
    [aOP setCanChooseDirectories:NO];
    if ([aOP runModalForTypes:nil]==NSOKButton) {
        [self stopScan];
        [LogTable deselectAll:self];
        
        [self showBusy:@selector(performImportPCAP:) withArg:[aOP filenames]];
    }
    [self updateLogTable:self complete:YES];
}
- (void)performImportPCAP:(id)array {
    unsigned int i;
    for (i=0;i<[array count];i++) [scanner readPCAPDump:[array objectAtIndex:i]];
    _isSaved = NO;
}

- (IBAction)importNetstumbler:(id)sender {
    aOP=[NSOpenPanel openPanel];
    [aOP setAllowsMultipleSelection:NO];
    [aOP setCanChooseFiles:YES];
    [aOP setCanChooseDirectories:NO];
    if ([aOP runModalForTypes:[NSArray arrayWithObjects:@"txt", @"ns1", nil]]==NSOKButton) {
        [_fileName release];
        _fileName=[[aOP filename] retain];
        
        [self stopActiveAttacks];
        [self stopScan];

        _refreshGUI = NO;
        [self showBusy:@selector(performImportNetstumbler:) withArg:[aOP filename]];
        _refreshGUI = YES;
        
        [[NSNotificationCenter defaultCenter] postNotificationName:KisMACViewItemChanged object:self];
        [self updateLogTable:self complete:YES];
        [self refreshScanHierarch];
        _isSaved = NO;
    }
}
- (void)performImportNetstumbler:(NSString*)filename {
    [scanner importFromNetstumbler:filename];
}

#pragma mark -

- (IBAction)saveFile:(id)sender {
    if (_fileName==Nil) [self saveFileAs:nil];
    else {
        [scanner saveToFile:_fileName];
        _isSaved = ! aScanning;
    }
}

- (IBAction)saveFileAs:(id)sender {
    NSSavePanel *aSP;
    
    aSP=[NSSavePanel savePanel];
    [aSP setRequiredFileType:@"kismac"];
    [aSP setCanSelectHiddenExtension:YES];
    [aSP setTreatsFilePackagesAsDirectories:NO];
    if ([aSP runModal]==NSFileHandlingPanelOKButton) {
        [_fileName release];
        _fileName=[[[aSP filename] stringByExpandingTildeInPath] retain];
        
        [self stopActiveAttacks];
        [self stopScan];
        
        [self showBusy:@selector(performSaveFileAs:) withArg:[aSP filename]];
        if (_asyncFailure) [self showSavingFailureDialog];
        else _isSaved = ! aScanning;
    }
}
- (void)performSaveFileAs:(id)filename {
    NS_DURING
        [scanner saveToFile:filename];
        _asyncFailure=NO;
    NS_HANDLER
        _asyncFailure=YES;
        NSLog(@"Saving failed, because of an internal error!");
    NS_ENDHANDLER
}

- (IBAction)saveMapAs:(id)sender {
    NSSavePanel *aSP;

    aSP=[NSSavePanel savePanel];
    [aSP setRequiredFileType:@"kismap"];
    [aSP setCanSelectHiddenExtension:YES];
    [aSP setTreatsFilePackagesAsDirectories:NO];
    if ([aSP runModal]==NSFileHandlingPanelOKButton) {
        [self showBusy:@selector(performSaveMapAs:) withArg:[aSP filename]];
        if (_asyncFailure) [self showSavingFailureDialog];
    }
}
- (void)performSaveMapAs:(id)filename {
    NS_DURING
        [[WaveHelper zoomPictureView] saveToFile:filename];
        _asyncFailure=NO;
    NS_HANDLER
        _asyncFailure=YES;
        NSLog(@"Map saving failed, because of an internal error!");
    NS_ENDHANDLER
}

#pragma mark -

- (IBAction)exportNS:(id)sender {
    NSSavePanel *aSP;
    aSP=[NSSavePanel savePanel];
    [aSP setRequiredFileType:@"ns1"];
    [aSP setCanSelectHiddenExtension:YES];
    [aSP setTreatsFilePackagesAsDirectories:NO];
    if ([aSP runModal]==NSFileHandlingPanelOKButton) {
        [self showBusy:@selector(performExportNS:) withArg:[aSP filename]];
        if (_asyncFailure) [self showExportFailureDialog];
    }
}
- (void)performExportNS:(id)filename {
    if (![scanner exportNSToFile:filename]) _asyncFailure = YES;
    else _asyncFailure = NO;
}

- (IBAction)exportWarD:(id)sender {
    NSSavePanel *aSP;
    
    aSP=[NSSavePanel savePanel];
    [aSP setRequiredFileType:@"txt"];
    [aSP setCanSelectHiddenExtension:YES];
    [aSP setTreatsFilePackagesAsDirectories:NO];
    if ([aSP runModal]==NSFileHandlingPanelOKButton) {
        [self showBusy:@selector(performExportWarD:) withArg:[aSP filename]];
        if (_asyncFailure) [self showExportFailureDialog];
    }
}
- (void)performExportWarD:(id)filename {
    if (![scanner exportWarDToFile:filename]) _asyncFailure = YES;
    else _asyncFailure = NO;
}

- (IBAction)exportMacstumbler:(id)sender {
    NSSavePanel *aSP;
    
    aSP=[NSSavePanel savePanel];
    [aSP setRequiredFileType:@"txt"];
    [aSP setCanSelectHiddenExtension:YES];
    [aSP setTreatsFilePackagesAsDirectories:NO];
    if ([aSP runModal]==NSFileHandlingPanelOKButton) {
        [self showBusy:@selector(performExportMacStumbler:) withArg:[aSP filename]];
        if (_asyncFailure) [self showExportFailureDialog];
    }
}
- (void)performExportMacStumbler:(id)filename {
    if (![scanner exportMacStumblerToFile:filename]) _asyncFailure = YES;
    else _asyncFailure = NO;
}

- (IBAction)exportPDF:(id)sender {
    NSSavePanel *aSP;
    
    aSP=[NSSavePanel savePanel];
    [aSP setRequiredFileType:@"pdf"];
    [aSP setCanSelectHiddenExtension:YES];
    [aSP setTreatsFilePackagesAsDirectories:NO];
    if ([aSP runModal]==NSFileHandlingPanelOKButton) {
        [self showBusy:@selector(performExportPDF:) withArg:[aSP filename]];
        if (_asyncFailure) [self showExportFailureDialog];
    }
}
- (void)performExportPDF:(id)filename {
    NSData *data;
    
    NS_DURING
        data = [[WaveHelper zoomPictureView] dataWithPDFInsideRect:[[WaveHelper zoomPictureView] frame]];
        [data writeToFile:[filename stringByExpandingTildeInPath] atomically:NO];
        _asyncFailure = NO;
    NS_HANDLER
        _asyncFailure = YES;
    NS_ENDHANDLER
}

#pragma mark -

- (IBAction)clearAllNetworks:(id)sender {
    if ((![self isSaved])&&(sender!=self)) {
        [self showWantToSaveDialog: @selector(reallyWantToClean:returnCode:contextInfo:)];
        return;
    }
    _isSaved = YES;

    [self stopActiveAttacks];
    [self stopScan];

    [self clearAreaMap];
    [self hideDetails];
    [aTabView selectFirstTabViewItem:self];
    [LogTable deselectAll:self];

    [scanner clearAllNetworks];
    aCurNet = Nil;
    [WaveHelper secureRelease:&_fileName];
    
    [self refreshScanHierarch];    
    [self updateLogTable:self complete:YES];
}

- (void)reallyWantToClean:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo {
    switch (returnCode) {
    case NSAlertDefaultReturn:
        [self saveFile:nil];
    case NSAlertOtherReturn:
        break;
    case NSAlertAlternateReturn:
    default:
        [self clearAllNetworks:self];
    }
}

#pragma mark -

- (IBAction)decryptPCAPFile:(id)sender {
    DecryptController* d;
    
    d = [[DecryptController alloc] initWithWindowNibName:@"DecryptDialog"];
    [d showWindow:sender];
}

#pragma mark -
#pragma mark NETWORK MENU
#pragma mark -

- (IBAction)clearNetwork:(id)sender {
    WaveNet* net = aCurNet;
    _isSaved = NO;
     if (sender!=self) {
        NSBeginAlertSheet(
            NSLocalizedString(@"Really want to delete?", "Network deletion dialog title"),
            NSLocalizedString(@"Delete", "Network deletion dialog button"),
            NSLocalizedString(@"Delete and Filter", "Network deletion dialog button"),
            CANCEL, aWindow, self, NULL, @selector(reallyWantToDelete:returnCode:contextInfo:), self,
            NSLocalizedString(@"Network deletion dialog text", "LONG description of what this dialog does")
            //@"Are you sure that you whish to delete the network? This action cannot be undone. You may also choose to add the network to the filter list in the preferences and prevent it from re-appearing."
            );
        return;
    }
           
    [self clearAreaMap];
    [self hideDetails];
    [aTabView selectFirstTabViewItem:self];
    [LogTable deselectAll:self];
    
    if (net) {
        if ([[net ID] isEqualToString:_activeAttackNetID]) [self stopActiveAttacks];
        [scanner clearNetwork:net];
    }
    aCurNet = Nil;
    
    [self refreshScanHierarch];
    [self updateLogTable:self complete:YES];
}

- (void)reallyWantToDelete:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo {
    NSUserDefaults *sets;
    NSMutableArray *temp;
    NSString *mac;
    
    switch (returnCode) {
    case NSAlertDefaultReturn:
        [self clearNetwork:self];
    case NSAlertOtherReturn:
        break;
    case NSAlertAlternateReturn:
    default:
        sets=[NSUserDefaults standardUserDefaults];
        temp = [NSMutableArray arrayWithArray:[sets objectForKey:@"FilterBSSIDList"]];
        mac = [aCurNet ID];
        
        if (mac!=Nil && [temp indexOfObject:mac]==NSNotFound) {
            [temp addObject:mac];
            [sets setObject:temp forKey:@"FilterBSSIDList"];
        }
        [[NSNotificationCenter defaultCenter] postNotificationName:KisMACFiltersChanged object:self];

        [self clearNetwork:self];
    }
}

#pragma mark -
#pragma mark WINDOW MENU
#pragma mark -

- (IBAction)closeActiveWindow:(id)sender {
    [[NSApp keyWindow] performClose:sender];
}

#pragma mark -
#pragma mark HELP MENU
#pragma mark -

- (IBAction)openWebsiteURL:(id)sender {
    [[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"http://kismac.binaervarianz.de"]];
}

- (IBAction)openDonateURL:(id)sender {
    [[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"https://www.paypal.com/xclick/business=charity%40binaervarianz.de&item_name=Support+for+KisMAC+Development"]];
}

#pragma mark -
#pragma mark DEBUG MENU
#pragma mark -

- (IBAction)debugSaveStressTest:(id)sender {
    [NSThread detachNewThreadSelector:@selector(doDebugSaveStressTest:) toTarget:self withObject:nil];
}

- (IBAction)doDebugSaveStressTest:(id)anObject {
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
    int i;
    
    for (i=0; i< 1500; i++) {
        if ([self saveFile:self]) {
            NSLog(@"Stress test broken!");
            break;
        }
        [NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:1]];
    }
    [pool release];
}

- (IBAction)gpsDebugToConsole:(id)sender {
    if ([sender state] == NSOffState) {
        [[WaveHelper gpsController] writeDebugOutput:YES];
        [sender setState: NSOnState];
    } else {
        [[WaveHelper gpsController] writeDebugOutput:NO];
        [sender setState: NSOffState];
    }
}


- (IBAction)debugBeaconFlood:(id)sender {
    if ([sender state]==NSOffState) {
        [self stopActiveAttacks];
        if (![scanner beaconFlood]) {
            NSLog(@"Could not start injectiong beacons like hell. Did you choose an injection driver?\n");
            return;
        }
        [sender setState:NSOnState];
    } else {
        [self stopActiveAttacks];
        [sender setState:NSOffState];
    }
}


@end
