/*
        
        File:			ScanControllerPrivate.m
        Program:		KisMAC
	Author:			Michael Roßberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import "ScanControllerPrivate.h"
#import "WaveHelper.h"

@implementation ScanController(PrivateExtension) 

- (void)updateChannelMenu {
    NSUserDefaults *sets;
    NSArray *a;
    unsigned int x, c, lc;
    NSMenuItem *mi;
    WaveDriver *wd;
    WaveDriver *actWD = Nil;
    NSDictionary *config;
    NSString *whichDriver;
    sets=[NSUserDefaults standardUserDefaults];
    
    for (x = 0; x < _activeDriversCount; x++) {
        [aChannelMenu removeItemAtIndex:0];
    }
    _activeDriversCount = 0;
    
    a = [WaveHelper getWaveDrivers];
    if ([a count] == 0) {
        mi = (NSMenuItem*)[aChannelMenu insertItemWithTitle:NSLocalizedString(@"(No driver loaded)", "menu item") action:@selector(selDriver:) keyEquivalent:@"" atIndex:0];
        [mi setEnabled:NO];
        _whichDriver = Nil;
        _activeDriversCount = 1;
        
        for (x = 0; x < [aChannelMenu numberOfItems]; x++)
           [[aChannelMenu itemAtIndex:x] setEnabled: NO];

    } else {
        a = [a sortedArrayUsingSelector:@selector(compareDrivers:)];

        whichDriver = [sets objectForKey:@"whichDriver"];
        if (!whichDriver) whichDriver = [[a objectAtIndex:0] deviceName];
        
        for (x = 0; x < [a count]; x++) {
            wd = [a objectAtIndex:x];
            mi = (NSMenuItem*)[aChannelMenu insertItemWithTitle:[wd deviceName] action:@selector(selDriver:) keyEquivalent:@"" atIndex:0];
            _activeDriversCount++;
            if ([[wd deviceName] isEqualToString: whichDriver]) {
                [mi setState:NSOnState];
                actWD = wd;
            }
        }
        
        if (!actWD) { //driver is not loaded anymore?
            whichDriver = [[a objectAtIndex:0] deviceName];
            [sets setObject:whichDriver forKey:@"whichDriver"];
            
            [self updateChannelMenu];
            return;
        }
        [WaveHelper secureReplace:&_whichDriver withObject:whichDriver];

        
        for (x = _activeDriversCount; x < [aChannelMenu numberOfItems]; x++) {
           mi = (NSMenuItem*)[aChannelMenu itemAtIndex:x];
           if (![mi isSeparatorItem]) [mi setEnabled:[actWD allowsChannelHopping]];
        }
        
        [[aChannelMenu itemAtIndex:_activeDriversCount+4] setState: [actWD ETSI] ? NSOnState : NSOffState];
        [[aChannelMenu itemAtIndex:_activeDriversCount+3] setState: [actWD FCC]  ? NSOnState : NSOffState];
        
        config = [actWD configuration];
        
        c = 0;
        lc = 0;
        
        for (x = 1; x <= 14; x++) {
            if ([[config objectForKey:[NSString stringWithFormat:@"useChannel%.2i",x]] intValue]) {
                c++;
                lc = x;
            }
        }
        
        for (x = 1; x <= 14; x++)
            [[aChannelMenu itemAtIndex:x + 5 + _activeDriversCount] setState:((c==1 && lc == x) ? NSOnState : NSOffState)];
        
        [[aChannelMenu itemAtIndex: _activeDriversCount + 1] setState:([actWD autoAdjustTimer]? NSOnState : NSOffState)];

        //just make sure the driver knows about its configuration
        [actWD setConfiguration: [actWD configuration]];
    }
}

- (void)menuSetEnabled:(bool)a menu:(NSMenu*)menu {
    int x;
    
    [menu setAutoenablesItems:a];
    for (x=0;x<[menu numberOfItems];x++) 
        if ([[menu itemAtIndex:x] hasSubmenu]) [self menuSetEnabled:a menu:[[menu itemAtIndex:x] submenu]];
        else [[menu itemAtIndex:x] setEnabled:a];
}

#pragma mark -

- (void)selectNet:(WaveNet*)net {
    aCurNet=net;
    if (net!=nil) {
        [self menuSetEnabled:YES menu:aNetworkMenu];
        [_showNetInMap setEnabled:YES];
        [aInfoController showNet:net];
        _selectedRow = 0;
    } else {
        [aInfoController showNet:nil];
        [aDetailsDrawer close];
        [self menuSetEnabled:NO menu:aNetworkMenu];
        [_showNetInMap setEnabled:NO];
        _selectedRow = [LogTable selectedRow] - 1;
    }
}

#pragma mark -

- (void)showDetailsFor:(WaveNet*)net {
    [self selectNet:net];
    [aDetailsDrawer close];
    if ([aTabView indexOfTabViewItemWithIdentifier:@"details"]==NSNotFound)
        [aTabView addTabViewItem:aDetails];
    
    _visibleTab = tabDetails;
    [aTabView selectTabViewItem:aDetails];
}

- (void)hideDetails {
    [self selectNet:nil];
    if ([aTabView indexOfTabViewItemWithIdentifier:@"details"]!=NSNotFound) {
        [aTabView removeTabViewItem:[aTabView tabViewItemAtIndex:[aTabView indexOfTabViewItemWithIdentifier:@"details"]]];
        _visibleTab = tabNetworks;
    }
}

#pragma mark -

- (void)startScan {
    bool result;
    
    if ([WaveHelper loadDrivers]) {
        if ([[WaveHelper getWaveDrivers] count] == 0) {
            NSBeginAlertSheet(@"No driver selected.", NULL, NULL, NULL, aWindow, self, NULL, NULL, NULL, @"Please select a WiFi Driver in the Preferences Window!");
            return;
        }
        
        aScanning=YES;
        _isSaved = NO;
        [ChannelIndicator startAnimation:self];
        [ScanButton setTitle:@"Cancel"];
        [StatusField setStringValue:@"Performing Scan..."];
        result=[scanner startScanning];
    }
    
    [self updateChannelMenu];
}

- (void)stopScan {
    bool result;
    
    result=[scanner stopScanning];
    [ChannelIndicator stopAnimation:self];
    [ScanButton setTitle:@"Scan"];
    [StatusField setStringValue:@"Ready..."];
    aScanning=NO;
    
    [self updateChannelMenu];
}

- (void)startCrack {
    [self stopScan];
    aImportController = [[ImportController alloc] initWithWindowNibName:@"Crack"];
    [[aImportController window] setFrameUsingName:@"aKisMAC_Import"];
    [[aImportController window] setFrameAutosaveName:@"aKisMAC_Import"];
    [aImportController setTitle:@"KisMAC - Cracking"];
    [aImportController showWindow:self];
    _doModal = YES;
}


- (void)runCrack {
    if (aMS) return;
    aMS=[NSApp beginModalSessionForWindow:[aImportController window]];
    [NSApp runModalSession:aMS];

    for (;;) {
        if (([NSApp runModalSession:aMS] != NSRunContinuesResponse) || (!_doModal)) break;
    }
    [NSApp endModalSession:aMS];
    aMS=Nil;
    
    [aCurNet updatePassword];

    [aInfoController reloadData];
    [[aImportController window] close];
    [aImportController stopAnimation];
    if ([[aCurNet key] isEqualToString:@"<unresolved>"]&&(![aImportController canceled])) {
        if (_crackType==1) NSBeginAlertSheet(NSLocalizedString(@"Cracking unsuccessful", "Error box title for WEP attacks"),
            OK, NULL, NULL, aWindow, self, NULL, NULL, NULL, 
            NSLocalizedString(@"Cracking unsuccessful description for weak scheduling attack", "LONG description with possible causes"));
            //@"KisMAC was not able to recover the WEP key. This is either because you have not collected enough weak keys, you will need a value way bigger than 1000. Or another reason might be the fact that the base station is using extended features like WEP+ or the key was simply changed during the collection process.");
        else NSBeginAlertSheet(NSLocalizedString(@"Cracking unsuccessful", "Error box title for WEP attacks"),
            OK, NULL, NULL, aWindow, self, NULL, NULL, NULL, 
            NSLocalizedString(@"Cracking unsuccessful description for brutforce", "LONG description with possible causes")
            //@"The key could not have been recovered. Possible reasons are: 1. The key was not a 40-bit key. 2.The crypto algorithm is not WEP. 3. Advanced Features like LEAP are activated."
            );
    }
    [aImportController release];
    aImportController=Nil;
}

- (bool)startActiveAttack {
    WaveDriver *wd;
    
    if (aCurNet == Nil) {
        NSBeginAlertSheet(NSLocalizedString(@"No network selected.", "Error box title for active attacks"),
            OK, NULL, NULL, aWindow, self, NULL, NULL, NULL, 
            NSLocalizedString(@"No network selected failure description", "LONG description")
            //@"You will have to select a network, which you wish to attack!"
            );
        return NO;
    }
    
    if (![WaveHelper loadDrivers]) return NO;         // the user canceled or did not enter password
    
    wd = [WaveHelper injectionDriver];
    if (!wd) {
         NSBeginAlertSheet(NSLocalizedString(@"No injection driver.", "Error box title for active attacks"),
            OK, NULL, NULL, aWindow, self, NULL, NULL, NULL, 
            NSLocalizedString(@"No injection driver failure description", "LONG text about where you can enable it")
            //@"You have no primary injection driver chosen, please select one in the preferences dialog."
            );
        return NO;
    }
    
    if ([wd hopping]) {
        NSBeginAlertSheet(NSLocalizedString(@"Channel hopping enabled.", "Error box title for active attacks"),
            OK, NULL, NULL, aWindow, self, NULL, NULL, NULL, 
            NSLocalizedString(@"Channel hopping enabled failure description", "LONG text about why this does not work with active attacks")
            //@"You have channel hopping enabled! In order to send frames correctly you will need to disable it and select a channel, where you can recieve the network correctly."
            );
        return NO;
    }
    
    if (_activeAttackNetID) [self stopActiveAttacks];
    
    _activeAttackNetID = [[aCurNet ID] retain];
    
    return YES;
}

- (void)stopActiveAttacks {
    [_activeAttackNetID release];
    _activeAttackNetID = Nil;
    
    [scanner stopSendingFrames];
    
    [aDeauthMenu setState: NSOffState];
    [aDeauthMenu setTitle: NSLocalizedString(@"Deauthenticate", "menu item. description must be the same as in MainMenu.nib!")];
    [_authFloodMenu setState: NSOffState];
    [_authFloodMenu setTitle: NSLocalizedString(@"Authentication Flood", "menu item. description must be the same as in MainMenu.nib!")];
    [aInjPacketsMenu setState: NSOffState];
    [aInjPacketsMenu setTitle: NSLocalizedString(@"Reinject Packets", "menu item. description must be the same as in MainMenu.nib!")];
}


#pragma mark -

- (void)showMap {
    [LogTable deselectAll:self];
    [self hideDetails];
    [aTabView selectTabViewItemWithIdentifier:@"map"];
    [self tabView:aTabView willSelectTabViewItem:[aTabView tabViewItemAtIndex:[aTabView indexOfTabViewItemWithIdentifier:@"map"]]];
}

- (void)clearAreaMap {
    [[WaveHelper zoomPictureView] clearAdvNet];
    [_showNetInMap setTitle: NSLocalizedString(@"Show Net Area", "menu item. description must be the same as in MainMenu.nib!")];
    [_showNetInMap setState: NSOffState];
    [_showAllNetsInMap setState: NSOffState];
}

- (void)advNetViewInvalid:(NSNotification*)note {
    [self clearAreaMap];
}

- (void)networkAdded:(NSNotification*)note {
    [self updateLogTable:self complete:YES];
}

- (bool)isSaved {
    if ([[[NSUserDefaults standardUserDefaults] objectForKey:@"dontAskToSave"] boolValue]) return YES; //dont bother the user if set in preferences
    
    if (!_isSaved) return [LogTable numberOfRows]==0;
    return YES;
}
#pragma mark -

- (void)refreshScanHierarch {
    if (!_refreshGUI) return;
    
    [ScanHierach clearAllItems];
    [ScanHierach updateTree];
    [aOutView reloadData];
}

#pragma mark -

- (void)modalDone:(NSNotification*)note {
    [NSApp abortModal];
    _doModal = NO;
}

- (void)showBusy:(SEL)function withArg:(id)obj {
    ImportController *busyController;

    if (_doModal) return;
    if (aMS) return;
    _doModal = YES;
    
    _busyFunction = function;
    
    busyController = [[ImportController alloc] initWithWindowNibName:@"Import"];
    if (!busyController) {
        NSLog(@"Error could not open Import.nib!");
        return;
    }

    [[busyController window] setFrameUsingName:@"aKisMAC_BusyWindow"];
    [[busyController window] setFrameAutosaveName:@"aKisMAC_BusyWindow"];
    [busyController showWindow:self];
    //[[busyController window] makeKeyAndOrderFront:self];
    
    aMS=[NSApp beginModalSessionForWindow:[busyController window]];
    [NSApp runModalSession:aMS];
    
    [obj retain];
    [NSThread detachNewThreadSelector:@selector(busyThread:) toTarget:self withObject:obj];

    for (;;) {
        if (([NSApp runModalSession:aMS] != NSRunContinuesResponse) || (!_doModal))
            break;
        [NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.1]];
        //[busyController animate];
    }
    [NSApp endModalSession:aMS];
    aMS=Nil;
    
    [[busyController window] close];
    [busyController stopAnimation];
    [busyController release];
    [obj release];
}

- (void)busyThread:(id)anObject {
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
    
    [self performSelector:_busyFunction withObject:anObject];
    [self modalDone:nil];
    
    [pool release];
}

#pragma mark -

- (void)showWantToSaveDialog:(SEL)overrideFunction {
    NSBeginAlertSheet(
        NSLocalizedString(@"Save Changes?", "Save changes dialog title"),
        NSLocalizedString(@"Save", "Save changes dialog button"),
        NSLocalizedString(@"Don't Save", "Save changes dialog button"),
        CANCEL, aWindow, self, NULL, overrideFunction, self, 
        NSLocalizedString(@"Save changes dialog text", "LONG dialog text")
        //@"You have been scanning since your last save. Do you want to save your results?"
        );
}

- (void)showExportFailureDialog {
    NSBeginCriticalAlertSheet(
        NSLocalizedString(@"Export failed", "Export failure dialog title"),
        OK, NULL, NULL, aWindow, self, NULL, NULL, NULL, 
        NSLocalizedString(@"Export failure description", "LONG Export failure dialog text. Permissions?!")
        //@"KisMAC was unable to complete the export, because of an I/O error. Are permissions correct?"
        );
}

- (void)showSavingFailureDialog {
    NSBeginCriticalAlertSheet(
        NSLocalizedString(@"Saving failed", "Saving failure dialog title"),
        OK, NULL, NULL, aWindow, self, NULL, NULL, NULL, 
        NSLocalizedString(@"Saving failure description", "LONG Saving failure dialog text. Permissions?!")
        //@"KisMAC was unable to complete the saving process, because of an I/O error. Are permissions correct?"
        );
}

- (void)showNeedMorePacketsDialog {
    NSBeginAlertSheet(ERROR_TITLE, 
        OK, NULL, NULL, [WaveHelper mainWindow], self, NULL, NULL, NULL,
        NSLocalizedString(@"Need more packets description", "LONG dialog text. The user needs more packets. active scanners are not able to do this")
        //@"You have not collected enough data packets to perform this attack. Please capture some more traffic"
        );
}

- (void)showNeedMoreWeakPacketsDialog {
    NSBeginAlertSheet(NSLocalizedString(@"Cracking unsuccessful", "Error box title for WEP attacks"),
        OK, NULL, NULL, [WaveHelper mainWindow], self, NULL, NULL, NULL,
        NSLocalizedString(@"Need more weak packets description", "LONG dialog text. The user needs more weak packets. explain")
        //@"KisMAC cannot recover your WEP key, using this method. The weak scheduling attack requires a lot of weak keys. Please see the help file for more details."
        );
}
        
@end
