/*
        
        File:			ScanHierach.mm
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import "ScanHierach.h"
#import "WaveHelper.h"

@implementation ScanHierach
static ScanHierach *rootItem = nil;	//root item channels
static ScanHierach *rootItem2 = nil;	//root item ssids
static ScanHierach *rootItem3 = nil;	//root item ssids

#define IsALeafNode ((id)-1)

//TODO document this

//creates a new item
- (id)initWithName:(NSString *)name type:(int)newType parent:(ScanHierach *)obj container:(WaveContainer*)container identkey:(NSString*)idkey {
    self = [super init];
    if (!self) return nil;
    
    children = Nil;
    aNameString = [name copy];
    aIdentKey = [idkey copy];
    parent = obj;
    _container = [container retain];
    aType = newType;
    
    return self;
}

+ (ScanHierach *) rootItem:(WaveContainer*)container index:(int)idx {
    switch (idx) {
        case 0:
            if (!rootItem) rootItem = [[ScanHierach alloc] initWithName:@"Channel" type:1 parent:nil container:container identkey:@""];
            return rootItem;
        case 1:
            if (!rootItem2) rootItem2 = [[ScanHierach alloc] initWithName:@"SSID" type:2 parent:nil container:container identkey:@""];
            return rootItem2;
        case 2:
            if (!rootItem3) rootItem3 = [[ScanHierach alloc] initWithName:@"Encryption" type:36 parent:nil container:container identkey:@""];
            return rootItem3;
        default:
            return Nil;
    }
}

#pragma mark -

- (void) setContainer:(WaveContainer*)container{
    unsigned int i;
    
    [WaveHelper secureReplace:&_container withObject:container];
    
    for (i=0;i<[children count];i++) 
        [[children objectAtIndex:i] setContainer:container];
}

+ (void) setContainer:(WaveContainer*)container{
    [rootItem setContainer:container];
    [rootItem2 setContainer:container];
    [rootItem3 setContainer:container];
}

#pragma mark -


- (void)updateKey {
    int *v, h, i;
    unsigned int b, d, u;
    bool found, addedItem;
    int c[14];
    NSString *tmp;
    NSMutableArray *a;
    WaveNet *n;
    
    addedItem = NO;
    
    if (aType==1) { //channel root item
        for(b=0;b<14;b++) c[b]=0;
        
        for (u=0; u<[_container count]; u++) {
            v=[[_container netAtIndex:u] packetsPerChannel];
            if (v) for(b=0;b<=14;b++) c[b]+=v[b];
        }
        
        for (h=1;h<14;h++) 
            if (c[h]) { 
                //we need this item, check whether it exists
                found = NO;
                for (d=0;d<[children count];d++)
                    if (([(ScanHierach*)[children objectAtIndex:d] type]-20)==h) {
                        found = YES;
                        break;
                    }
                if (!found) { 
                    // add a new item
                    tmp=[NSString stringWithFormat:@"%.2i",h];
                    [children addObject:[[ScanHierach alloc] initWithName:tmp type:20+h parent:self container:_container identkey:@""]];
                    addedItem = YES;
                }
            }
    } else if (aType==2) { // SSID root item
        for (u=0; u<[_container count]; u++) {
            tmp=[[_container netAtIndex:u] SSID];
            
            //check whether item exists
            found = NO;
            for (d=0;d<[children count];d++) 
                if ([[[children objectAtIndex:d] nameString] isEqualToString:tmp]) {
                    found = YES;
                    break;
                }
                
            if (!found) {
                // add item
                [children addObject:[[ScanHierach alloc] initWithName:tmp type:3 parent:self container:_container identkey:@""]];
                addedItem = YES;
             }
        }
        
        // delete all entries which have no BSSIDs below them 
        for (i=[children count]-1;i>=0;i--) 
            if ([[children objectAtIndex:i] numberOfChildren]==0) [children removeObjectAtIndex:i];
    
    } else if (aType==3) { // these are the different network SSIDS
        a = [[NSMutableArray alloc] init];
        for (u=0; u<[_container count]; u++) {
            n = [_container netAtIndex:u];
            
            if (![[n SSID] isEqualToString:aNameString]) continue;
            tmp=[n BSSID];
            [a addObject:[n ID]];
            
            found = NO;
            
            for (d=0;d<[children count];d++) 
                if ([[[children objectAtIndex:d] nameString] isEqualToString:tmp]) {
                    found = YES;
                    break;
                }
                
            if (!found) {
                [children addObject:[[ScanHierach alloc] initWithName:tmp type:99 parent:self container:_container identkey:[n ID]]];
                addedItem = YES;
             }
        }
        
        //remove all items which are not in our list
        for (i=[children count]-1;i>=0;i--) 
            if ([a indexOfObject:[[children objectAtIndex:i] identKey]] == NSNotFound) 
                    [children removeObjectAtIndex:i];
        [a release];
    } else if ((aType>20)&&(aType<35)) { //these are the channel items
       for (u=0; u<[_container count]; u++) {
            n = [_container netAtIndex:u];
            if (!n) continue;
            
            v = [n packetsPerChannel];
            if (v[aType-20]==0) continue;
            
            tmp = [n BSSID];
            found = NO;
            for (d=0;d<[children count];d++) 
                if ([[[children objectAtIndex:d] nameString] isEqualToString:tmp]) {
                    found = YES;
                    break;
                }
                
            if (!found) {
                [children addObject:[[ScanHierach alloc] initWithName:tmp type:99 parent:self container:_container identkey:[n ID]]];
                addedItem = YES;
             }
        }
    } else if (aType == 36) {
        if ([children count]==0) {
            [children addObject:[[ScanHierach alloc] initWithName:@"None" type:37 parent:self container:_container identkey:@"None"]];
            [children addObject:[[ScanHierach alloc] initWithName:@"WEP" type:38 parent:self container:_container identkey:@"WEP"]];
            [children addObject:[[ScanHierach alloc] initWithName:@"WPA" type:40 parent:self container:_container identkey:@"WPA"]];
        }
    }
    
    if (children!=IsALeafNode) for(d=0;d<[children count];d++) [[children objectAtIndex:d] updateKey];
    if (addedItem) [children sortUsingSelector:@selector(compare:)];
    
}

+ (void)updateTree {
    if (rootItem  != nil) [rootItem updateKey];
    if (rootItem2 != nil) [rootItem2 updateKey];
    if (rootItem3 != nil) [rootItem3 updateKey];
}

- (NSArray *)children {
    if (children == NULL) {
        if (aType==1) {
            children = [[NSMutableArray alloc] initWithCapacity:13];
            [self updateKey];
        } else if (aType==2) {
            children = [[NSMutableArray alloc] init];
            [self updateKey];
        } else if (aType==3) {
            children = [[NSMutableArray alloc] init];
            [self updateKey];
        } else if ((aType>20)&&(aType<35)) {
            children = [[NSMutableArray alloc] init];
            [self updateKey];
        } else if (aType==36) {
            children = [[NSMutableArray alloc] initWithCapacity:3];
            [self updateKey];
        } else {
            children = IsALeafNode;
        }
    }
    return children;
}

- (NSString *)nameString {
    return aNameString;
}
- (NSString *)identKey {
    return aIdentKey;
}
- (int)type {
    return aType;
}
- (ScanHierach *)childAtIndex:(int)n {
    return [[self children] objectAtIndex:n];
}
- (int)numberOfChildren {
    id tmp = [self children];
    if (tmp == IsALeafNode) 
        return -1;
    else
        return [tmp count];
}
- (NSComparisonResult)compare:(ScanHierach *)aHier {
    return [aNameString compare:[aHier nameString]];
}
- (NSComparisonResult)caseInsensitiveCompare:(ScanHierach *)aHier {
    return [aNameString caseInsensitiveCompare:[aHier nameString]];
}

#pragma mark -

- (void)deleteKey {
    int d;
    if (children!=IsALeafNode)
        for (d=[children count]-1;d>=0;d--) {
            [[children objectAtIndex:d] deleteKey];
            [children removeObjectAtIndex:d];
        }
}
+ (void) clearAllItems {
    if (rootItem!=Nil) {
        [rootItem deleteKey];
        [WaveHelper secureRelease:&rootItem];
    }
    if (rootItem2!=Nil) { 
        [rootItem2 deleteKey];
        [WaveHelper secureRelease:&rootItem2];
    }
    if (rootItem3!=Nil) { 
        [rootItem3 deleteKey];
        [WaveHelper secureRelease:&rootItem3];
    }
}

- (void)dealloc {
    if (children != IsALeafNode) [children release];
    [_container release];
    [aNameString release];
    [aIdentKey release];
    [super dealloc];
}

@end
