/*
        
        File:			SoundController.m
        Program:		KisMAC
	Author:			Michael Rossberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import "SoundController.h"


@implementation SoundController

- (id)init {
    int i, count;
    self = [super init];
    
    if (!self) return Nil;
    
    mACM = AudioCycleManagerNew();
        
    mACM->_AppInstance = self;
    AudioCycleManagerInitialize (mACM);
    mACM->_feederThreadLoadingStyle = TIME_LOADING;
    count = AudioCycleManagerGetNumberOfDevices (mACM);
    
    if (count==0) {
        NSLog(@"Could not find any audio devices!\n");
        return nil;
    }
    
    for (i=0;i<count;i++) {
        AudioCycleManagerSetDeviceToDeviceAtIndex (mACM, i);
        if (!AudioCycleManagerGetDeviceAtIndexHasOutput (mACM, i)) NSLog(@"No Output Streams Available. Selecting other device.\n");
	else break;
    }
	
    AudioCycleManagerSetBufferFrameSize (mACM, 64);
    mACM->_BufferSizeInFrames  = AudioCycleManagerGetBufferFrameSize (mACM);
	
    if (mACM->_AudioBuffer) AudioDataZeroPlaybackHead (mACM->_AudioBuffer);
    
    mACM->_BufferSizeInNanos = (UInt64) ((mACM->_BufferSizeInFrames / mACM->_AudioDeviceASBD->mSampleRate) * 1000000000.0);

    return self;
}


#pragma mark -

- (void)playSound:(float)freq {
    //if (freq<100) freq=100;
    
    mACM->_ThreadLatencyThreshold = 200;
    mACM->_WorkLoopTraceThreshold = 0.75;
    
    AudioCycleManagerStart (mACM, 3, 500, 1/freq);
}

- (void)stopSound {
	AudioCycleManagerStop (mACM);
}

- (AudioCycleManager *) getACM
{
	return mACM;
}

#pragma mark -

- (void)dealloc {
	AudioCycleManagerDestroy (mACM);
}


@end
