/*
        
        File:			TrafficView.h
        Program:		KisMAC
	Author:			Michael Thole, Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#import <AppKit/AppKit.h>
#import "WaveScanner.h"
#import "WavePacket.h"
#import "WaveNet.h"

@class WaveNet;
@class WaveContainer;

@interface TrafficView : NSView {
    IBOutlet WaveScanner    *scanner;
    IBOutlet WaveContainer  *_container;

    NSBezierPath *gridPath;
    NSLock* zoomLock;

    NSColor *backgroundColor;
    NSColor *gridColor;
    NSColor *graphColor;
    NSColor *textColor;

    NSRect graphRect;
    NSTimeInterval scanInterval;
    float vScale;	// used for the vertical scaling of the graph
    float dvScale;	// used for the sweet 'zoom' in/out
    float stepx;	// step for horizontal lines on grid
    float stepy;	// step for vertical lines on grid
    float aMaximum;	// maximum bytes received
    int buffer[MAX_YIELD_SIZE];
    BOOL gridNeedsRedrawn;

    BOOL justSwitchedDataType;
    int _legendMode;
    int length;
    int offset;
    int maxLength;
    int currentMode;
    NSMutableArray* allNets;
    NSArray* colorArray;
    
    IBOutlet NSPopUpButton *_intervalButton;
    IBOutlet NSPopUpButton *_modeButton;
}

- (void)updateSettings:(NSNotification*)note;

- (IBAction)setTimeLength:(id)sender;
- (IBAction)setCurrentMode:(id)sender;

- (void)setBackgroundColor:(NSColor *)newColor;
- (void)setGridColor:(NSColor *)newColor;
- (void)setTextColor:(NSColor *)newColor;
- (void)setGraphColor:(NSColor *)newColor;
- (void)setGridPath:(NSBezierPath *)newPath;

- (void)updateDataForRect:(NSRect)rect;
- (void)drawGraphInRect:(NSRect)rect;
- (void)drawGridInRect:(NSRect)rect;
- (void)drawGridLabelForRect:(NSRect)rect;
- (void)drawLegendForRect:(NSRect)rect;

- (NSString*)stringForNetwork:(WaveNet*)net;
- (NSString*)stringForBytes:(int)bytes;
- (NSString*)stringForPackets:(int)bytes;
- (NSString*)stringForSignal:(int)bytes;

@end
