/*
        
        File:			WaveClient.m
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import "WaveClient.h"
#import "WaveHelper.h"

@implementation WaveClient

- (id)initWithCoder:(NSCoder *)coder
{
    self = [self init];
    if ( [coder allowsKeyedCoding] ) {
        aCurSignal=[coder decodeIntForKey:@"aCurSignal"];

        aRecievedBytes=[coder decodeDoubleForKey:@"aRecievedBytes"];
        aSentBytes=[coder decodeDoubleForKey:@"aSentBytes"];
        
        aID=[[coder decodeObjectForKey:@"aID"] retain];
        aDate=[[coder decodeObjectForKey:@"aDate"] retain];
        _changed = YES;
     } else {
        NSLog(@"Cannot decode this way");
    }
    return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
    if ([coder allowsKeyedCoding]) {
        [coder encodeInt:aCurSignal forKey:@"aCurSignal"];
        
        [coder encodeDouble:aRecievedBytes forKey:@"aRecievedBytes"];
        [coder encodeDouble:aSentBytes forKey:@"aSentBytes"];

        [coder encodeObject:aID forKey:@"aID"];
        [coder encodeObject:aDate forKey:@"aDate"];
    } else {
        NSLog(@"Cannot encode this way");
    }
    return;
}

#pragma mark -

-(void) parseFrameAsIncoming:(WavePacket*)w {
    if (aID==Nil) {
        aID=[[w clientToID] retain];
    }
    aRecievedBytes+=[w length];
    _changed = YES;
}

-(void) parseFrameAsOutgoing:(WavePacket*)w {
    if (aID==Nil) {
        aID=[[w clientFromID] retain];
    }
    if (aDate==Nil) [aDate release];
    aDate=[[NSDate date] retain];
    aCurSignal=[w signal];
    aSentBytes+=[w length];    
    _changed = YES;
}

#pragma mark -

- (NSString *)ID {
    if (aID==Nil) return NSLocalizedString(@"<unknown>", "unknown client ID");
    return aID;
}

- (NSString *)recieved {
    return [WaveHelper bytesToString: aRecievedBytes];
}

- (NSString *)sent {
    return [WaveHelper bytesToString: aSentBytes];
}

- (NSString *)vendor {
    if (aVendor) return aVendor;
    aVendor=[[WaveHelper vendorForMAC:aID] retain];
    return aVendor;
}

- (NSString *)date {
    if (aDate==Nil) return @"";
    else return [NSString stringWithFormat:@"%@", aDate]; //return [aDate descriptionWithCalendarFormat:@"%H:%M %d-%m-%y" timeZone:nil locale:nil];
}

#pragma mark -

- (float)recievedBytes {
    return aRecievedBytes;
}

- (float)sentBytes {
    return aSentBytes;
}

- (int)curSignal {
    if ([aDate compare:[NSDate dateWithTimeIntervalSinceNow:0.5]]==NSOrderedDescending) aCurSignal=0;
    return aCurSignal;
}

- (NSDate *)rawDate {
    return aDate;
}

#pragma mark -

- (BOOL)changed {
    BOOL c = _changed;
    _changed = NO;
    return c;
}

- (void)wasChanged {
    _changed = YES;
}

#pragma mark -

-(void) dealloc {
    if (aDate!=Nil) [aDate release];
    if (aID!=Nil) [aID release];
    if (aVendor!=Nil) [aVendor release];
}
@end
