/*
        
        File:			WaveHelper.h
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import <Cocoa/Cocoa.h>
#import "GPSController.h"
#import "ZoomPictureView.h"
#import "ImportController.h"
#import "Apple80211.h"
#import "WaveDrivers/WaveDriver.h"

#ifdef __cplusplus
extern "C" {
#endif
void WirelessCryptMD5(char const *str, unsigned char *key);
#ifdef __cplusplus
}
#endif

#ifndef OK
#define OK NSLocalizedString(@"OK", @"OK Button")
#endif

#ifndef CANCEL
#define CANCEL NSLocalizedString(@"Cancel", "Cancel Button")
#endif

#ifndef ERROR_TITLE
#define ERROR_TITLE NSLocalizedString(@"Error", "Some user error dialog title")
#endif

@interface WaveHelper : NSObject {

}

+ (bool)runScript:(NSString*)script;
+ (bool)runScript:(NSString*)script withArguments:(NSArray*)args;

+ (NSString*) bytesToString:(float) bytes;
+ (NSString*) urlEncodeString:(NSString*)string;
+ (NSString*) vendorForMAC:(NSString*)MAC;
+ (void)speakSentence:(const char*)cSentence withVoice:(int)voice;
+ (bool)isServiceAvailable:(char*)service;

+ (bool)unloadAllDrivers;
+ (bool)loadDrivers;
+ (NSArray*) getWaveDrivers;
+ (WaveDriver*) injectionDriver;
+ (WaveDriver*) driverWithName:(NSString*) s;

+ (NSWindow*) mainWindow;
+ (void) setMainWindow:(NSWindow*)mw;

+ (GPSController*) gpsController;
+ (void) initGPSControllerWithDevice:(NSString*)device;

+ (ZoomPictureView*) zoomPictureView;
+ (void) setZoomPictureView:(ZoomPictureView*)z;

+ (NSColor*)intToColor:(NSNumber*)c;
+ (NSNumber*)colorToInt:(NSColor*)c;

+ (ImportController*) importController;
+ (void) setImportController:(ImportController*)im;
+ (NSMutableArray*) getProbeArrayForID:(char*)ident;

+ (void)secureRelease:(id*)object;
+ (void)secureReplace:(id*)oldObject withObject:(id)newObject;
+ (void)addDictionary:(NSDictionary*)s toDictionary:(NSMutableDictionary*)d;

+ (int)showCouldNotInstaniciateDialog:(NSString*)driverName;
@end
