/*
        
        File:			WaveNet.h
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import <Cocoa/Cocoa.h>
#import "WavePacket.h"
#import "ImportController.h"
#import "NetView.h"
#import "Apple80211.h"

enum {
    trafficData,
    packetData,
    signalData
};

struct graphStruct {
    int trafficData[MAX_YIELD_SIZE + 1];
    int packetData[MAX_YIELD_SIZE + 1];
    int signalData[MAX_YIELD_SIZE + 1];
};

@interface WaveNet : NSObject {
    int aNetID;			//network ID
    int aMaxSignal;		//biggest signal ever
    int aCurSignal;		//current signal
    int aChannel;		//last channel
    int aType;			//0=unknown, 1=ad-hoc, 2=managed, 3=tunnel
    int _packets;		//# of packets
    int _packetsPerChannel[16];	//how many packets on each channel
    int _weakPackets;		//# of weak packets
    int _dataPackets;		//# of data packets
    double aBytes;		//bytes, float because of size
    int graphLength;
    struct graphStruct graphData;
    int _isWep;			//0=unknown, 1=disabled, 2=enabled 3=40-bit 4-WPA
    UInt8 aIV[3]; 		//last iv
    UInt8 aRawID[6];		//our id
    UInt8 aRawBSSID[6];		//our bssid
    UInt8 aPoint1[6];		//tunnel partner 1
    UInt8 aPoint2[6];		//tunnel partner 2
    bool _gotData;
    bool _firstPacket;
    
    NSRecursiveLock *_dataLock;
    
    NetView*  aNetView;
    NSString* aLat;
    NSString* aLong;
    NSString* aElev;
    
    NSString* aSSID;
    NSString* aBSSID;
    NSString* aVendor;
    NSString* aPassword;
    NSString* aComment;
    NSString* aID;
    NSDate* aDate;		//current date
    NSDate* aFirstDate;
    NSMutableDictionary* aWeak;	//dictionary of all weak packets
    NSMutableArray* aPacketsLog;//array with a couple of packets to calculate checksum
    NSMutableArray* aARPLog;	//array with a couple of packets to do reinjection attack
    NSMutableArray* aACKLog;	//array with a couple of packets to do reinjection attack
    NSMutableDictionary* aClients;
    NSMutableArray* aClientKeys;
    NSMutableDictionary* _coordinates;
    
    id aCracker;		//cracker for this net
 
    NSColor* _graphColor;	// display color in TrafficView
    int recentTraffic;
    int recentPackets;
    int recentSignal;
    int curPackets;		// for setting graphData
    int curTraffic;		// for setting graphData
    int curTrafficData;		// for setting graphData
    int curPacketData;		// for setting graphData
    int curSignalData;		// for setting graphData
    int _avgTime;               // how many seconds are take for average?
}


- (void)updateSettings:(NSNotification*)note;

- (bool)noteFinishedSweep:(int)num;
- (NSColor*)graphColor;
- (void)setGraphColor:(NSColor*)newColor;
- (NSComparisonResult)compareSignalTo:(id)net;
- (NSComparisonResult)comparePacketsTo:(id)net;
- (NSComparisonResult)compareTrafficTo:(id)net;
- (NSComparisonResult)compareRecentTrafficTo:(id)aNet;

- (id)initWithID:(int)netID;
- (id)initWithNetstumbler:(const char*)buf andDate:(NSString*)date;
- (void) mergeWithNet:(WaveNet*)net;

- (struct graphStruct)graphData;
- (NSDictionary*)getClients;
- (NSArray*)getClientKeys;
- (void)updatePassword;

- (int)isWep;
- (NSString *)ID;
- (NSString *)BSSID;
- (NSString *)SSID;
- (NSString *)date;
- (NSDate*)lastSeenDate;
- (NSString *)firstDate;
- (NSDate *)firstSeenDate;
- (NSString*)data;
- (NSString*)getVendor;
- (NSDictionary*)weakPacketsDict;	//all weak packets that we have
- (NSArray*)weakPacketsLog;             //a couple of encrypted packets
- (NSMutableArray*)arpPacketsLog;	//a couple of reinject packets
- (NSMutableArray*)ackPacketsLog;	//a couple of reinject packets
- (NSString*)key;
- (NSString*)lastIV;
- (NSString*)comment;
- (void)setComment:(NSString*)comment;
- (NSDictionary*)coordinates;

- (NSString *)latitude;
- (NSString *)longitude;
- (NSString *)elevation;

- (float)dataCount;
- (int)curTraffic;
- (int)curPackets;
- (int)curSignal;
- (int)maxSignal;
- (int)avgSignal;
- (int)channel;
- (int)type;
- (int)packets;
- (int)weakPackets;			//number of weak Packets
- (int)dataPackets;
- (int*)packetsPerChannel;
- (int)netID;
- (UInt8*)rawBSSID;
- (UInt8*)rawID;

- (void)parsePacket:(WavePacket*) w withSound:(bool)sound;
- (void)parseAppleAPIData:(WirelessNetworkInfo*)info;
- (void)crackWithKeyByteLength:(unsigned int)a breath:(unsigned int)b import:(ImportController*)i;
- (int) crack40WithBruteForce:(ImportController*)i charset:(int) chars;
- (void)crackWithWordlistUseCipher:(unsigned int)a import:(ImportController*)i;

- (void) sortByColumn:(NSString*)ident order:(bool)ascend;

@end
