/*
        
        File:			WavePacket.h
        Program:		KisMAC
	Author:			Michael Roberg
				mick@binaervarianz.de
	Description:		KisMAC is a wireless stumbler for MacOS X.
                
        This file is part of KisMAC.

    KisMAC is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KisMAC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with KisMAC; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#import <Foundation/Foundation.h>
#import "80211b.h"
#import <sys/time.h>

//#define DEBUG			//This has currently no meaning
//#define LOGPACKETS		//do not enable unless you know what you are doing

// 1201 = 5 minutes (plus one) for 0.25s interval
#define MAX_YIELD_SIZE (int)1200

//this is given to us by the driver
struct sAirportFrame { // 14 Byte
    UInt16 status;
    UInt16 reserved0;
    UInt16 reserved1;
    UInt8  signal;
    UInt8  silence;
    UInt16 rate;
    UInt16 reserved2;
    UInt16 txControl;
};

//the beginning of each beacon frame. currently not in use
struct sBeaconFrame { //at least 12 bytes
    UInt8  timestamp[8];
    UInt16 beaconInterval;
    UInt16 capabilities;
};

//this represents a packet
@interface WavePacket : NSObject {
    int aSignal;		//current signal strength
    int aChannel;		//well the channel
    int aType;			//type 0=management 1=control 2=data
    int aSubtype;		//deprending on type
    int aNetType;		//0=unknown, 1=ad-hoc, 2=managed, 3=tunnel
    int _isWep;			//0=unknown, 1=disabled, 2=enabled
    int _originalChannel;       
    bool aIsToDS;		//to access point?
    bool aIsFrDS;		//from access point?
    NSString *_SSID;
    struct timeval aCreationTime; //time for cap
    
    char* aRawFrame;		//pointer to the raw frame

    int _revelsKeyByte;         //-2 = no idea
    int aStatus;		//?
    int aSilence;		//TODO implement noise ratio
    
    int aLength;		//length of body
    int aHeaderLength;		//length of real header

    int aMACAddress[30];	//the mac addresses
}

//input function
- (bool)parseFrame:(WLFrame*) f;

- (void)dump:(void*)f;	//dumps packet to pcaphandle f
- (int)status;
- (int)silence;
- (int)length;
- (int)bodyLength;
- (int)signal;
- (int)channel;
- (int)type;
- (int)subType;
- (bool)fromDS;
- (bool)toDS;
- (int)wep;
- (int)netType;
- (UInt8*) framebody;
- (UInt8*) frame;
- (int)isResolved;	//for wep cracking 
- (NSString*)ssid;
- (NSString*)clientFromID;
- (NSString*)clientToID;
- (NSString*)BSSIDString;
- (bool)BSSID:(UInt8*)bssid;
- (bool)ID:(UInt8*)ident;
- (NSString*)IDString;	//gives a unique for each net, bssid is not useful

// Patched by Dylan Neild
- (NSString *)sourceIPAsString;
- (NSString *)destinationIPAsString;
- (unsigned char *)sourceIPAsData;
- (unsigned char *)destinationIPAsData;

@end
