#!/usr/bin/python


#  mrpkey.py - calculate 3DES key for Machine Readable Passport
# 
#  Adam Laurie <adam@algroup.co.uk>
#  http://rfidiot.org/
# 
#  This code is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
# 
#  This code is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 


import RFIDIOt
import RFIDIOtconfig
import sys
import os
from Crypto.Hash import SHA
from Crypto.Cipher import DES3
from Crypto.Cipher import DES
import random
from operator import *

# TEST data
TEST_MRZ= 'L898902C<3UTO6908061F9406236ZE184226B<<<<<14'
TEST_rnd_ifd= '781723860C06C226'
TEST_rnd_icc= '4608F91988702212'
TEST_Kifd= '0B795240CB7049B01C19B33E32804F0B'
TEST_respdata= '46B9342A41396CD7386BF5803104D7CEDC122B9132139BAF2EEDC94EE178534F2F2D235D074D7449'
APDU_OK= '9000'
APDU_BAC= '6982'

# constants
DES_IV='\0\0\0\0\0\0\0\0'
DES_PAD= [chr(0x80),chr(0),chr(0),chr(0),chr(0),chr(0),chr(0),chr(0)]

def getrandom(size):
	data= ''
	for x in range(size):
		data += '%02x' % int(random.uniform(0,0xff))
	return data

def des_mac(message,key,ssc):
	tdesa= DES.new(key[0:8],DES.MODE_ECB,DES_IV)
	tdesb= DES.new(key[8:16],DES.MODE_ECB,DES_IV)

	if(ssc):
		mac= tdesa.encrypt(passport.ToBinary(ssc))
	else:
		mac= DES_IV

	for x in range(len(DES_PAD)):
		message += DES_PAD[x]
	for y in range(len(message) / 8):
		current= message[y * 8:(y * 8) + 8]
		left= ''
		right= ''
		for x in range(len(mac)):
			left += '%02x' % ord(mac[x])
			right += '%02x' % ord(current[x])
		machex= '%16x' % xor(int(left,16),int(right,16))
		mac= passport.ToBinary(machex)
		mac= tdesa.encrypt(mac)
	mac= tdesb.decrypt(mac)
	mac= tdesa.encrypt(mac)
	return mac 
	

def get_challenge(length):
	out= passport.send_apdu('','','','','','GET_CHALLENGE','','','','','%02x' % length)
	if not passport.errorcode == '9000':
		passport.iso_7816_fail(passport.errorcode)
	return out

def mutual_authenticate(data):
	hexdata= ''
	for x in range(len(data)):
		hexdata += '%02x' % ord(data[x])
	out= passport.send_apdu('','','','','','EXTERNAL_AUTHENTICATE','','','28',hexdata,'28')
	if passport.errorcode == APDU_OK:
		print 'OK'
		return out
	else:
		passport.iso_7816_fail(passport.errorcode)

def select_file_mf():
	passport.send_apdu('','','','','','SELECT_FILE','02','0C','02','011E','')
	if passport.errorcode == APDU_BAC:
		print 'Basic Access Control enforced!'
	else:
		passport.iso_7816_fail(passport.errorcode)

def select_passport_app():
	passport.send_apdu('','','','','','SELECT_FILE','04','0C','07','A0000002471001','')
	if passport.errorcode == APDU_OK:
		print 'OK'
	else:
		passport.iso_7816_fail(passport.errorcode)

passport = RFIDIOtconfig.card
passport.info('mrpkey v0.1')

if sys.argv[1] == 'TEST':
	TEST= True
else:
	TEST= False

if not len(sys.argv) == 2 or (not len(sys.argv[1]) == 44 and not TEST):
	print 'usage:'
	print sys.argv[0] + ' <MRZ (Lower)|TEST>'
	os._exit(False)

print

if TEST:
	passport.MRPmrzl(TEST_MRZ)
	print 'Test MRZ: ' + TEST_MRZ
else:
	passport.MRPmrzl(sys.argv[1])
print 'Passport number: ' + passport.MRPnumber
print 'Check digit: ' + passport.MRPnumbercd
print 'Nationality: ' + passport.MRPnationality
print 'Date Of Birth: ' + passport.MRPdob
print 'Check Digit: ' + passport.MRPdobcd
print 'Sex: ' + passport.MRPsex
print 'Expiry: ' + passport.MRPexpiry
print 'Check Digit: ' + passport.MRPexpirycd
print 'Optional: ' + passport.MRPoptional
print 'Check Digit: ' + passport.MRPoptionalcd
print 'Composite Check Digit: ' + passport.MRPcompsoitecd
kmrz= passport.MRPnumber + passport.MRPnumbercd + passport.MRPdob + passport.MRPdobcd + passport.MRPexpiry + passport.MRPexpirycd
print
print 'Generate local keys:'
print
print 'Key MRZ Info (kmrz): ' + kmrz
kseedhash= SHA.new(kmrz)
kseed= kseedhash.digest()[:16]
print 'Kseed (SHA1 hash digest of kmrz): ' + kseedhash.hexdigest()[:32]
print
# calculate KENCa and KENCb
kenc= '\0\0\0\1'
d= kseed + kenc
kencsha= SHA.new(d)
ka= kencsha.digest()[0:8]
print 'KENCa (encryption key A digest): ',
kap= passport.DESParity(ka)
passport.HexPrint(kap)
kb= kencsha.digest()[8:16]
print 'KENCb (encryption key B digest): ',
kbp= passport.DESParity(kb)
passport.HexPrint(kbp)
Kenc= kap + kbp
print


kmac= '\0\0\0\2'
d= kseed + kmac
kmacsha= SHA.new(d)
ka= kmacsha.digest()[0:8]
print 'KMACa (Message Authentication Code A digest): ',
kap= passport.DESParity(ka)
passport.HexPrint(kap)
kb= kmacsha.digest()[8:16]
print 'KMACb (Message Authentication Code B digest): ',
kbp= passport.DESParity(kb)
passport.HexPrint(kbp)
Kmac= kap + kbp
print

if TEST:
	rnd_ifd= TEST_rnd_ifd
	rnd_icc= TEST_rnd_icc
	Kifd= TEST_Kifd
else:
	hss= passport.hsselect('08')
	print 'High Speed Select: ',
	print hss
	print 'Select Passport Application (AID): ',
	select_passport_app()
	print 'Select Master File: ',
	select_file_mf()
	print 'Get Challenge from Passport (rnd_icc): ',
	rnd_icc= get_challenge(8)
	passport.HexPrint(rnd_icc)
	rnd_ifd= getrandom(8)
	Kifd= getrandom(16)

print 'Generate local random Challenge (rnd_ifd): ' + rnd_ifd
print 'Generate local random Challenge (Kifd): ' + Kifd
print

S= passport.ToBinary(rnd_ifd + rnd_icc + Kifd)
print 'S: ',
passport.HexPrint(S)

print 'Kenc: ',
passport.HexPrint(Kenc)


tdes= DES3.new(Kenc,DES.MODE_CBC,DES_IV)
Eifd= tdes.encrypt(S)
print 'Eifd: ',
passport.HexPrint(Eifd)

print 'Kmac: ',
passport.HexPrint(Kmac)
Mifd= des_mac(Eifd,Kmac,'')
print 'Mifd: ',
passport.HexPrint(Mifd)

cmd_data= Eifd + Mifd
print 'cmd_data: ',
passport.HexPrint(cmd_data)
print

if TEST:
	respdata= TEST_respdata
else:
	print 'Authenticating: ',
	respdata= mutual_authenticate(cmd_data)

print 'Auth Response: ' + respdata
resp= respdata[:64]
respmac= respdata[64:80]
print 'Auth message: ' + resp
print 'Auth MAC: ' + respmac
ssc= rnd_icc[:8] + rnd_ifd[:8]
print
print 'SSC: ' + ssc
