#!/usr/bin/python

#  readlfx.py - read all sectors from a LFX reader
# 
#  Adam Laurie <adam@algroup.co.uk>
#  http://rfidiot.org/
# 
#  This code is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
# 
#  This code is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 


import RFIDIOt
import RFIDIOtconfig
import sys
import os

def printEM4x05ID():
        print 'Application Identifier: ', card.EM4x05APP
        print 'Country Code: ',
        print card.EM4x05CCODE
        print 'National ID: ',
        print card.EM4x05NID


card= RFIDIOtconfig.card
card.info('readlfx v0.1b')

if len(sys.argv) > 1:
        card.EM4x05ID(sys.argv[1])
	printEM4x05ID()
        os._exit(True)

ID= card.select()
print 'Card ID: ' + ID[1:]
print 'Tag type: ' + card.LFXTags[ID[:1]]

if ID[:1] == card.EM4x05:
	card.EM4x05ID(ID[1:])
	printEM4x05ID()

sector = 1
while sector:
        print ' sector %02x: ' % sector,
	if card.readblock(sector):
		print card.data
	else:
		print 'Read error: ' + card.errorcode
		os._exit(False)
        sector += 1
print
