#!/usr/bin/python

#  hitag2reset.py - hitag2 tags need love too...
# 
#  Adam Laurie <adam@algroup.co.uk>
#  http://rfidiot.org/
# 
#  This code is copyright (c) Adam Laurie, 2006, All rights reserved.
#  For non-commercial use only, the following terms apply - for all other
#  uses, please contact the author:
#
#    This code is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This code is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#


import RFIDIOt
import RFIDIOtconfig
import sys
import os
import string

card= RFIDIOtconfig.card
card.info('hitag2reset v0.1')

# standard config block
CFB='06' + card.HITAG2_TRANSPORT_TAG
BLK1= card.HITAG2_TRANSPORT_RWD

if len(sys.argv) == 1 or len(sys.argv) > 3:
	print sys.argv[0] + ' - return a Hitag2 tag to life'
	print 'Usage: ' + sys.argv[0] + ' <CONTROL> [PASSWD]'
	print
	print 'If the optional PASSWD field is specified, the password will be set.'
	os._exit(True)

if sys.argv[1] == 'CONTROL':
       	while True:
               	print
#		if card.frosch(card.FR_HT2_Read_PublicB):
#              		print '  Card ID: ' + card.data
               	x= string.upper(raw_input('  *** Warning! This will overwrite TAG! Place card and proceed (y/n)? '))
               	if x == 'N':
               		os._exit(False)
       		if x == 'Y':
			break
	print 'Writing...'
	logins= 0
	if (card.h2publicselect()):
		print 'Hitag2 ID: ' + card.data
	else:
		print 'No TAG, or incompatible hardware!'
		os._exit(False)
	if not card.writeblock(3,CFB):
		print card.FROSCH_Errors[card.errorcode]
		print 'Write failed!'
		os._exit(False)
	else:
		if len(sys.argv) > 2 and sys.argv[2] == 'ID':
			if not card.writeblock(1,B1) or not card.writeblock(2,B2):
				print 'Write failed!'
				print card.FROSCH_Errors[card.errorcode]
				os._exit(False)	 	
	card.settagtype(card.ALL)
	print 'Done!'
       	if card.select():
       		print '  Card ID: ' + card.data
