#!/usr/bin/python


#  mrpkey.py - calculate 3DES key for Machine Readable Passport
# 
#  Adam Laurie <adam@algroup.co.uk>
#  http://rfidiot.org/
# 
#  This code is copyright (c) Adam Laurie, 2006, All rights reserved.
#  For non-commercial use only, the following terms apply - for all other
#  uses, please contact the author:
#
#    This code is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This code is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#

DEBUG= False

import RFIDIOt
import RFIDIOtconfig
import sys
import os
from Crypto.Hash import SHA
from Crypto.Cipher import DES3
from Crypto.Cipher import DES
import random
from operator import *
import StringIO
import Image
import ImageTk
from Tkinter import *

# TEST data
TEST_MRZ= 'L898902C<3UTO6908061F9406236ZE184226B<<<<<14'
TEST_rnd_ifd= '781723860C06C226'
TEST_rnd_icc= '4608F91988702212'
TEST_Kifd= '0B795240CB7049B01C19B33E32804F0B'
TEST_respdata= '46B9342A41396CD7386BF5803104D7CEDC122B9132139BAF2EEDC94EE178534F2F2D235D074D7449'
MRZ_WEIGHT= [7,3,1]
APDU_OK= '9000'
APDU_BAC= '6982'
EF_COM= '011E'
EF_COM_TAG= '60'
EF_DG1= '0101'
EF_DG1_TAG= '61'
EF_DG2= '0102'
EF_DG2_TAG= '75'
EF_SOD= '011D'
EF_SOD_TAG= '77'
MRZ_FIELD_NAMES= ('Document code','Issuing State or organisation','Name','Passport Number','Check Digit','Nationality','Date of Birth','Check Digit','Sex','Date of Expiry','Check Digit','Personal Number or other optional elements','Check Digit','Composite Check Digit')
MRZ_FIELD_LENGTHS= (2,3,39,9,1,3,6,1,1,6,1,14,1,1)

# Global Send Sequence Counter
SSC= ''

# Global bruteforce vars
num= []
map= []
brnum= 0

def mrzspaces(data):
	out= ''
	for x in range(len(data)):
		if data[x] == '<':
			out += ' '
		else:
			out += data[x]
	return out

class guiviewpass:
	def __init__(self,root,filename,mrz):
		frame = Frame(root, colormap="new", visual='truecolor').grid()
		root.title('mrpkey.py (RFIDIOt v%s)' % passport.VERSION)
		self.imagedata = ImageTk.PhotoImage(file=filename)
		self.image = Label(frame, image=self.imagedata, borderwidth= 15).grid(row= 0, sticky= W, rowspan= 20)
		self.label = Label(frame, text='Type').grid(row= 1, sticky= W, column= 1)
		type= mrzspaces(mrz[0:2])
		self.label = Label(frame, text=type, font= 'OCRB 36').grid(row= 2, sticky= W, column= 1)
		self.label = Label(frame, text='Code').grid(row= 1, sticky= W, column= 2)
		self.label = Label(frame, text=mrz[2:5], font= 'OCRB 36').grid(row= 2, sticky= W, column= 2)
		self.label = Label(frame, text='Document No.').grid(row= 1, sticky= W, column= 3)
		self.label = Label(frame, text=mrz[44:53], font= 'OCRB 36', width= 12, justify= 'left', anchor= W).grid(row= 2, sticky= W, column= 3)
		self.label = Label(frame, text='Surname').grid(row= 3, sticky= W, column= 1)
		name= mrz[5:44]
		surname= ''
		for x in range(len(name)):
			if name[x] == '<':
				break
			else:
				surname += name[x]
		while name[x] == '<':
			x= x + 1
		forename= mrzspaces(name[x:])
		self.label = Label(frame, text=surname, font= 'OCRB 36').grid(row= 4, sticky= W, column= 1)
		self.label = Label(frame, text='Name').grid(row= 5, sticky= W, column= 1)
		self.label = Label(frame, text=forename, font= 'OCRB 36').grid(row= 6, sticky= W, column= 1, columnspan= 2)
		self.label = Label(frame, text='Date of Birth').grid(row= 7, sticky= W, column= 1)
		self.label = Label(frame, text=mrz[61:63] + '/' + mrz[59:61] + '/' + mrz[57:59], font= 'OCRB 36').grid(row= 8, sticky= W, column= 1)
		self.label = Label(frame, text='Sex').grid(row= 9, sticky= W, column= 1)
		self.label = Label(frame, text=mrz[64], font= 'OCRB 36').grid(row= 10, sticky= W, column= 1)
		self.label = Label(frame, text='Issuing State or Organisation  ').grid(row= 7, sticky= W, column= 3)
		self.label = Label(frame, text=passport.ISO3166CountryCodesAlpha[mrz[2:5]] + '  ', font= 'OCRB 36').grid(row= 8, sticky= W, column= 3)
		self.label = Label(frame, text='Date of Expiry').grid(row= 11, sticky= W, column= 1)
		self.label = Label(frame, text=mrz[69:71] + '/' + mrz[67:69] + '/' + mrz[65:67], font= 'OCRB 36').grid(row= 12, sticky= W, column= 1)
		self.label = Label(frame, text='Personal Number / Optional').grid(row= 13, sticky= W, column= 1)
		optional= mrzspaces(mrz[72:86])
		self.label = Label(frame, text=optional, font= 'OCRB 36').grid(row= 14, sticky= W, column= 1)
		self.label = Label(frame, text=mrz[:len(mrz) / 2], font= 'OCRA 36', justify= 'left', borderwidth= 15).grid(row= 20, sticky= W, columnspan= 4)
		self.label = Label(frame, text=mrz[len(mrz) / 2:], font= 'OCRA 36', justify= 'left', borderwidth= 15).grid(row= 21, sticky= W, columnspan= 4)
		self.label = Label(frame, text='http://rfidiot.org').grid(row= 23, sticky= W, column= 1)
		self.quitbutton = Button(frame, text="Quit", borderwidth= 5, command=root.quit).grid(row= 23, column=3, sticky= SE)

def getrandom(size):
	data= ''
	for x in range(size):
		data += '%02x' % int(random.uniform(0,0xff))
	return data

def get_challenge(length):
	"get random challenge"
	ins= 'GET_CHALLENGE'
	le= '%02x' % length
	out= passport.send_apdu('','','','','',ins,'','','','',le)
	if not passport.errorcode == '9000':
		passport.iso_7816_fail(passport.errorcode)
	return out

def mutual_authenticate(data,key):
	"mutual authenticate"
	global brnum
	ins= 'EXTERNAL_AUTHENTICATE'
	lc= '28'
	hexdata= ''
	le= '28'
	for x in range(len(data)):
		hexdata += '%02x' % ord(data[x])
	out= passport.send_apdu('','','','','',ins,'','',lc,hexdata,le)
	if passport.errorcode == APDU_OK:
		passport.MACVerify(out,key)
		print 'OK'
		return out
	else:
		if brnum == 0:
			passport.iso_7816_fail(passport.errorcode)
		else:
			return out

def select_file(file):
	"select file"
	ins= 'SELECT_FILE'
	p1= '02'
	p2= '0C'
	lc= '02'
	data= file
	passport.send_apdu('','','','','',ins,p1,p2,lc,data,'')
	if passport.errorcode == APDU_BAC:
		print 'Basic Access Control enforced!'
	else:
		print 'No access control(!)'
#		passport.iso_7816_fail(passport.errorcode)

def select_passport_app():
	"select passport specific application (AID: A0000002471001)"
	ins= 'SELECT_FILE'
	p1= '04'
	p2= '0C'
	lc= '07'
	data= 'A0000002471001'
	passport.send_apdu('','','','','',ins,p1,p2,lc,data,'')
	if passport.errorcode == APDU_OK:
		print 'OK'
	else:
		passport.iso_7816_fail(passport.errorcode)

def secure_select_file(keyenc, keymac,file):
	"secure select file"
	global SSC

	cla= '0c'
	ins= passport.ISOAPDU['SELECT_FILE']
	p1= '02'
	p2= '0c'
	command= passport.PADBlock(passport.ToBinary(cla + ins + p1 + p2))
	data= passport.PADBlock(passport.ToBinary(file))
	tdes= DES3.new(keyenc,DES.MODE_CBC,passport.DES_IV)
	encdata= tdes.encrypt(data)
	if DEBUG:
		print 'Encrypted data: ',
		passport.HexPrint(encdata)
	do87= passport.ToBinary(passport.DO87) + encdata
	m= command + do87
	if DEBUG:
		print 'DO87: ',
		passport.HexPrint(m)
	SSC= passport.SSCIncrement(SSC)
	n= SSC + m
	cc= passport.DESMAC(n,keymac,'')
	if DEBUG:
		print 'CC: ',
		passport.HexPrint(cc)
	do8e= passport.ToBinary(passport.DO8E) + cc
	if DEBUG:
		print 'DO8E: ',
		passport.HexPrint(do8e)
	lc= "%02x" % (len(do87) + len(do8e))
	le= '00'
	data= passport.ToHex(do87 + do8e)
	if DEBUG:
		print
		print 'Protected APDU: ',
		print cla+ins+p1+p2+lc+data+le
	ins= 'SELECT_FILE'
	out= passport.send_apdu('','','','',cla,ins,p1,p2,lc,data,le)
	if DEBUG:
		print 'Secure Select:',
	if passport.errorcode == APDU_OK:
		if DEBUG:
			print 'OK'
		check_cc(keymac,out)
		return out
	else:
		passport.iso_7816_fail(passport.errorcode)

def secure_read_binary(keymac,bytes,offset):
	"secure read binary data"
	global SSC


	cla= '0c'
	ins= passport.ISOAPDU['READ_BINARY']
	hexoffset= '%04x' % offset
	p1= hexoffset[0:2]
	p2= hexoffset[2:4]
	le= '%02x' % bytes
	command= passport.PADBlock(passport.ToBinary(cla + ins + p1 + p2))
	do97= passport.ToBinary(passport.DO97 + le)
	m= command + do97 
	SSC= passport.SSCIncrement(SSC)
	n= SSC + m
	cc= passport.DESMAC(n,keymac,'')
	do8e= passport.ToBinary(passport.DO8E) + cc
	lc= "%02x" % (len(do97) + len(do8e))
	le= '00'
	data= passport.ToHex(do97 + do8e)
	if DEBUG:
		print
		print 'Protected APDU: ',
		print cla+ins+p1+p2+lc+data+le
	ins= 'READ_BINARY'
	out= passport.send_apdu('','','','',cla,ins,p1,p2,lc,data,le)
	if DEBUG:
		print 'Secure Read Binary (%02d bytes): ' % bytes,
	if passport.errorcode == APDU_OK:
		if DEBUG:
			print 'OK'
		check_cc(keymac,out)
		return out
	else:
		passport.iso_7816_fail(passport.errorcode)

def read_binary(bytes,offset):
	ins= 'READ_BINARY'
	hexoffset= '%04x' % offset
	p1= hexoffset[0:2]
	p2= hexoffset[2:4]
	le= '%02x' % bytes
	out= passport.send_apdu('','','','','',ins,p1,p2,'','',le)
	
def calculate_check_digit(data):
	"calculate ICAO 9303 check digit"
	cd= 0	
	for n in range(len(data)):
		if data[n] >= 'A' and data[n] <= 'Z':
			value= ord(data[n]) - 55
		else:
			if data[n] == '<':
				value= 0
			else:
				value= int(data[n],10)
		cd += value * MRZ_WEIGHT[n % 3]
	return '%s' % (cd % 10)

def check_cc(key,rapdu):
	"Check Cryptographic Checksum"
	global SSC

	SSC= passport.SSCIncrement(SSC)
	k= SSC
	length= 0
	# check if DO87 present
	if rapdu[0:2] == "87":
		length= 4 + int(rapdu[2:4],16) * 2
		k += passport.ToBinary(rapdu[:length])
	# check if DO99 present
	if rapdu[length:length + 2] == "99":
		length2= 4 + int(rapdu[length + 2:length + 4],16) * 2
		k += passport.ToBinary(rapdu[length:length + length2])
	
	if DEBUG:
		print 'K: ',
		passport.HexPrint(k)
	cc= passport.DESMAC(k,key,'')
	if DEBUG:
		print 'CC: ',
		print passport.ToHex(cc),
	if cc ==  passport.ToBinary(rapdu[len(rapdu) - len(cc) *2:]):
		if DEBUG:
        		print '(verified)'
		return True
	else:
        	print 'Cryptographic Checksum failed!'
        	print 'Expected CC: ',
        	passport.HexPrint(cc)
        	print 'Received CC: ',
        	print rapdu[len(rapdu) - len(cc) * 2:]
		os._exit(False)

def decode_ef_com(data):
	TAG_LDS= '5f01'
	TAG_UNICODE= '5f36'
	TAG_LIST= '5c'
	TAG_PAD= '80'

	TAG_TYPE= {'60':'EF.COM Data Group Presence Map',\
		   '61':'EF.DG1 Data Recorded in MRZ',\
		   '75':'EF.DG2 Encoded Identification Features - FACE',\
		   '63':'EF.DG3 Encoded Identification Features - FINGER(s)',\
		   '76':'EF.DG4 Encoded Identification Features - IRIS(s)',\
		   '65':'EF.DG5 Displayed Identification Feature(s) - PORTRAIT',\
		   '66':'EF.DG6 Reserved for future use',\
		   '67':'EF.DG7 Displayed Identification Features - SIGNATURE or USUAL MARK',\
		   '68':'EF.DG8 Encoded Security Features - DATA FEATURE(s)',\
		   '69':'EF.DG9 Encoded Security Features - STRUCTURE FEATURE(s)',\
		   '6A':'EF.DG10 Encoded Security Features - SUBSTANCE FEATURE(s)',\
		   '6B':'EF.DG11 Additional Personal Detail(s)',\
		   '6C':'EF.DG12 Additional Document Detail(s)',\
		   '6D':'EF.DG13 Optional Detail(s)',\
		   '6E':'EF.DG14 Reserved for Future Use',\
		   '6F':'EF.DG15 Active Authentication Public Key Info',\
		   '70':'EF.DG16 Person(s) to Notify',\
		   '77':'EF.SOD Document Security Object',\
		   '5c':'Tag List',\
		   '5f01':'LDS Version',\
		   '5f36':'Unicode Version'}

	"display contents of EF.COM"
	hexdata= passport.ToHex(data)
	# skip header
	tag= 2
	# EF.COM length
	print 'Length: ',
	print int(hexdata[tag:tag+2],16)
	tag += 2
	while tag < len(hexdata):
		# end of data
		if hexdata[tag:tag+2] == TAG_PAD:
			return
		# LDS & Unicode Versions
		if hexdata[tag:tag+4] == TAG_LDS or  hexdata[tag:tag+4] == TAG_UNICODE:
			print 'Tag: ' + hexdata[tag:tag+4] + ' (' + TAG_TYPE[hexdata[tag:tag+4]] + ')'
			tag += 4
			print '  Length: ',
			length= int(hexdata[tag:tag+2],16) 
			print length
			length= length * 2
			tag += 2
			print '    Data: ',
			print hexdata[tag:tag+length]
			tag += length
		if hexdata[tag:tag+2] == TAG_LIST:
			print 'Tag: ' + hexdata[tag:tag+2] + ' (' + TAG_TYPE[hexdata[tag:tag+2]] + ')'
			tag += 2
			print '  Length: ',
			length= int(hexdata[tag:tag+2],16)
			print length
			tag += 2
			for n in range(length):
				print '    Data Group: ',
				print hexdata[tag:tag+2] + ' (' + TAG_TYPE[hexdata[tag:tag+2]] + ')'
				tag += 2

def read_file(file):
	select_file(file)
	readlen= 4
	out= read_binary(readlen,0)
	print passport.errorcode
	passport.HexPrint(out)
	
def secure_read_file(keyenc,keymac,file):
	MAXCHUNK= 96

	rapdu= secure_select_file(keyenc,keymac,file)
	# secure read file header
	readlen= 4
	rapdu= secure_read_binary(keymac,readlen,0)
	do87= rapdu[6:22]
	if DEBUG:
		print 'DO87: ' + do87
		print 'Decrypted DO87: ',
	tdes=  DES3.new(keyenc,DES.MODE_CBC,passport.DES_IV)
	decdo87= tdes.decrypt(passport.ToBinary(do87))[:readlen]
	if DEBUG:
		passport.HexPrint(decdo87)

	# get file length based on header type
	do87hex= passport.ToHex(decdo87)
	if do87hex[:2] == EF_COM_TAG or do87hex[:2] == EF_DG1_TAG:
		datalen= int(do87hex[2:4],16) + 2
		passport.HexPrint(decdo87)
	else:
		if do87hex[:2] == EF_DG2_TAG or do87hex[:2] == EF_SOD_TAG:
			datalen= int(do87hex[4:8],16) + 4
		else:
			print 'Unknown File TAG: ',
			passport.HexPrint(decdo87)
			os._exit(False)

	print 'File Length: ',
	print datalen
	# secure read remaining file
	offset= 4
	readlen= datalen - offset
	while readlen > 0:
		if readlen > MAXCHUNK:
			toread= MAXCHUNK
		else:
			toread= readlen
		rapdu= secure_read_binary(keymac,toread,offset)
		do87= rapdu[6:(toread + (8 - toread % 8)) * 2 + 6]
		tdes=  DES3.new(keyenc,DES.MODE_CBC,passport.DES_IV)
		decdo87 += tdes.decrypt(passport.ToBinary(do87))[:toread]
		offset += toread
		readlen -= toread
		print 'Reading: %05d\r' % readlen,
		sys.stdout.flush()
	print
	return decdo87

def decode_ef_dg1(data):
	length= int(passport.ToHex(data[4]),16)
	print 'Data Length: ',
	print length
	pointer= 5
	out= ''
	while pointer < len(data):
		if data[pointer] == chr(0x80):
			break
		out += '%s' % chr(int(passport.ToHex(data[pointer]),16))
		pointer += 1
	print '  Decoded Data: ' + out
	pointer= 0
	for n in range(len(MRZ_FIELD_NAMES)):
		print '    ' + MRZ_FIELD_NAMES[n] + ': ',
		print out[pointer:pointer + MRZ_FIELD_LENGTHS[n]]
		pointer += MRZ_FIELD_LENGTHS[n]
	return(out)

def bruteno(init):
	global num
	global map
	global brnum
	width= 0

	if init:
		# set up brute force and return number of iterations required
		for x in range(len(init)):
			if init[x] == '?':
				width += 1
				num.append(0)
				map.append(True)
			else:
				num.append(int(init[x]))
				map.append(False)
		return pow(10, width)
	else:
		out= ''
		bruted= False
		for x in range(len(num)):
			if map[x]:
				if bruted:
					continue
				else:
					bruted= True
					out += '%0*d' % (width, brnum)
					brnum += 1
			else:
				out += '%d' % num[x]
		return out

passport = RFIDIOtconfig.card
passport.info('mrpkey v0.1g')

TEST= False
bruteforce= False
bruteforceno= False

if not len(sys.argv) == 2 or (not len(sys.argv[1]) == 44 and not sys.argv[1] == 'TEST'):
	print
	print 'usage:'
	print '\t' + sys.argv[0] + ' <MRZ (Lower)|TEST>'
	print
	print '\tSpecify \'?\' for check digits if not known and they will be calculated.'
	print '\tPadding character \'<\' should be used for unknown fields.'
	print '\tSpecify \'?\' in the passport number field for bruteforce of that portion.'
	print '\tNote: only one contiguous portion of the field may be specified.'
	print
	os._exit(False)

if sys.argv[1] == 'TEST':
	TEST= True

print

if TEST:
	passport.MRPmrzl(TEST_MRZ)
	print 'Test MRZ: ' + TEST_MRZ
else:
	passport.MRPmrzl(sys.argv[1])

print 'Passport number: ' + passport.MRPnumber
if passport.MRPnumber.find('?') > 0:
	bruteforce= True
	bruteforceno= True
	# initialise bruteforce for number
	iterations= bruteno(passport.MRPnumber)
	print 'Bruteforcing Passport Number (%d iterations)' % iterations
else:
	iterations= 1
print 'Nationality: ' + passport.MRPnationality
print 'Date Of Birth: ' + passport.MRPdob
print 'Sex: ' + passport.MRPsex
print 'Expiry: ' + passport.MRPexpiry
print 'Optional: ' + passport.MRPoptional

# loop until successful login breaks us out or we've tried all possibilities
while iterations:
	iterations -= 1
	if bruteforceno:
		passport.MRPnumber= bruteno('')
	# always calculate check digits (makes bruteforcing easier)
	passport.MRPnumbercd= calculate_check_digit(passport.MRPnumber)
	passport.MRPdobcd= calculate_check_digit(passport.MRPdob)
	passport.MRPexpirycd= calculate_check_digit(passport.MRPexpiry)
	passport.MRPoptionalcd= calculate_check_digit(passport.MRPoptional)
	passport.MRPcompsoitecd= calculate_check_digit(passport.MRPnumber + passport.MRPnumbercd + passport.MRPnationality + passport.MRPdob + passport.MRPdobcd + passport.MRPsex + passport.MRPexpiry + passport.MRPexpirycd + passport.MRPoptional + passport.MRPoptionalcd)

	kmrz= passport.MRPnumber + passport.MRPnumbercd + passport.MRPdob + passport.MRPdobcd + passport.MRPexpiry + passport.MRPexpirycd

	print
	print 'Generate local keys:'
	print
	print 'Key MRZ Info (kmrz): ' + kmrz
	print
	kseedhash= SHA.new(kmrz)
	kseed= kseedhash.digest()[:16]
	if DEBUG:
		print 'Kseed (SHA1 hash digest of kmrz): ' + kseedhash.hexdigest()[:32]

	# calculate Kenc & Kmac
	Kenc= passport.DESKey(kseed,passport.KENC,16)
	if DEBUG:
		print 'Kenc: ',
		passport.HexPrint(Kenc)
	Kmac= passport.DESKey(kseed,passport.KMAC,16)
	if DEBUG:
		print 'Kmac: ',
		passport.HexPrint(Kmac)
		print

	if TEST:
		rnd_ifd= TEST_rnd_ifd
		rnd_icc= TEST_rnd_icc
		Kifd= TEST_Kifd
	else:
		hss= passport.hsselect('08')
		if DEBUG:
			print 'High Speed Select: ',
			print hss
		print 'Select Passport Application (AID): ',
		select_passport_app()
		print 'Select Master File: ',
		select_file(EF_COM)
# australian read without auth
#		read_file(EF_DG1)
# end aussie
		if DEBUG:
			print 'Get Challenge from Passport (rnd_icc): ',
		rnd_icc= get_challenge(8)
		if DEBUG:
			passport.HexPrint(rnd_icc)
		rnd_ifd= getrandom(8)
		Kifd= getrandom(16)

	if DEBUG or DEBUG:
		print 'Generate local random Challenge (rnd_ifd): ' + rnd_ifd
		print 'Generate local random Challenge (Kifd): ' + Kifd
		print

	S= passport.ToBinary(rnd_ifd + rnd_icc + Kifd)

	if DEBUG or TEST:
		print 'S: ',
		passport.HexPrint(S)

	if DEBUG or TEST:
		print 'Kenc: ',
		passport.HexPrint(Kenc)


	tdes= DES3.new(Kenc,DES.MODE_CBC,passport.DES_IV)
	Eifd= tdes.encrypt(S)
	if DEBUG or TEST:
		print 'Eifd: ',
		passport.HexPrint(Eifd)
		print 'Kmac: ',
		passport.HexPrint(Kmac)
	Mifd= passport.DESMAC(Eifd,Kmac,'')
	if DEBUG or TEST:
		print 'Mifd: ',
		passport.HexPrint(Mifd)

	cmd_data= Eifd + Mifd
	if DEBUG or TEST:
		print 'cmd_data: ',
		passport.HexPrint(cmd_data)
		print

	if TEST:
		respdata= TEST_respdata
	else:
		print 'Authenticating: ',
		respdata= mutual_authenticate(cmd_data,Kmac)

	if DEBUG or TEST:
		print 'Auth Response: ' + respdata
	resp= respdata[:64]
	respmac= respdata[64:80]
	if DEBUG or TEST:
		print 'Auth message: ' + resp
		print 'Auth MAC: ' + respmac + ' (verified)'
	decresp= passport.ToHex(tdes.decrypt(passport.ToBinary(resp)))
	if DEBUG or TEST:
		print 'Decrypted Auth Response: ' + decresp
		print 'Decrypted rnd_icc: ' + decresp[:16]
	recifd= decresp[16:32]
	if DEBUG or TEST:
		print 'Decrypted rnd_ifd: ' + recifd,
	# check returned rnd_ifd matches our challenge
	if not passport.ToBinary(recifd) == passport.ToBinary(rnd_ifd):
		print 'Challenge failed!'
		print 'Expected rnd_ifd: ', rnd_ifd
		print 'Received rnd_ifd: ', recifd
		if not bruteforce or iterations == 0:
			os._exit(False)
	else:
		if DEBUG or TEST:
			print '(verified)'
		# challenge succeeded, so break
		break

kicc= decresp[32:64] 
if DEBUG or TEST:
	print 'Decrypted Kicc: ' + kicc

# generate session keys
print
print 'Generate session keys: '
print
kseedhex= "%032x" % xor(int(Kifd,16),int(kicc,16))
kseed= passport.ToBinary(kseedhex)
print 'Kifd XOR Kicc (kseed): ',
passport.HexPrint(kseed)
KSenc= passport.DESKey(kseed,passport.KENC,16)
print 'Session Key ENC: ',
passport.HexPrint(KSenc)
KSmac= passport.DESKey(kseed,passport.KMAC,16)
print 'Session Key MAC: ',
passport.HexPrint(KSmac)

print
# calculate Send Sequence Counter
print 'Calculate Send Sequence Counter: '
print
SSC= passport.ToBinary(rnd_icc[8:16] + rnd_ifd[8:16])
print 'SSC: ',
passport.HexPrint(SSC)

# secure select master file
if TEST:
	KSmac= passport.ToBinary('F1CB1F1FB5ADF208806B89DC579DC1F8')
	rapdu= '990290008E08FA855A5D4C50A8ED9000'
	# ran out of steam on testing here! 
	os._exit(True)
else:
	data= secure_read_file(KSenc,KSmac,EF_COM)

# secure read file header
#if TEST:
#	KSmac= passport.ToBinary('F1CB1F1FB5ADF208806B89DC579DC1F8')
#	rapdu= '8709019FF0EC34F9922651990290008E08AD55CC17140B2DED9000'
#else:
#	readlen= 4
#	rapdu= secure_read_binary(KSmac,readlen,0)

print 'EF.COM: ',
if DEBUG:
	passport.HexPrint(data)
decode_ef_com(data)
efcom= open('/tmp/EF_COM.BIN','w+')
efcom.write(data)
efcom.flush()
efcom.close()
print 'EF.COM stored in /tmp/EF_COM.BIN'

# get SOD
print
print 'Select EF.SOD: ',
data= secure_read_file(KSenc,KSmac,EF_SOD)
if DEBUG:
	passport.HexPrint(data)
sod= open('/tmp/EF_SOD.BIN','w+')
sod.write(data)
sod.flush()
sod.close()
print 'EF.SOD stored in /tmp/EF_SOD.BIN'

# get DG1
print
print 'Select DG1: '
data= secure_read_file(KSenc,KSmac,EF_DG1)
ef1= open('/tmp/EF_DG1.BIN','w+')
ef1.write(data)
ef1.flush()
ef1.close
print 'EF.DG1 stored in /tmp/EF_DG1.BIN'
print 'EF.DG1: ',
if DEBUG:
	passport.HexPrint(data)
mrz= decode_ef_dg1(data)

# get DG2
print
print 'Select DG2: '
data= secure_read_file(KSenc,KSmac,EF_DG2)
print 'EF.DG2: ',
if DEBUG:
	passport.HexPrint(data)
# nasty hacky bodge to see if image display without interpreting the headers
img= open('/tmp/EF_DG2.JPG','w+')
# start of image location may change - look for JPEG header bytes 'FF D8 FF E0'
# in /tmp/EF_DG2.BIN
img.write(data[110:])
# aussie passport is 101
#img.write(data[101:])
# german is 84 and JP2 format, not JPG - look for '00 00 00 0C 6A 50'
#img.write(data[84:])
img.flush()
img.close()
print 'JPEG image stored in /tmp/EF_DG2.JPG'

# write whole of EF.DG2 to binary file
ef2= open('/tmp/EF_DG2.BIN','w+')
ef2.write(data)
ef2.flush()
ef2.close
print 'EF.DG2 stored in /tmp/EF_DG2.BIN'

# display data and image in gui window
root = Tk()
#root.withdraw()
view= guiviewpass(root,'/tmp/EF_DG2.JPG',mrz)
root.mainloop()
