#!/usr/bin/python

#  q5reset.py - plooking too hard on your Q5? this should sort it out.
# 
#  Adam Laurie <adam@algroup.co.uk>
#  http://rfidiot.org/
# 
#  This code is copyright (c) Adam Laurie, 2006, All rights reserved.
#  For non-commercial use only, the following terms apply - for all other
#  uses, please contact the author:
#
#    This code is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This code is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#


import RFIDIOt
import RFIDIOtconfig
import sys
import os
import string

card= RFIDIOtconfig.card
card.info('q5reset v0.1c')

# standard config block
CFB='e601f004'
B1='ff801bc2'
B2='52500006'

if len(sys.argv) == 1 or len(sys.argv) > 3:
	print sys.argv[0] + ' - sooth and heal a sorely mistreated Q5 tag'
	print 'Usage: ' + sys.argv[0] + ' <CONTROL> [ID]'
	print
	print '\tIf the optional ID argument is specified, the Q5 tag will be '
	print '\tprogrammed with a default ID. Otherwise, only the control block'
	print '\twill be written. Note that CONTROL and ID are both literals - '
	print '\ti.e. use the words \'CONTROL\' and \'ID\'.'
	os._exit(True)

if sys.argv[1] == 'CONTROL':
       	card.settagtype(card.ALL)
       	while True:
               	print
               	card.select()
               	print '  Card ID: ' + card.data
               	x= string.upper(raw_input('  *** Warning! This will overwrite TAG! Place defective card and proceed (y/n)? '))
               	if x == 'N':
               		os._exit(False)
       		if x == 'Y':
			break
	print 'Writing...'
       	card.settagtype(card.Q5)
	card.select()
	if not card.writeblock(0,CFB):
		print 'Write failed!'
		os._exit(False)
	else:
		if len(sys.argv) > 2 and sys.argv[2] == 'ID':
			if not card.writeblock(1,B1) or not card.writeblock(2,B2):
				print 'Write failed!'
				os._exit(False)	 	
	print 'Done!'
       	card.select()
       	print '  Card ID: ' + card.data
	card.settagtype(card.ALL)
