#!/usr/bin/python

#  unique.py - 	generate EM4x02 and/or UNIQUE compliant IDs
#  		these can then be written to a Q5 tag to emulate EM4x02
#		by transmitting data blocks 1 & 2 (MAXBLOCK == 2),
#		or Hitag2 in Public Mode A with data stored in blocks
#		4 and 5.
# 
#  Adam Laurie <adam@algroup.co.uk>
#  http://rfidiot.org/
# 
#  This code is copyright (c) Adam Laurie, 2006, All rights reserved.
#  For non-commercial use only, the following terms apply - for all other
#  uses, please contact the author:
#
#    This code is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This code is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#


import RFIDIOt
import RFIDIOtconfig
import sys
import os
import string

card= RFIDIOtconfig.card
card.info('unique v0.1d')

# Q5 config block
Q5CFB='e601f004'
# Hitag2 config block
H2CFB= card.HITAG2_PUBLIC_A + card.HITAG2_TRANSPORT_TAG

if len(sys.argv) < 3 or len(sys.argv) > 4:
	print sys.argv[0] + ' - generate EM4x02 and/or UNIQUE compliant ID data blocks'
	print 'Usage: ' + sys.argv[0] + ' <TYPE> <ID> [WRITE]'
	print
	print '\t10 digit HEX ID will be translated to valid data for blocks 1 & 2'
	print '\tfor a Q5 tag running in EM4x02 emulation mode, where TYPE is U for'
	print '\tUNIQUE code and E for EM4x02. For guidance, a standard emulation'
	print '\tcontrol block (0) will also be displayed.' 
	print 
	print '\tIf the optional WRITE argument is specified, programming a Q5 tag will '
	print '\tbe initiated.'
	print
	os._exit(True)

id= sys.argv[2]
if sys.argv[1] == 'E':
	type= 'EM4x02'
	idbin= card.UniqueToEM(id)
else:
	if sys.argv[1] == 'U':
		type= 'UNIQUE'
		idbin= card.ToBinaryString(card.ToBinary(id))
	else:
		print 'Unknown TYPE: ' + sys.argv[1]
		os._exit(False)

out= card.Unique64Bit(idbin)
db1= '%08x' % int(out[:32],2)
db2= '%08x' % int(out[32:64],2)
print
print '  ' + type + ' ID: ' + id
print '  Q5 ID: ' + '%08x' % int(idbin[:32],2)
if type ==  'EM4x02':
	print '  UNIQUE ID: ' + '%10x' % int(idbin,2)
else:
	print '  EM4x02 ID: ' + ('%10x' % int(card.UniqueToEM(id),2))[::-1]
print '  Binary traceablility data: ' + out
print
print '  Q5 Config Block (0): ' + Q5CFB
print '  Data Block 1: ' + db1
print '  Data Block 2: ' + db2
print
print '  Hitag2 Config Block (3): ' + H2CFB 
print '  Data Block 4: ' + db1
print '  Data Block 5: ' + db2

if len(sys.argv) == 4 and sys.argv[3] == 'WRITE':
	while True:
		# check for Q5 first`
		if card.readertype == card.READER_ACG:
			card.settagtype(card.Q5)
			card.select()
			if not card.tagtype == card.Q5:
				card.settagtype(card.ALL)
		card.waitfortag('Waiting for blank tag...')
		print 'Tag ID: ' + card.data
		if card.tagtype == card.Q5 or card.tagtype == card.HITAG2:
        		x= string.upper(raw_input('  *** Warning! This will overwrite TAG! Proceed (y/n)? '))
        		if x == 'N':
                		os._exit(False)
        		if x == 'Y':
				break
		else:
			x= raw_input('  Incompatible TAG! Hit <RETURN> to retry...')
	print 'Writing...'
	if card.tagtype == card.Q5:
		if not card.writeblock(0,Q5CFB) or not card.writeblock(1,db1) or not card.writeblock(2,db2):
			print 'Write failed!'
			os._exit(False)
	if card.tagtype == card.HITAG2:
		if card.readertype == card.READER_ACG:
			card.login('','',card.HITAG2_TRANSPORT_RWD)
		if not card.writeblock(3,H2CFB) or not card.writeblock(4,db1) or not card.writeblock(5,db2):
			print 'Write failed!'
			os._exit(False)
	print card.settagtype(card.EM4x02)
	card.select()
	print 'Card ID: ' + card.data
	print 'Done!'
	card.settagtype(card.ALL)
