#!/usr/bin/python


#  RFIDIOtconfig.py - shared settings for local RFIDIOt
# 
#  Adam Laurie <adam@algroup.co.uk>
#  http://rfidiot.org/
# 
#  This code is copyright (c) Adam Laurie, 2006, All rights reserved.
#  For non-commercial use only, the following terms apply - for all other
#  uses, please contact the author:
#
#    This code is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This code is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#

import RFIDIOt
import getopt
import sys
import os


# change the following sections to match your serial port
# bluetooth connections need at least 1 second timeout to establish connection

# help flag (-h) set?
help= False

# reader type (can be overridden with -r)
readertype= RFIDIOt.rfidiot.READER_ACG
#readertype= RFIDIOt.rfidiot.READER_FROSCH
#readertype= RFIDIOt.rfidiot.READER_DEMOTAG

# serial port (can be overridden with -l)
#line= "/dev/ttyS0"
line= "/dev/ttyS1"
#line= "/dev/ttyUSB0"

# serial port speed (can be overridden with -s)
#speed= 9600
#speed= 57600
speed= 115200
#speed= 230400
#speed= 460800

# reader timeout (can be overriden with -t)
timeout= 1

def printoptions():
	print '\nOptions:\n'
	print '\t-h\t\tPrint detailed help message'
	print '\t-r <type>\tReader/writer type (see source of RFIDIOt.py for details)'
	print '\t-l <line>\tLine to use for reader/writer'
	print '\t-s <baud>\tSpeed of reader/writer'
	print '\t-t <seconds>\tTimeout for inactivity of reader/writer'
	print

# check for global overrides
# 'args' will be set to remaining arguments (if any)
try:
	opts, args  = getopt.getopt(sys.argv[1:],'hr:l:s:t:')
	for o, a in opts:
		if o == '-h':
			help= True
		if o == '-r':
			readertype= a
		if o == '-l':
			line= a
		if o == '-s':
			speed= int(a)
		if o == '-t':
			timeout= int(a)
	card= RFIDIOt.rfidiot(readertype,line,speed,timeout)
except getopt.GetoptError,e:
   		print "RFIDIOtconfig module ERROR: %s" % e
		printoptions()
		args= []
