#!/usr/bin/python


#  isotype.py - determine ISO tag type
# 
#  Adam Laurie <adam@algroup.co.uk>
#  http://rfidiot.org/
# 
#  This code is copyright (c) Adam Laurie, 2006, All rights reserved.
#  For non-commercial use only, the following terms apply - for all other
#  uses, please contact the author:
#
#    This code is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This code is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#


import sys
import os
import RFIDIOtconfig

try:
        card= RFIDIOtconfig.card
except:
        os._exit(False)


card.info('isotype v0.1f')

typed= 0
for command, cardtype in card.ISOTags.iteritems():
	if not card.settagtype(command):
		print 'Could not test for card type: ' + cardtype
	if card.select():
		print '\nID: ' + card.data
		print "  Tag is " + cardtype
		typed= 1
		if command == card.ISO15693:
			print '    Manufacturer: ' + card.ISO15693Manufacturer[card.data[2:4]]
if not typed:
	print "Could not determine type."
for command, cardtype in card.ISOTagsA.iteritems():
	if not card.settagtype(command):
		print 'Could not reset reader to ' + cardtype + '!'
		os._exit(False)
