#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

int iwpriv_exist(void)
{
	int n,pid;
	if ((pid=fork())==0)
	{
		close( 0 ); close( 1 ); close( 2 ); chdir( "/" );
		execlp("iwpriv", "iwpriv", NULL);
		exit( 1 );
	}

	waitpid( pid, &n, 0 );
	return ( ( WIFEXITED(n) && WEXITSTATUS(n) == 0 ) );
}

int is_ndiswrapper(const char * iface)
{
	int n,pid;
	if ((pid=fork())==0)
	{
		close( 0 ); close( 1 ); close( 2 ); chdir( "/" );
		execlp("iwpriv", "iwpriv",iface, "ndis_reset", NULL);
		exit( 1 );
	}

	waitpid( pid, &n, 0 );
	return ( ( WIFEXITED(n) && WEXITSTATUS(n) == 0 ));
}

char * getVersion(char * progname, int maj, int min, int submin, int betavers)
{
	char * temp;
	temp = (char *) calloc(1,strlen(progname)+50);
	char * provis = calloc(1,20);
	sprintf(temp, "%s %d.%d", progname, maj, min);
	if (submin>0) {
		sprintf(provis,".%d",submin);
		strcat(temp,provis);
		memset(provis,0,20);
	}
	if (betavers>0) {
		sprintf(provis," beta%d",betavers);
		strcat(temp,provis);
	}
	free(provis);
	temp = realloc(temp, strlen(temp)+1);
	return temp;
}
