#!/usr/bin/perl -Tw
# airsnarf_dns.pl
# Net::DNS::Nameserver with localhost & localhost.localdomain returns  
# mostly ripped from some Net::DNS:Nameserver example via Google

use Net::DNS;
use Net::DNS::Nameserver;
use strict;
  

sub reply_handler {
	  my ($qname, $qclass, $qtype) = @_;
	  my ($rcode, @ans, @auth, @add);
  
	  if (($qname eq "localhost") || ($qname eq "localhost.localdomain")) {
	my ($ttl, $rdata) = (3600, "127.0.0.1");
	push@ans, Net::DNS::RR->new("$qname $ttl $qclass $qtype $rdata");
	$rcode = "NOERROR";
	}
	  elsif ($qtype eq "A") {
		my ($ttl, $rdata) = (3600, "192.168.1.254");
		push @ans, Net::DNS::RR->new("$qname $ttl $qclass $qtype $rdata");
		$rcode = "NOERROR";
	  }
	  else {
		$rcode = "NXDOMAIN";
	  }
		

	  return ($rcode, \@ans, \@auth, \@add);
}


my $ns = Net::DNS::Nameserver->new(
	  LocalPort	   => 53,
	  ReplyHandler => \&reply_handler,
	  Verbose	   => 1
);
  

if ($ns) {
	  $ns->main_loop;
}
else {
	  die "couldn't create nameserver object\n";
}
