/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <unistd.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <asm/types.h>
#include <linux/netlink.h>

#include "PacketSource.h"
#define MCAST_GRP_SNIFF 2

PacketSource::PacketSource() {
  fd=pread=pwrite=-1;
}

PacketSource::~PacketSource() {
  close();
}

int PacketSource::open() {
  int fds[2],r;
  struct sockaddr_nl addr;
  r=pipe(fds);
  if (r<0) return(r);
  pread=fds[0]; pwrite=fds[1];
  fd=socket(PF_NETLINK,SOCK_RAW,MCAST_GRP_SNIFF);
  if (fd<0) return(r);
  addr.nl_family=PF_NETLINK;
  addr.nl_pid=getpid();
  addr.nl_groups=MCAST_GRP_SNIFF;
  if (bind(fd,(struct sockaddr *) &addr,sizeof(struct sockaddr_nl))<0) 
    return(-1);
  return(fd);
}

void PacketSource::close() {
  if (fd>=0) ::close(fd);
  if (pread>=0) ::close(pread);
  if (pwrite>=0) ::close(pwrite);
}

int PacketSource::getPacket(char *buf,int maxlen,int timeout) {
  fd_set rs;
  int r;
  struct timeval tm;
  struct timeval *ptm;
  if (pread<0 || fd<0) return(ERR_IO);
  FD_ZERO(&rs);
  FD_SET(fd,&rs);
  FD_SET(pread,&rs);
  if (timeout>=0) {
    tm.tv_sec=timeout/1000;
    tm.tv_usec=(timeout%1000)*1000;
    ptm=&tm; 
  } else {
    ptm=NULL;
  }
  r=select(pread>fd?pread+1:fd+1,&rs,NULL,NULL,ptm);
  if (r<0) return(ERR_IO);
  if (r==0) {
    if (timeout>=0) return(ERR_TIMEOUT);
  }
  if (FD_ISSET(pread,&rs)) {
    char a;
    read(pread,&a,1);
  }
  if (FD_ISSET(fd,&rs)) {
    r=recv(fd,buf,maxlen,0);
    if (r<0) return(ERR_IO);
    return(r);
  }
  return(ERR_TIMEOUT);
}

void PacketSource::cancel() {
  if (pwrite>=0) write(pwrite,"a",1);
}

