/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __PacketSource_h__
#define __PacketSource_h__

#define ERR_IO -1
#define ERR_TIMEOUT -2 // timeout or cancel

class PacketSource {
protected:
  int fd; // File descriptor of netlink socket
  int pwrite,pread; // File descriptors for cancel pipe
public:
  // Create a packet source, unopened 
  PacketSource();
  // Destroy packet source, closes if currently open 
  ~PacketSource();
  // Open a packet source
  int open(); 
  // Close a packet source
  void close();
  // Gets a packet, returns actual length, if block is set wait, otherwise
  // return immediately, returns ERR_* 
  int getPacket(char *buf,int maxlen,int timeout=-1); 
  // Cancels a waiting getPacket
  void cancel();
};

#endif
