/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define N 256

extern int Identity[N];

class RC4 {
protected:
  int S[N];
  int i,j;
public:
  static void setupIdentity();
  RC4();
  void keyStep(unsigned char *K,int l);
  void keyDone();
  void keyWith(unsigned char *K,int l);
  int step();
  int SInverse(int x);
  int keyGuess(int I,int B,int out);
  int isOk(int I,int B);
  int tryIV(unsigned char *key,int I,int B,int out);
};

class Verifier {
public:
  virtual int checkKey(unsigned char *key,int len)=0;
};

struct Sample {
  unsigned char iv[3];
  unsigned char firstByte;
  Sample *next;
};

#define RES_BREADTH_EXCEEDED 1
#define RES_FAILURE 2
#define RES_SUCCESS 3

class RC4Crack {
protected:
  int keySize;
  Sample **samples;
  unsigned char *curGuess;
  Verifier *v;
  int tryByte(int which,int breadth);
public:
  RC4Crack(Verifier *v,int keySize);
  ~RC4Crack();
  int addSample(unsigned char *iv,unsigned char byte);
  int tryCrack(int breadth,unsigned char *result);
};



