/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <string.h>
#include <time.h>
#include <pthread.h>
#include <curses.h>
#include <unistd.h>
#include <fcntl.h>
#include <getopt.h>
#include <errno.h>
#include "PacketSource.h"

int numPackets;
int numEncrypted;
int numInteresting;
unsigned char lastIV[3];

void setupScreen() {
  initscr();
  cbreak();
  noecho();
  mvprintw(0,1,"AirSnort Capture v0.0.9");
  mvprintw(1,1,"Copyright 2001, Jeremy Bruestle and Blake Hegerle");
}

void drawStatus() {
  int i;
  unsigned char key[13];
  mvprintw(3,1,"Total Packets:       %d      ",numPackets);
  mvprintw(4,1,"Encrypted Packets:   %d      ",numEncrypted);
  mvprintw(5,1,"Interesting Packets: %d      ",numInteresting);
  mvprintw(6,1,"Last IV = %2.2x:%2.2x:%2.2x ",lastIV[0],lastIV[1],lastIV[2]);
  refresh();
}

int main(int argc,char *argv[]) {
  int r,len,fd;
  int curses=0;
  int lasttime=0;
  unsigned char packet[2500];

  while(1) {
    r=getopt(argc,argv,"c");
    if (r<0) break;
    switch(r) {
    case 'c':
      curses++;
      break;
    case '?':
      exit(1);
    }
  }
  if (argc-optind!=1) {
    fprintf(stderr,"Usage: %s [-c] <file>\n",argv[0]);
    exit(1);
  }
  
  fd=open(argv[optind],O_WRONLY | O_CREAT | O_APPEND | O_SYNC,0644);
  if (fd<0) {
    perror("Unable to open capture file");
    exit(1);
  }
  PacketSource *ps=new PacketSource();

  r=ps->open();
  if (r<0) {
    perror("Unable to open packet source");
    exit(1);
  } 

  if (curses) setupScreen();
  while(1) {
    if (curses && time(0)!=lasttime) {
      drawStatus();
      lasttime=time(0);
    }
    len=ps->getPacket((char *) packet,2400,1000);
    if (len<0) {
      if (errno==ENOBUFS) continue;
      if (curses) endwin();
      perror("Unable to get packet"); 
      exit(1);
    }
    numPackets++;

    if (len<168+9) continue; // Too short to be enc packet
    if (packet[144]!=8) continue; // Not data packet (control/mgt/etc)
    if (packet[168]==0xaa) continue; // Most likely unencrypted
    numEncrypted++;
    memcpy(lastIV,packet+168,3);

    if (packet[168]>=3 && packet[168]<3+13 && packet[169]==255) {
      len-=172;
      r=write(fd,&len,sizeof(int));
      if (r!=sizeof(int)) {
	if (curses) endwin();
	perror("Unable to write packet length"); 
	exit(1);
      }
      r=write(fd,packet+168,len);
      if (r!=len) {
	if (curses) endwin();
	perror("Unable to write packet"); 
	exit(1);
      }
      numInteresting++;
    }
  }
}
