/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <getopt.h>
#include <string.h>
#include "RC4.h"
#include "crc-32.h"
#include "utils.h"
  
int main(int argc,char *argv[]) {
  int r,i,fd,len,plen;
  unsigned char password[16];
  unsigned char buf[4000];
  RC4 *rc;
  RC4::setupIdentity();
  plen=13;
  memset(password,0,16);

  while(1) {
    r=getopt(argc,argv,"s:");
    if (r<0) break;
    switch(r) {
    case 's':
      if (strlen(optarg)==13) {
	memcpy(password+3,optarg,13);
      } else if (strlen(optarg)==5) {
	memcpy(password+3,optarg,5);
	plen=5;
      } else {
	fprintf(stderr,
		"Invalid password length: must be 5 or 13 characters\n");
	exit(1);
      }
      break;
    case '?':
      exit(1);
    }
  }
  if (argc-optind!=1) {
    fprintf(stderr,"Usage: %s (-s <passwd> | -h <passwd>) <file>\n",argv[0]);
    exit(1);
  }
  fd=open(argv[optind],O_RDONLY);
  if (fd<0) {
    perror("Unable to open file");
    exit(1);
  }

  printf("Reading packets\n");
  while(1) {
    r=read(fd,&len,sizeof(int));
    if (r==0) break;
    if (r<0) {
      perror("Error reading packet len");
      exit(1);
    }
    if (r>2000) {
      fprintf(stderr,"Packet too long, %d\n",r);
      exit(1);
    }
    r=read(fd,buf,len);
    if (r!=len) {
      perror("Error reading packet");
      exit(1);
    }
    memcpy(password,buf,3);
    RC4 *rc=new RC4();
    rc->keyWith(password,3+plen);
    for(i=4;i<len;i++) {
      buf[i] ^= rc->step();
    }
    if (doFCS(buf+4,len-4)!=0xdebb20e3) {
      printf("BAD CRC! Maybe wrong password?\n");
    } else {
      hexdump(buf+4,len-4);
      printf("\n");
    }
  }
}

