/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <getopt.h>
#include <netinet/in.h>
#include "RC4.h"
#include "crc-32.h"

int main(int argc,char *argv[]) {
  int r,len,fd,plen;
  int i,j,k,numCases=100;
  unsigned char packet[2500];
  RC4 *rc;
  unsigned char password[16];
  plen=13;
  memset(password,0,16);

  RC4::setupIdentity();
  while(1) {
    r=getopt(argc,argv,"n:s:");
    if (r<0) break;
    switch(r) {
    case 's':
      if (strlen(optarg)==13) {
	memcpy(password+3,optarg,13);
      } else if (strlen(optarg)==5) {
	memcpy(password+3,optarg,5);
	plen=5;
      } else {
	fprintf(stderr,
		"Invalid password length: must be 5 or 13 characters\n");
	exit(1);
      }
      break;
    case 'n':
      numCases=atoi(optarg);
      if (numCases<0 || numCases>255) numCases=100;
      break;
    case '?':
      exit(1);
    }
  }
  if (argc-optind!=1) {
    fprintf(stderr,"Usage: %s [-n numCases] <file>\n",argv[0]);
    exit(1);
  }
  
  fd=open(argv[optind],O_WRONLY | O_CREAT | O_APPEND,0644);
  if (fd<0) {
    perror("Unable to open case file");
    exit(1);
  }

  len=12;
  packet[3]=0;
  for(i=0;i<numCases;i++) {
    for(j=0;j<plen;j++) {
      packet[0]=password[0]=3+j;
      packet[1]=password[1]=255;
      packet[2]=password[2]=i;
      
      rc=new RC4();
      rc->keyWith(password,3+plen);
      packet[4]=0xAA; packet[5]=0x00;
      packet[6]=0x01; packet[7]=0x02;
      *((int *) (packet+8))=~doFCS(packet+4,4);
      for(k=4;k<12;k++) {
	packet[k]^=rc->step();
      }
      r=write(fd,&len,sizeof(int));
      if (r!=sizeof(int)) {
	perror("Unable to write packet length"); 
	exit(1);
      }
      r=write(fd,packet,len);
      if (r!=len) {
	perror("Unable to write packet"); 
	exit(1);
      }
    }
  }
}

