/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>

char hexdecode[]="0123456789ABCDEF";

char *deparseMac(unsigned char *mac) {
  static char ans[20];
  int i;
  for(i=0;i<6;i++) {
    ans[i*3]=hexdecode[mac[i]/16];
    ans[i*3+1]=hexdecode[mac[i]%16];
    ans[i*3+2]=':';
  }
  ans[17]=0;
  return(ans);
}

void hexdump(unsigned char *buf,int size) {
  int r,i;
  while(size) {
    r=size; if (r>16) r=16;
    for(i=0;i<r;i++) 
      printf("%2.2x ",buf[i]);
    for(i=r;i<16;i++)
      printf("   ");
    printf("  ");
    for(i=0;i<r;i++) {
      if (buf[i]>=32 && buf[i]<128)
	printf("%c",buf[i]);
      else
	printf(".");
    }
    printf("\n");
    buf+=r;
    size-=r;
  }
}
