/*
 *    ap-utils.h from Wireless Access Point Utilites for Unix
 *  Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef	_AP_CNF
#define _AP_CNF 1

#include "config.h"

#ifdef OS_BSD
#include <sys/types.h>
#else
#include <features.h>
#if defined (__GLIBC__)
#include <stdint.h>
#else
typedef unsigned short uint16_t;
typedef unsigned   int uint32_t;
#endif

#endif

#define TITLE "Wireless Access Point Utilites for Unix"

#define minimum(x, y)	x <= y ? x : y

#ifdef HAVE_GETTEXT
/* GNU gettext stuff*/
#include <locale.h>
#include <libgnuintl.h>
#define _(String) gettext (String)
#else
#define _(String) (String)
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>


#ifdef WORDS_BIGENDIAN
/* a quick-and-dirty macro to unconditionally swap bytes in 4-byte integers
 * between big-endian and little-endian ordering */
#define swap2(d) ((((d) >> 8) & 0x00ff) | (((d) << 8) & 0xff00))
#define swap4(d) ((((d) >> 24) & 0x000000ff) | (((d) >>  8) & 0x0000ff00) | (((d) <<  8) & 0x00ff0000) | (((d) << 24) & 0xff000000))
#else
#define swap2(d) d
#define swap4(n) n
#endif

#define rlong(a)	((a) = swap4(a))
#define wlong(a)	((a) = swap4(a))
#define rshort(a)	((a) = swap2(a))
#define wshort(a)	((a) = swap2(a))

#define MAC _("MAC address: ")
#define TRAPS _("[S] SNMP traps: ")

#define CHANNEL _("[C] Frequency channel: ")

#define ANTENNA_RX _("Receive  antenna:")
#define ANTENNA_RX_LEFT  _("[U] Left")
#define ANTENNA_RX_RIGHT _("[I] Right")
#define ANTENNA_TX _("Transmit antenna:")
#define ANTENNA_TX_LEFT  _("[O] Left")
#define ANTENNA_TX_RIGHT _("[P] Right")
#define ANTENNA_DV _("Diversity select:")
#define ANTENNA_DV_LEFT  _("[T] Left")
#define ANTENNA_DV_RIGHT _("[Y] Right")

#define YES _("Yes")
#define NO _("No")

#define ON _("On")
#define OFF _("Off")

#define BASIC _("Basic")

#define ANY_KEY _("Press any key to continue.")

#define ERR_SET _("Unable to write data to AP. Press any key to continue.")
#define ERR_RET _("Unable to retrieve data from AP. Press any key to continue.")
#define WAIT_RET _("Retrieving data from AP. Please wait...")
#define WAIT_SET _("Writing data to AP. Please wait...")
#define DONE_SET _("Configuration written to the AP. Press any key to continue.")

#define CREATE_SOCKET_ERROR _("Create socket error. Press any key.")
#define BIND_SOCKET_ERROR _("Bind socket error. Press any key.")

#define MAIN_MENU  _("Back to main menu")
#define MENU_EXIT _("Exit program")
#define MENU_SHELL _("Run subshell. To return type 'exit'.")
#define MENU_ABOUT _("Short info about program")
#define MENU_SEARCH _("Find connected Access Points")
#define MENU_CONNECT _("Set connection options: ip and community")
#define MENU_ENCRYPT _("Set encryption; edit WEP keys")
#define MENU_MAC _("Set MAC authorization; edit MAC authorization table")
#define MENU_COMMUNITY _("Set SNMP community/password for access to the AP")
#define MENU_SYSINFO _("Get info about AP hardware and firmware")
#define MENU_WIRELESS _("Get wireless port statistics")
#define MENU_STAS _("Get list of currently associated stations (Access Point clients)")
#define MENU_INFO _("Get info and statistics from AP")
#define MENU_CONFIG  _("Set various configuration options")


#define INT_VALUE	0x02
#define STRING_VALUE	0x04
#define NULL_VALUE	0x05
#define OID_VALUE	0x06

#define GET             0xA0
#define GET_NEXT        0xA1
#define RESPONSE        0xA2
#define SET             0xA3
#define TRAP            0xA4

#define ASN_HEADER	0x30

#define INT_STRING	0x01
#define HEX_STRING	0x02
#define ANY_STRING	0x03

#define SIZE sizeof(struct sockaddr_in)
#define basic(i) (i & 0x80) ? BASIC : (i) ? ON : OFF


#define MCOLS 15 /* width of menu window */
#define LAST_ROW LINES-5

/* Basic distinguished MIB (and AP) types */
#define ATMEL410 0
#define NWN 1
#define ATMEL12350 2

typedef struct VarBind {
    unsigned char *oid;
    int len_oid;
    unsigned char *value;
    int len_val;
    unsigned char type;
} varbind;

struct umitems {
	char *item;
	char *help;
	void (*func)();
	int is_menu;
};

struct EthernetRxStatistics {
	uint32_t TotalBytesRx;
	uint32_t TotalPacketsRx;
	uint32_t PacketCRCErrorRx;
	uint32_t MulticastPacketRx;
	uint32_t BroadcastPacketRx;
	uint32_t ControlFramesRx;
	uint32_t PauseFramesRx;
	uint32_t UnknownOPCodeRx;
	uint32_t AlignmentRxError;
	uint32_t LengthOutOfRangeRx;
	uint32_t CodeErrorRx;
	uint32_t FalseCarrierRx;
	uint32_t UndersizePacketsRx;
	uint32_t OversizePacketsRx;
	uint32_t TotalFragmentsRx;
	uint32_t TotalJabberRx;
};

struct EthernetTxStatistics {
	uint32_t TotalBytesTx;
	uint32_t TotalPacketsTx;
	uint32_t PacketCRCErrorTx;
	uint32_t MulticastPacketTx;
	uint32_t BroadcastPacketTx;
	uint32_t UnicastPacketTx;
	uint32_t PauseFramesTx;
	uint32_t SingleDeferPacketTx;
	uint32_t MultiDeferPacketsTx;
	uint32_t SingleCollisionsTx;
	uint32_t MultiCollisionsTx;
	uint32_t LateCollisionsTx;
	uint32_t ExcessiveCollisionTx;
	uint32_t TotalCollisionsTx;
};

struct WirelessStatistics {
	uint32_t UnicastTransmittedPackets;
	uint32_t BroadcastTransmittedPackets;
	uint32_t MulticastTransmittedPackets;
	uint32_t TransmittedBeacon;
	uint32_t TransmittedACK;
	uint32_t TransmittedRTS;
	uint32_t TransmittedCTS;
	uint32_t UnicastReceivedPackets;
	uint32_t BroadcastReceivedPackets;
	uint32_t MulticastReceivedPackets;
	uint32_t ReceivedBeacon;
	uint32_t ReceivedACK;
	uint32_t ReceivedRTS;
	uint32_t ReceivedCTS;
	uint32_t ACKFailure;
	uint32_t CTSFailure;
	uint32_t RetryPackets;
	uint32_t ReceivedDuplicate;
	uint32_t FailedPackets;
	uint32_t AgedPackets;
	uint32_t FCSError;
	uint32_t InvalidPLCP;
};

struct SysDeviceInfo_ATMEL410 {
    /* sysDeviceInfo OID struct for ATMEL 410 */
    uint32_t StructVersion;
    unsigned char MacAddress[6];
    unsigned short Reserved;
    uint32_t RegulationDomain;
    uint32_t ProductType;
    unsigned char OEMName[32];
    uint32_t OEMID;
    unsigned char ProductName[32];
    uint32_t HardwareRevision;
};

struct SysDeviceInfo_ATMEL12350 {
    /* sysDeviceInfo OID struct for ATMEL 12350 */
    uint32_t StructVersion;
    unsigned char MacAddress[6];
    unsigned char Channel;
    unsigned char RegulatoryDomain;
    uint32_t ProductType;
    unsigned char OEMname[32];
    uint32_t OEMID;
    unsigned char ProductName[32];
    uint32_t HardwareRevision;
    /* The rest is actually dormant. */
    /*
    unsigned char PID_VID[4];
    uint32_t sysOIDSize;
    uint16_t sysOID[16];
    unsigned char CountryCode[3];
    unsigned char Reserved1;
    uint16_t ChannelInformation;
    unsigned char Reserved2[2];
    unsigned char TxPower[14];
    unsigned char Reserved3[10];
    */
};

struct MacListStat {
    unsigned char addr[6];
    struct MacListStat *next;
    int quality;
    int idle;
    int rssi;
	unsigned char  Status;
	unsigned char  Port;
	unsigned char  ParentMacAddress[6];
	struct in_addr IP;
};

/* Function prototypes specific/common for both utilites */

/* service */
extern char * oui2manufacturer(char *);
extern int ch_list(int, char **);
extern void connect_options(unsigned long int, int);
extern void about(void);
extern void draw_menu_win(void);
extern void main_menu(void);
extern void print_title(char *);
extern void print_viewtype(int);
extern void print_menusel(int, int, char *, char *);
extern void print_bottom(char *);
extern void print_help(char *);
extern void print_helperr(char *);
extern void clear_main(int);
extern void clear_main_new(int, int);
extern void get_mac(char *, int, int);
extern void get_ip(struct in_addr *, int, int, char *);
extern void get_mask(struct in_addr *, int, int, char *);
extern void get_value(char *, int, int, int, char, int, int, char *);
extern void get_pass(char *, int, int, int);
extern int  menu_choose(int, int, char **, unsigned int);
extern int  yes_no(int, int);
extern int  on_off(int, int);
extern void scroll_rows(struct MacListStat *, int, int, int, int);
extern void exit_shell(void);
extern void exit_program(void);
extern int  get_opts(void);
extern void save_Stations(struct MacListStat *);
extern void uni_menu(struct umitems *umenu, int num);

/* AP */
extern void AuthorizedSettings(void);
extern void bridging(void);
extern void wep(void);
extern void WirelessStat(void);
extern void stations(void);
extern void atmel_sysinfo(void);
extern void ap_search(void);

/* snmp engine*/
extern int snmp(varbind *, int, int);
extern int ber(char *, varbind *, int, int);

/* Function prototypes specific for ATMEL utility */
extern void reset(void);
extern void defaults(void);
extern void upload(void);
extern int  SysUpload(void);
extern int  SysReset(void);
extern void EthStat(void);
extern void APs(void);
extern void power(void);
extern void test(void);
extern void atmel_wireless(void);
extern void atmel_auth_mac(void);

/* Function prototypes specific for NWN utility */
extern void latest(void);
extern int  get_RegDomain(void);
extern void advanced(void);
extern void command_menu(void);
extern void nwn_sysinfo(void);
extern void nwn_wep(void);
extern void nwn_stations(void);
extern void nwn_wireless_stat(void);
extern void nwn_wireless(void);
extern void nwn_auth_mac(void);

#endif
