/*
 *      common.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include <stdlib.h>
#include <string.h>
#include <menu.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "ap-utils.h"
#include "config.h"

#define AUTODETECT _("Autodetect AP type? ")
#define APIP _("Access Point IP-address: ")
#define APPASS _("Password (community): ")
#define APTYPE _("AP type: ")
#define SAVESETTINGS _("Save connect-settings: ")

extern WINDOW *main_sub;
extern char *community, *prog_title;
extern short ap_type;
extern int sockfd;
extern struct in_addr ap_ip;
extern char *ap_types[];

void about()
{
    int nrow = 12, ncol = 47, brow = (LINES - 4 - nrow) / 2, bcol =
	(COLS - MCOLS - 2 - ncol) / 2, i;
    char message[100];

    noecho();
    curs_set(0);

    print_title(_("About"));

    /* drawing the box */
    mvwaddch(main_sub, brow, bcol, ACS_ULCORNER);
    mvwaddch(main_sub, brow, bcol + ncol, ACS_URCORNER);
    mvwaddch(main_sub, brow + nrow, bcol, ACS_LLCORNER);
    mvwaddch(main_sub, brow + nrow, bcol + ncol, ACS_LRCORNER);
    for (i = 1; i < ncol; i++) {
	mvwaddch(main_sub, brow, bcol + i, ACS_HLINE);
	mvwaddch(main_sub, brow + nrow, bcol + i, ACS_HLINE);
    }
    for (i = 1; i < nrow; i++) {
	mvwaddch(main_sub, brow + i, bcol, ACS_VLINE);
	mvwaddch(main_sub, brow + i, bcol + ncol, ACS_VLINE);
    }

    mvwaddstr(main_sub, brow + 1, bcol + 2, prog_title);
    sprintf(message, _("From %s"), TITLE);
    mvwaddstr(main_sub, brow + 2, bcol + 2, message);
    sprintf(message, _("Version %s"), VERSION);
    mvwaddstr(main_sub, brow + 3, bcol + 2, message);
    mvwaddstr(main_sub, brow + 5, bcol + 2,
	      _("Written by Roman Festchook roma@polesye.net"));
    mvwaddstr(main_sub, brow + 6, bcol + 2,
	      _("Copyright (c) Roman Festchook 2001-2004"));
    mvwaddstr(main_sub, brow + 7, bcol + 2, "http://ap-utils.polesye.net/");
    mvwaddstr(main_sub, brow + 9, bcol + 2,
	      _("This program is distributed under the terms"));
    mvwaddstr(main_sub, brow +10, bcol + 2,
	      _("of the GNU General Public License version 2."));
    mvwaddstr(main_sub, brow + 11, bcol + 2,
	      _("See the included COPYING file for details."));


    wrefresh(main_sub);

    print_help(ANY_KEY);
    getch();
    print_help("");
    print_title("");
    clear_main(0);
    return;
}

void connect_options(unsigned long int ip, int type)
{
    int i;
    struct sockaddr_in client;
    unsigned char message[16];
    int fd;
    char *home_dir;
    char save_settings=1;
    char sysDescr_NWN[] = { 0x2B, 0x06, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00 };
    char sysDescr_ATMEL410[] = { 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A,
	0x01, 0x01, 0x01, 0x01, 0x00 };
    char sysDescr_ATMEL12350[] = { 0x2B, 0x06, 0x01, 0x04, 0x01, 0xE0, 0x3E,
	0x01, 0x01, 0x01, 0x01, 0x00 };
    varbind varbinds[1];


    memset(&client, 0, sizeof client);
    client.sin_family = AF_INET;
    client.sin_port = INADDR_ANY;
    client.sin_addr.s_addr = INADDR_ANY;

    if (sockfd)
	close(sockfd);

    if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
	print_helperr(CREATE_SOCKET_ERROR);
	getch();
	goto exit;
    }

    if (bind(sockfd, (struct sockaddr *) &client, SIZE) == -1) {
	print_helperr(BIND_SOCKET_ERROR);
	getch();
	goto exit;
    }

    noecho();
    curs_set(0);

    print_title(_("Connect options"));

get_all_again:
    mvwaddstr(main_sub, 1, 1, APIP);
    if (ip) {
	ap_ip.s_addr = ip;
	mvwaddstr(main_sub, 1, 1 + strlen(APIP), inet_ntoa(ap_ip));
    } else {
	print_help(_("Enter IP address of your Access Point."));
	get_ip(&ap_ip, 1, 1 + strlen(APIP), NULL);
    }

    mvwaddstr(main_sub, 2, 1, APPASS);
    print_help(_("Entered characters will not be displayed "
	"for security reason."));
    get_pass(message, 2, 1 + strlen(APPASS), 16);
    if (community)
	free(community);
    i = strlen(message) + 1;
    community = (char *) malloc(i);
    strncpy(community, message, i);

    print_help("");
    if (type) {
	ap_type = --type;
	mvwaddstr(main_sub, 3, 1, APTYPE);
    } else {
	mvwaddstr(main_sub, 3, 1, AUTODETECT);
	wrefresh(main_sub);
	i = yes_no(3, 1 + strlen(AUTODETECT));
	clear_main_new(3, 4);
	mvwaddstr(main_sub, 3, 1, APTYPE);
	if (i == 2) { /* NO */
	    wrefresh(main_sub);
	    ap_type = menu_choose(3, 1 + strlen(APTYPE), ap_types, 3);
	} else { /* YES */
	    print_help(_("Determining AP type. Please wait..."));
	    varbinds[0].oid = sysDescr_NWN;
	    varbinds[0].len_oid = sizeof(sysDescr_NWN);
	    varbinds[0].value = NULL;
	    varbinds[0].len_val = 0;
	    varbinds[0].type = NULL_VALUE;
	    if (snmp(varbinds, 1, GET) > 0) {
		ap_type = NWN;
	    } else {
		varbinds[0].oid = sysDescr_ATMEL410;
		varbinds[0].len_oid = sizeof(sysDescr_ATMEL410);
		varbinds[0].value = NULL;
		varbinds[0].len_val = 0;
		varbinds[0].type = NULL_VALUE;
		if (snmp(varbinds, 1, GET) > 0) {
		    ap_type = ATMEL410;
		} else {
		    varbinds[0].oid = sysDescr_ATMEL12350;
		    varbinds[0].len_oid = sizeof(sysDescr_ATMEL12350);
		    varbinds[0].value = NULL;
		    varbinds[0].len_val = 0;
		    varbinds[0].type = NULL_VALUE;
		    if (snmp(varbinds, 1, GET) > 0) {
			ap_type = ATMEL12350;
		    } else {
			print_helperr(_("Unable to determine AP type "
			    "(no response). Press any key."));
			getch();
			clear_main_new(1, 4);
			goto get_all_again;
		    }
		}
	    }
	}			    
	wattrset(main_sub, A_BOLD);
    }
    waddstr(main_sub, ap_types[ap_type]);
    wattrset(main_sub, A_NORMAL);

    mvwaddstr(main_sub, 4, 1, SAVESETTINGS);
    wrefresh(main_sub);
    save_settings = on_off(4, 1 + strlen(SAVESETTINGS));

    print_bottom(inet_ntoa(ap_ip));

    if(save_settings == 1) {
	if ((home_dir = getenv("HOME"))) {
	    sprintf(message, "%s/.ap-config", home_dir);
	    if ((fd = open(message, O_CREAT | O_WRONLY | O_APPEND, 0600)) != -1) {
		sprintf(message, "%s:%s:%d\n", inet_ntoa(ap_ip),
		    community, ap_type);
		write(fd, message, strlen(message));
		close(fd);
	    }
	}
    }
  exit:
    print_help("");
    print_title("");
    clear_main(0);
    return;
}

void exit_program()
{
    endwin();
    exit(0);
}

void exit_shell()
{
    def_prog_mode();
    endwin();
    system("sh");
    curs_set(0);
    refresh();
}

/* 
 * Fill channels list string array using regulation domain
 * restrictions and return number of the channels
 */
int ch_list(int regulation_domain, char **list)
{
    int FIRST_CHANNEL, LAST_CHANNEL, i;

#ifndef NO_REG_DOMAIN
    switch (regulation_domain) {
    case 0x10:
    case 0x20:
	FIRST_CHANNEL = 1;
	LAST_CHANNEL = 11;
	break;
    case 0x30:
	FIRST_CHANNEL = 1;
	LAST_CHANNEL = 13;
	break;
    case 0x31:
	FIRST_CHANNEL = 10;
	LAST_CHANNEL = 11;
	break;
    case 0x32:
	FIRST_CHANNEL = 10;
	LAST_CHANNEL = 13;
	break;
    default: /* also case 0x40 */
#endif    
	FIRST_CHANNEL = 1;
	LAST_CHANNEL = 14;
#ifndef NO_REG_DOMAIN
    }
#endif    

    for (i = 0; i < LAST_CHANNEL - FIRST_CHANNEL + 1; i++) {
	list[i] = (char *) malloc(3);
	sprintf(list[i], "%02u", FIRST_CHANNEL + i);
    }
    return i;
}

