/*
 * dstumbler v1.0 [config.h]
 * by h1kari - (c) Dachb0den Labs 2001
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * polling speed in microseconds
 *
 * NOTE: if you set this too fast, the card won't be able to reset in time and
 * you won't get anything... make sure to try it out first on medium and then
 * tweak according to what your card can handle.
 *
 * 400000 - Faster
 * 600000 - Fast
 * 800000 - Medium
 * 1000000 - Slow
 * 1200000 - Slower
 */
#define POLLSPEED  1200000
#define SNIFFSPEED 100
#define MONSWSPEED 100000

/*
 * monitor mode channel switching definitions. with the channel switching
 * we use the card's cmd chan switching interface so it's more efficient.
 * this requires adhoc mode and allows us to switch through many channels,
 * very fast. change this number depending on the max freq allowed in your
 * area (e.g., US - 11, JP - 14, EU - 13 ?)
 */
#define SWITCH_CHANS 11

/*
 * define pcap options for monitor mode analysis
 */
#define PCAP_SNAPLEN 4096
#define PCAP_TOUT    256
#define PCAP_PROMISC 0

/*
 * speaker device options
 */
#define SPKR_DEV           "/dev/speaker"
#define SPKR_AP_PLAY_WEP   "mst200o2ola.l8bc.~a.~>l2d#"
#define SPKR_AP_PLAY_NOWEP "t240<cfcfgagaa#b#>dc"
#define SPKR_NODE_PLAY     "L8D"

/*
 * define indicator symbols
 */
#define APS_CUR     '>'
#define APS_NEW     '*'
#define APS_40BIT   '4'
#define APS_WEP     'w'
#define APS_NOWEP   'n'
#define APS_ADHOC   'a'
#define APS_BSS     'b'
#define APS_KEYED   'k'
#define APS_OPEN    'o'
#define APS_DEFSSID 'd'

#define NODE_CUR    '>'
#define NODE_NEW    '*'
#define NODE_WEP    'w'
#define NODE_NOWEP  'n'
#define NODE_ADHOC  'a'
#define NODE_BSS    'b'
#define NODE_KEYED  'k'
#define NODE_OPEN   'o'
#define NODE_ANY    'a'
#define NODE_SET    's'

/*
 * define graph symbols
 */
#define GRAPH_SIGNAL  '+'
#define GRAPH_NOISE   '-'

/*
 * definitions to use for ncurses characters when -n is used
 */
#define BORDER_HLINE '-'
#define BORDER_VLINE '|'
#define BORDER_PLUS  '+'
#define BORDER_BTEE  '+'

#define BORDER_CHAR(x) (ncurse ? ACS_x : BORDER_x)

/*
 * define manufacturer info
 */
#define MFG_INFO {\
  { { 0x00, 0x00, 0xf0 }, "Samsung" }, \
  { { 0x00, 0x00, 0xff }, "Camtec" }, \
  { { 0x00, 0x01, 0x03 }, "3Com" }, \
  { { 0x00, 0x01, 0xf4 }, "Enterasys" }, \
  { { 0x00, 0x02, 0x2d }, "Agere-Lucent" }, \
  { { 0x00, 0x02, 0x6f }, "Senao Intl" }, \
  { { 0x00, 0x02, 0x78 }, "Samsung" }, \
  { { 0x00, 0x02, 0xb3 }, "Intel" }, \
  { { 0x00, 0x03, 0x2f }, "GST-Linksys" }, \
  { { 0x00, 0x04, 0x25 }, "Atmel" }, \
  { { 0x00, 0x04, 0x5a }, "Linksys" }, \
  { { 0x00, 0x04, 0x76 }, "3Com" }, \
  { { 0x00, 0x05, 0x5d }, "D-Link" }, \
  { { 0x00, 0x10, 0xe7 }, "BreezeNet" }, \
  { { 0x00, 0x20, 0xd8 }, "NetWave-Bay" }, \
  { { 0x00, 0x30, 0x65 }, "Apple" }, \
  { { 0x00, 0x30, 0xab }, "Delta Networks" }, \
  { { 0x00, 0x40, 0x05 }, "D-Link" }, \
  { { 0x00, 0x40, 0x33 }, "Addtron" }, \
  { { 0x00, 0x40, 0x36 }, "Zoom-Tribe" }, \
  { { 0x00, 0x40, 0x96 }, "Cisco-Aironet" }, \
  { { 0x00, 0x50, 0x18 }, "Adv Multimedia" }, \
  { { 0x00, 0x50, 0x8b }, "Compaq" }, \
  { { 0x00, 0x50, 0xda }, "3Com" }, \
  { { 0x00, 0x60, 0x1d }, "Agere-Lucent" }, \
  { { 0x00, 0x90, 0x4d }, "Gemtek-D-Link" }, \
  { { 0x00, 0x90, 0xd1 }, "Addtron" }, \
  { { 0x00, 0xa0, 0xf8 }, "Symbol" }, \
  { { 0x00, 0xe0, 0x03 }, "Nokia" }, \
  { { 0x00, 0xe0, 0x29 }, "SMC" }, \
  { { 0x00, 0x04, 0xe2 }, "SMC" }, \
  { { 0x00, 0xe0, 0x63 }, "Enterasys" }, \
  { { 0x08, 0x00, 0x02 }, "3Com" }, \
  { { 0x08, 0x00, 0x46 }, "Sony" } \
}

#define MFG_LEN     33
#define MFG_MACSIZE 3
#define MFG_STRLEN  16
#define MFG_DEFAULT "N/A"

/*
 * define default ap ssids
 */
#define DEFSSID_INFO {\
  "comcomcom",    /* 3com AirConnect 2.4 Ghz DS */ \
  "2",            /* Cisco Aironet */ \
  "tsunami",      /* Cisco Aironet */ \
  "Default SSID", /* BayStack */ \
  "Compaq",       /* Compaq */ \
  "WLAN",         /* Dlink DL-713 802.11 DS AP */ \
  "101",          /* INTEL Pro/Wireless 2011 - WLAN Monitor */ \
  "xlan",         /* INTEL Pro/Wireless 2011 - WLAN Info program */ \
  "intel",        /* INTEL Pro/Wireless 2011 - Wireless Lan Profile Manager */ \
  "195",          /* INTEL Pro/Wireless 2011 - Access POINT/REPEATER/BRIDGE */ \
  "linksys",      /* LINKSYS WAP-11 802.11 DS AP */ \
  "Wireless",     /* Netgear 802.11 DS products, ME102 and MA401 */ \
  "WLAN",         /* SMC Access Point Family */ \
  "BRIDGE",       /* EZ-Connect Wireless Bridge, Single Dipole */ \
  "0080c6",       /* SOHOware NetBlaster II */ \
  "any",          /* TELETRONICS WL-Access Points (1/2 Mbit, and 11 Mbit */ \
  "mello",        /* ZCOMAX 1/2 Mbit DS 802.11 */ \
  "Test",         /* ZCOMAX 1/2 Mbit DS 802.11 */ \
  "default",      /* D-Link (?) DS AP */ \
  "INTERMEC"      /* INTERMEC Agere-Lucent gear */ \
}

#define DEFSSID_LEN 20

/*
 * -1 allows you to use xterms with graphic backgrounds.
 * if you prefer black, set to COLOR_BLACK
 */
#define COLOR_DEFAULT       -1

/*
 * color definitions
 */
#define BORDER_COLOR        COLOR_PAIR(COLOR_BLUE)
#define BORDER_COLOR_BOLD   COLOR_PAIR(COLOR_CYAN)
#define BANNER_COLOR        (COLOR_PAIR(COLOR_BLUE) | A_BOLD)
#define BANNER_COLOR_BOLD   (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define ALERT_COLOR         (COLOR_PAIR(COLOR_BLUE) | A_BOLD)
#define ALERT_COLOR_BOLD    (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define MENU_COLOR          (COLOR_PAIR(COLOR_BLUE) | A_BOLD)
#define MENU_COLOR_BOLD     (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define INFO_COLOR          (COLOR_PAIR(COLOR_BLUE) | A_BOLD)
#define INFO_COLOR_BOLD     (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define AP_COLOR            (COLOR_PAIR(COLOR_BLUE) | A_BOLD)
#define AP_COLOR_BOLD       (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define AP_COLOR_SEL        COLOR_PAIR(COLOR_CYAN)
#define AP_COLOR_SEL_BOLD   (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define AP_COLOR_CURR       (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define AP_COLOR_NEW        (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define AP_COLOR_WEPED      (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define AP_COLOR_NOWEP      (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define AP_COLOR_ADHOC      (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define AP_COLOR_BSS        (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define AP_COLOR_KEYED      (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define AP_COLOR_OPEN       (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define AP_COLOR_DEFSSID    (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define NODE_COLOR          (COLOR_PAIR(COLOR_BLUE) | A_BOLD)
#define NODE_COLOR_BOLD     (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define NODE_COLOR_SEL      COLOR_PAIR(COLOR_CYAN)
#define NODE_COLOR_SEL_BOLD (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define NODE_COLOR_CURR     (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define NODE_COLOR_NEW      (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define NODE_COLOR_WEPED    (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define NODE_COLOR_NOWEP    (COLOR_PAIR(COLOR_GREEN) | A_BOLD) 
#define NODE_COLOR_ADHOC    (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define NODE_COLOR_BSS      (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define NODE_COLOR_KEYED    (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define NODE_COLOR_OPEN     (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define NODE_COLOR_SET      (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define NODE_COLOR_ANY      (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define GRAPH_COLOR         COLOR_PAIR(COLOR_CYAN)
#define GRAPH_COLOR_BOLD    (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define GRAPH_COLOR_SIGNAL  (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
#define GRAPH_COLOR_NOISE   (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define PROMPT_COLOR        (COLOR_PAIR(COLOR_BLUE) | A_BOLD)
#define PROMPT_COLOR_BOLD   (COLOR_PAIR(COLOR_CYAN) | A_BOLD)
#define COLOR_CODE_LOW      COLOR_PAIR(COLOR_RED)
#define COLOR_CODE_LOW_BOLD (COLOR_PAIR(COLOR_RED) | A_BOLD)
#define COLOR_CODE_MED      COLOR_PAIR(COLOR_YELLOW)
#define COLOR_CODE_MED_BOLD (COLOR_PAIR(COLOR_YELLOW) | A_BOLD)
#define COLOR_CODE_HI       COLOR_PAIR(COLOR_GREEN)
#define COLOR_CODE_HI_BOLD  (COLOR_PAIR(COLOR_GREEN) | A_BOLD)
