/*
 * dwepcrack v0.4 [main.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "dwepcrack.h"

extern char *optarg;
extern int optind;

/*
 * print program usage
 */
void
usage(char *progname)
{
  printf("usage: %s [-j <jobs>] [-b [-e] | -w [-f <fudge>]] [-s] "
   "<logfile> [wordfile]\n"
   " -j: number of processes to run (useful for smp systems)\n"
   " -b: brute force key by exhausting all probable possibilities\n"
   " -e: search the entire key width (will take a while)\n"
   " -w: use weak ksa attack\n"
   " -f: fudge the probability scope by specified count (might take a while)\n"
   " -s: file uses 104-bit wep\n", progname);
  exit(2);
}

/*
 * process user arguments and start pcap offline loop with specified
 * file.
 */
#define KEY_SIZE 5
int
main(int argc, char *argv[])
{
  int c;
  char *filename, *wordfile, *progname = argv[0];

  jobs = 0;
  brute = 0;
  entire = 0;
  weakksa = 0;
  fudge = 0;
  strong = 0; 
  children = 0;

  while((c = getopt(argc, argv, "j:bewf:s")) != -1)
  {
    switch(c)
    {
      case 'j':
        jobs = MAX(atoi(optarg), 0);
        break;
      case 'b':
        brute = 1;
        break;
      case 'e':
        entire = 1;
        break;
      case 'w':
        weakksa = 1;
        break;
      case 'f':
        fudge = MAX(atoi(optarg), 1);
        break;
      case 's':
        strong = 1;
        break;
      default:
        break;
    }
  }

  argc -= optind;
  argv += optind;

  if(argc < 1 || (!weakksa && !brute && argc < 2))
    usage(progname);

  filename = argv[0];
  wordfile = argv[1];

  printf("\n%s\n", BANNER);
  getscrmaxyx();

  if(brute)
  {
    if(entire || !strong)
      brutecrack(filename);
    else
    {
      fprintf(stderr, "error: unable to brute force 104-bit without "
       "searching entire key space\n");
      exit(2);
    }
  }
  else if(weakksa)
    weakksacrack(filename);
  else
    wordcrack(filename, wordfile);

  exit(0);
}

/*
 * make sure we properly reap our zombie children
 */
void
chld_handler(int sig)
{
  int status;
  pid_t pid;

  pid = wait(&status);
  children--;
  signal(SIGCHLD, chld_handler);

  if(WEXITSTATUS(status) == 0)
    children = 0;
}
