#!/bin/sh

# configuration options
prefix=/usr
incprefix=$prefix/include
batinc=$incprefix/bat

# start the installation process
rm -f install.log >/dev/null 2>&1

echo
echo "*** installing bsd-airtools source-mods v0.2 ***"
echo "*** by h1kari - (c) 2001 Dachb0den Labs ***"
echo

echo -n "checking for host os... "

if (test $1); then
  hostos=$1
else
  hostos=`(uname -sr) 2>/dev/null`
fi

# set configuration options based on the os
case $hostos in
  "NetBSD 1.5.2"*)
    hostos="netbsd"; echo $hostos

    wi_ieee_h="dev/pcmcia/wi_ieee.h" ;;
  "NetBSD"*)
    hostos="netbsd"; echo $hostos

    wi_ieee_h="dev/ic/wi_ieee.h" ;;
  "OpenBSD 2.9"*)
    hostos="openbsd-2.9"; echo $hostos 

    wi_ieee_h="dev/pcmcia/if_wavelan_ieee.h" ;;
  "OpenBSD 3.0"*)
    hostos="openbsd-3.0"; echo $hostos

    wi_ieee_h="dev/ic/if_wi_ieee.h" ;;
  "FreeBSD 4.4"*)
    hostos="freebsd-4.4"; echo $hostos

    wi_ieee_h="machine/if_wavelan_ieee.h" ;;
  *)
    hostos="unsupported"; echo $hostos;
    echo
    echo "** unable to determine host os **"
    echo "the installation script was either unable to determine your os, or "
    echo "your current os isn't supported. if your system is supported, try "
    echo "specifying it when running $0 <os>."
    echo
    exit 2 ;;
esac

echo -n "writing common.h with os-specific information... "

# replace CFLAGS and LDFLAGS in config file with os dependant values
sed -e "s%@wi_ieee_h@%$wi_ieee_h%" common/common.h.in >common/common.h

echo "done"

echo -n "installing common.h into $batinc... "
if (test ! -d $batinc.); then
  mkdir -p $batinc >>install.log 2>&1
fi
cp common/common.h $batinc >>install.log 2>&1
echo "done"

# patch sources
PATCHDIR=$PWD

# grab definitions for operating system
. $hostos/config.sh

echo -n "patching kernel sources... "
if(! patch -d /usr/src -p1 < $PATCHDIR/$hostos/kernel.diff >>install.log 2>&1); then
  echo
  echo "** unable to patch kernel sources **"
  echo "the kernel patches did not apply cleanly. please check the install.log "
  echo "for errors."
  echo
  exit 2
fi
echo "done"

echo -n "patching $WICONF sources... "
if(! patch -d /usr/src -p1 < $PATCHDIR/$hostos/$WICONF.diff >>install.log 2>&1); then
  echo
  echo "** unable to patch $WICONF sources **"
  echo "the $WICONF patches did not apply cleanly. please check the "
  echo "install.log for errors."
  echo
  exit 2
fi
echo "done"

# rebuild wiconfig
echo -n "rebuilding $WICONF... "
sh -c "(cd $WICONFPATH; $MAKECMD)" >>install.log 2>&1
echo "done"

# inform user to rebuild kernel
echo
echo "** your system has been successfully modified for bsd-airtools **"
echo "you must now rebuild your kernel, and make sure you include wi support."
echo
