#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#ifdef __OLD_DB__
#include <db1/db.h>
#else
#include <db_185.h>
#endif

#include "nmea/gpgll.h"
#include "gps_db.h"

#include "skan.h"
#include "skan_config.h"

extern gtkskan_config_t skan_conf;
static DB * gps_db = NULL;

/* i'm not checking the return values here because i don't remember what 
   they are and don't have the man page handy */

void gps_db_open(void)
{
  GString *path = g_string_new(g_get_home_dir());
  BTREEINFO infozzz = { R_DUP, 0, 0, 0, 0, 0, 0, 0 };

  g_string_append(path, "/.gtkskan-gps-db");

  if(gps_db == NULL) {
    gps_db = dbopen(path->str, O_RDWR|O_CREAT, 0664, DB_BTREE, &infozzz);
    atexit(gps_db_close);
    g_string_free(path, TRUE);
  }
}

void gps_db_sync(void)
{
  gps_db_open();
  (gps_db)->sync(gps_db, 0);
}

void gps_db_close(void)
{
  if(gps_db != NULL) {
    (gps_db)->close(gps_db);
  }
}

int gps_db_save_data(gps_gpgll *gps, char *ap_mac, int strength)
{
  DBT key   = { 0, 0 };
  DBT value = { 0, 0 };

  char keybuf[strlen(ap_mac) + 4];

  gps_db_open();

  memset(keybuf, 0, sizeof(keybuf));
  sprintf(keybuf, "%s%d", ap_mac, strength);

  key.data   = keybuf;
  key.size   = strlen(keybuf) + 1;

  value.data = gps;
  value.size = sizeof(gps_gpgll);

  (gps_db)->put(gps_db, &key, &value, 0);

  return 1;
}

gps_record * gps_db_lookup_strongest(const char *ap_mac)
{
  DBT key    = { 0, 0 };
  DBT value  = { 0, 0 };
  char keybuf[strlen(ap_mac) + 1];

  if(ap_mac == NULL)
    return 0;

  key.data = keybuf;
  key.size = strlen(ap_mac) + 1;
  
  strcpy(keybuf, ap_mac);

  keybuf[strlen(ap_mac)] += 1;

  gps_db_open();

  if((gps_db)->seq(gps_db, &key, &value, R_CURSOR) < 0) {
    if((gps_db)->seq(gps_db, &key, &value, R_LAST) < 0) {
      return NULL;
    }
  }

  (gps_db)->seq(gps_db, &key, &value, R_PREV);
  
  if(strncmp((char*)key.data, ap_mac, strlen(ap_mac)) != 0)
    return NULL;
  
  if(value.size == sizeof(gps_gpgll)) {
    gps_record * outbuf = (gps_record*)calloc(1, sizeof(gps_record));

    memcpy(&outbuf->value, value.data, value.size);
    memcpy(outbuf->key.ap_mac, keybuf, 18);

    outbuf->key.link_quality = atoi(keybuf+18);

    return outbuf;
  }
  
  return NULL;
}

gps_record * gps_db_lookup(const char *ap_mac, int n)
{
  DBT key    = { 0, 0 };
  DBT value  = { 0, 0 };
  char keybuf[strlen(ap_mac) + 1];
  int i = 0;

  if(ap_mac == NULL)
    return 0;

  key.data = keybuf;
  key.size = strlen(ap_mac) + 1;
  
  strcpy(keybuf, ap_mac);

  gps_db_open();

  if((gps_db)->seq(gps_db, &key, &value, R_CURSOR) < 0 ||
     strncmp((char*)key.data, ap_mac, strlen(ap_mac)) != 0) {
    return NULL;
  }

  if(n == 0)
    goto done; /* ouch - lazy am i */
  
  while(i++ < n) {
    if((gps_db)->seq(gps_db, &key, &value, R_NEXT) < 0)
      return NULL;

    if(strncmp((char*)key.data, ap_mac, strlen(ap_mac)) != 0)
      return NULL;
  }

done:  
  if(value.size == sizeof(gps_record)) {
    gps_record * outbuf = (gps_record*)calloc(1, sizeof(gps_record));

    memcpy(&outbuf->value, value.data, value.size);
    memcpy(outbuf->key.ap_mac, keybuf, 18);

    outbuf->key.link_quality = atoi(keybuf+18);

    return outbuf;
  }
  
  return NULL;
}

int gps_db_exists(const char *ap_mac)
{
  DBT key = { 0, 0 };
  DBT value = { 0, 0 };
  char keybuf[strlen(ap_mac) + 1];

  if(ap_mac == NULL)
    return 0;

  gps_db_open();

  key.data  = keybuf;
  key.size  = strlen(ap_mac) + 1;

  strcpy(keybuf, ap_mac);

  if((gps_db)->seq(gps_db, &key, &value, R_CURSOR) >= 0) {
    if(strncmp((char*)key.data, ap_mac, strlen(ap_mac)) == 0) {
      return 1;
    }
  }

  return 0;
}

void gps_db_iterate(void (*func)(gps_record *, void *), void *user)
{
  DBT key   = { 0, 0 };
  DBT value = { 0, 0 };
  gps_record record;

  gps_db_open();

  (gps_db)->seq(gps_db, &key, &value, R_FIRST);
  if(key.size == 0)
    return;

  do {
    memset(&record, 0, sizeof(record));

    memcpy(&(record.value), value.data, sizeof(gps_record));
    memcpy(record.key.ap_mac, key.data, 18);

    record.key.link_quality = atoi((char*)key.data + 18);

    func(&record, user);
  } while((gps_db)->seq(gps_db, &key, &value, R_NEXT) == 0);    
}
