#ifndef __GPS_DB_H__
#define __GPS_DB_H__

#ifdef __OLD_DB__
#include <db1/db.h>
#else
#include <db_185.h>
#endif

#include "nmea/gpgll.h"

#define GPS_DB "gps.db"

typedef struct gps_record {
  struct {
    char ap_mac[18];
    int  link_quality;
  } key;

  gps_gpgll value;
} gps_record;
  

int gps_db_save_data(gps_gpgll *gps, char *ap_mac, int strength);
int gps_db_exists(const char *ap_mac);
gps_record * gps_db_lookup_data(const char *ap_mac);
gps_record * gps_db_lookup_strongest(const char *ap_mac);
gps_record * gps_db_lookup(const char *ap_mac, int n);

void gps_db_iterate(void (*func)(gps_record *, void *), void *);

void gps_db_open(void);
void gps_db_sync(void);
void gps_db_close(void);

#endif
