#include <stdio.h>

#ifdef __OLD_DB__
#include <db1/db.h>
#else
#include <db_185.h>
#endif

#include "gtkskan.h"
#include "scan_data.h"
#include "network_db.h"
#include "skan.h"
#include <esd.h>
#include "skan_config.h"

extern gtkskan_config_t skan_conf;

static DB * network_db = NULL;

/* i'm not checking the return values here because i don't remember what 
   they are and don't have the man page handy */

int network_db_open(void)
{
	GString *path = g_string_new(g_get_home_dir());
	g_string_append(path, "/.gtkskan-db");
	
  if(network_db == NULL) {
    if ((network_db = dbopen(path->str, O_RDWR|O_CREAT, 0664, DB_BTREE, NULL)) == NULL) {
		g_string_free(path, TRUE);	
		return 0;
	}
    atexit(network_db_close);
  }
  g_string_free(path, TRUE);
  return 1;
}

void network_db_sync(void)
{
  network_db_open();
  (network_db)->sync(network_db, 0);
}

void network_db_close(void)
{
  if(network_db != NULL) {
    (network_db)->close(network_db);
  }
}

int network_db_delete_data(scan_data_t *scan)
{
	DBT key = { 0, 0 };
	scan_data_t * temp;
	if (scan == NULL) return 0;

	network_db_open();

	if ((temp = network_db_lookup_data(scan->ap_mac)) == NULL)
		return 0;
	else free(temp);
	
	key.data = scan->ap_mac;
	key.size = strlen(scan->ap_mac) + 1;

	(network_db)->del(network_db, &key, 0);

	return 1;
}

int network_db_save_data(scan_data_t *scan)
{
  DBT key   = { 0, 0 };
  DBT value = { 0, 0 };
  scan_data_t * temp;
	if (strlen(scan->essid)==0) return 0;
  network_db_open();
	if ((temp = network_db_lookup_data(scan->ap_mac)) == NULL && skan_conf.sound) 
		esd_play_file(NULL, skan_conf.snd_path, 1);
	else free(temp);

  key.data   = scan->ap_mac;
  key.size   = strlen(scan->ap_mac) + 1;

  value.data = scan;
  value.size = sizeof(scan_data_t);

  (network_db)->put(network_db, &key, &value, 0);
	gtkskan_update_netcount();
  return 1;
}

scan_data_t * network_db_lookup_data(const char *ap_mac)
{
  DBT key    = { 0, 0 };
  DBT value  = { 0, 0 };
  char keybuf[strlen(ap_mac) + 1];

  if(ap_mac == NULL)
    return 0;

  key.data = keybuf;
  key.size = strlen(ap_mac) + 1;
  
  strcpy(keybuf, ap_mac);

  network_db_open();

  (network_db)->get(network_db, &key, &value, 0);

  if(value.size == sizeof(scan_data_t)) {
    scan_data_t * outbuf = (scan_data_t*)calloc(1, sizeof(scan_data_t));
    memcpy(outbuf, value.data, value.size);
    return outbuf;
  }
  
  return NULL;
}

int network_db_exists(const char *ap_mac)
{
  DBT key = { 0, 0 };
  DBT value = { 0, 0 };
  char keybuf[strlen(ap_mac) + 1];

  if(ap_mac == NULL)
    return 0;

  network_db_open();

  key.data  = keybuf;
  key.size  = strlen(ap_mac) + 1;

  strcpy(keybuf, ap_mac);

  (network_db)->get(network_db, &key, &value, 0);

  if(value.size)
    return 1;

  return 0;
}

void network_db_iterate(void (*func)(scan_data_t *, void *), void *user)
{
  DBT key   = { 0, 0 };
  DBT value = { 0, 0 };

  if (!network_db_open()) return;

  (network_db)->seq(network_db, &key, &value, R_FIRST);
  if(key.size == 0)
    return;

  do {
    func((scan_data_t*)value.data, user);
  } while((network_db)->seq(network_db, &key, &value, R_NEXT) == 0);    
}
