#ifndef __NETWORK_DB_H__
#define __NETWORK_DB_H__

#ifdef __OLD_DB__
#include <db1/db.h>
#else
#include <db_185.h>
#endif

#include "scan_data.h"

#define NETWORK_DB "network.db"

int network_db_save_data(scan_data_t *);
int network_db_delete_data(scan_data_t *);
int network_db_exists(const char *ap_mac);
scan_data_t * network_db_lookup_data(const char *ap_mac);

void network_db_iterate(void (*func)(scan_data_t *, void *), void *);

int network_db_open(void);
void network_db_sync(void);
void network_db_close(void);

#endif
