#include <stdlib.h>
#include <string.h>

#include "gpgll.h"

#include "sentences.h"

#define SENTENCE_HEAD  0
#define LATITUDE       1
#define NORTH_SOUTH    2 
#define LONGITUDE      3
#define WEST_EAST      4
#define N_GPGLL_FIELDS 5

gps_gpgll * gps_gpgll_new(void)
{
  gps_gpgll * foo = (gps_gpgll*)calloc(1, sizeof(gps_gpgll));
  return foo;
}

void gps_gpgll_delete(gps_gpgll ** dead)
{
  free(*dead);
  *dead = NULL;
}

int
parse_gpgll(const char * sentence, gps_gpgll * out)
{
  const char *fields[N_GPGLL_FIELDS];
  char * copy = strdup(sentence);

  sentence_parse(copy, fields, N_GPGLL_FIELDS);
  
  { 
    int degrees;
    float minutes;

    parse_latlong(fields[LONGITUDE], &degrees, &minutes);

    out->longitude.degrees = degrees;
    out->longitude.minutes = minutes;
    out->longitude.dir     = string_to_direction(fields[WEST_EAST]);
    
    parse_latlong(fields[LATITUDE], &degrees, &minutes);
    out->latitude.degrees = degrees;
    out->latitude.minutes = minutes;
    out->latitude.dir     = string_to_direction(fields[NORTH_SOUTH]);

  }
 
  free(copy);

  return 1;
}
