#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "nmea-util.h"

char
direction_to_char(direction dir)
{
  switch(dir) {
  case NORTH:
    return 'N';
  case SOUTH:
    return 'S';
  case WEST:
    return 'W';
  case EAST:
    return 'E';
  default:
    return 'U';
  }
}

const char *
direction_to_string(direction dir)
{
  switch(dir) {
  case NORTH:
    return "North";
  case SOUTH:
    return "South";
  case WEST:
    return "West";
  case EAST:
    return "East";
  default:
    return "Unknown";
  }
}

direction string_to_direction(const char *string)
{
  switch (string[0]) {
  case 'N':
    return NORTH;
  case 'S':
    return SOUTH;
  case 'W':
    return WEST;
  case 'E':
    return EAST;
  default:
    return UNKNOWN_DIRECTION;
  }
}

static void chomp(char *data)
{
  data = strchr(data, '\n');
  if(data != NULL) *data = '\0';
}

int
sentence_parse(char *data, const char ** out, int max)
{
  int i;

  chomp(data);
  
  for(i = 0; i < max; i++) {
    out[i] = data;
   
    {
      char *comma = strchr(data, ',');

      if(comma != NULL) {
	*comma++ = '\0';
	while(isspace(*comma)) comma++;

      } else {
	/* checksums are posted after a *, not a comma */
	comma = strchr(data, '*');
	if(comma != NULL)
	  *comma++ = '\0';
      }
      
      data = comma;
    }
  }
  
  return 1;
}

void 
parse_latlong(const char *data_in, int *degrees, float *mins)
{
  char *data = strdup(data_in);
  char *dot  = strchr(data, '.');


  if(dot == NULL) {
    *mins = 0.00;
    *degrees = 0;
    free(data);
  }
     
  /* we are at the dot in something like 3751.65
     this is 37 degrees, 51.65 minutes */
  dot -= 2;
  *mins = atof(dot);
  *dot = '\0';
  *degrees = atoi(data);

  free(data);
}
