#ifndef __GPS_SENTENCE_H__
#define __GPS_SENTENCE_H__

typedef enum {
  UNKNOWN = 0,
  GPBOD, /* Bearing, Origin, Destination */
  GPBWC, /* Bearing and distance to waypint, great circle */
  GPGGA, /* GPS Fix Data */
  GPGLL, /* Geographic Position, Longitude, Latitude */
  GPGSA, /* GPS DOP and active satellites */
  GPGSV, /* GPS Satellites in view */
  GPHDT, /* Heading, True */
  GPR00, /* list of waypoints in currently active route */
  GPRMA, /* recommended minimum specific Loran-C data */
  GPRMB, /* recommended minimum navigation info */
  GPRMC, /* recommended minimum specific GPS/Transit data */
  GPRTE, /* Routes */
  GPTRF, /* Transit Fix Data */
  GPSTN, /* Multiple Data Id */
  GPVBW, /* Dual Ground / Water Speed */
  GPVTG, /* track made good and ground speed */
  GPWPL, /* waypoint location */
  GPXTE, /* cross-track error, measured */
  GPZDA, /* Date & Time */
  N_SENTENCES
} gps_sentence;

#endif
  
